/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.travoltage.TravoltageModel;
import java.applet.Applet;
import java.applet.AudioClip;
import java.net.URL;
import java.util.Random;

public class TravoltageAudio
implements Runnable {
    private AudioClip[] clips;
    private boolean isPlaying;
    private static final Random random = new Random();
    private int napTime = 1000;
    private boolean sparkFinished = true;

    public TravoltageAudio(TravoltageModel travoltageModel) {
        travoltageModel.addListener(new TravoltageModel.Listener(){

            public void sparkStarted() {
            }

            public void sparkFinished() {
                TravoltageAudio.this.sparkFinished = true;
            }

            public void electronExitedFinger() {
                if (TravoltageAudio.this.sparkFinished) {
                    TravoltageAudio.this.play();
                    TravoltageAudio.this.sparkFinished = false;
                }
            }
        });
        AudioClip audioClip = Applet.newAudioClip(TravoltageAudio.findResource("travoltage/audio/OuchSmallest.wav"));
        AudioClip audioClip2 = Applet.newAudioClip(TravoltageAudio.findResource("travoltage/audio/ShockSmallest.wav"));
        this.clips = new AudioClip[]{audioClip, audioClip2};
    }

    public static URL findResource(String string) {
        ClassLoader classLoader = TravoltageAudio.class.getClassLoader();
        return classLoader.getResource(string);
    }

    public void run() {
        try {
            Thread.sleep(this.napTime);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.isPlaying = false;
    }

    public void play() {
        if (this.isPlaying) {
            return;
        }
        this.isPlaying = true;
        int n = random.nextInt(this.clips.length);
        this.clips[n].play();
        new Thread(this).start();
    }
}

