/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.travoltage.ArmNode;
import edu.colorado.phet.travoltage.LegNode;
import edu.colorado.phet.travoltage.LocationMap;
import edu.colorado.phet.travoltage.TravoltageBodyNode;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class LimbLocationMap
implements LocationMap {
    private LegNode legNode;
    private ArmNode armNode;
    private LocationMap defaultMap;
    private TravoltageBodyNode bodyNode;

    public LimbLocationMap(LegNode legNode, ArmNode armNode, LocationMap locationMap, TravoltageBodyNode travoltageBodyNode) {
        this.legNode = legNode;
        this.armNode = armNode;
        this.defaultMap = locationMap;
        this.bodyNode = travoltageBodyNode;
    }

    public Point2D getLocation(Point2D point2D) {
        Rectangle rectangle = new Rectangle();
        rectangle.setFrameFromDiagonal(128.0, 237.0, 279.0, 399.0);
        if (rectangle.contains(point2D)) {
            Point2D point2D2 = this.legNode.getGlobalPivot();
            point2D2 = this.bodyNode.globalToLocal(point2D2);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.legNode.getAngle(), point2D2.getX(), point2D2.getY());
            return this.defaultMap.getLocation(affineTransform.transform(point2D, null));
        }
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setFrameFromDiagonal(198.0, 118.0, 330.0, 200.0);
        if (rectangle2.contains(point2D)) {
            Point2D point2D3 = this.armNode.getGlobalPivot();
            point2D3 = this.bodyNode.globalToLocal(point2D3);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.armNode.getAngle(), point2D3.getX(), point2D3.getY());
            return this.defaultMap.getLocation(affineTransform.transform(point2D, null));
        }
        return this.defaultMap.getLocation(point2D);
    }
}

