/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.travoltage.JadeElectron;
import java.util.ArrayList;

public class JadeElectronSet {
    private ArrayList jadeElectrons = new ArrayList();
    private ArrayList listeners = new ArrayList();

    public void addElectron(JadeElectron jadeElectron) {
        this.jadeElectrons.add(jadeElectron);
        this.notifyListeners(jadeElectron);
    }

    public int getNumElectrons() {
        return this.jadeElectrons.size();
    }

    public JadeElectron getJadeElectron(int n) {
        return (JadeElectron)this.jadeElectrons.get(n);
    }

    public void removeElectron(int n) {
        JadeElectron jadeElectron = (JadeElectron)this.jadeElectrons.remove(n);
        this.notifyElectronRemoved(jadeElectron);
    }

    private void notifyElectronRemoved(JadeElectron jadeElectron) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.electronRemoved(jadeElectron);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners(JadeElectron jadeElectron) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.electronAdded(jadeElectron);
        }
    }

    public static class Adapter
    implements Listener {
        public void electronAdded(JadeElectron jadeElectron) {
        }

        public void electronRemoved(JadeElectron jadeElectron) {
        }
    }

    public static interface Listener {
        public void electronAdded(JadeElectron var1);

        public void electronRemoved(JadeElectron var1);
    }
}

