/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.timeseries.TimeSeriesModel;
import edu.colorado.phet.theramp.view.RampFontSet;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.text.DecimalFormat;
import java.text.MessageFormat;

public class TimeGraphic
extends PNode
implements ModelElement {
    private TimeSeriesModel timeModel;
    private DecimalFormat format = new DecimalFormat("0.00");
    public PText phetTextGraphic;

    public TimeGraphic(TimeSeriesModel timeSeriesModel) {
        this.timeModel = timeSeriesModel;
        this.phetTextGraphic = new PText("");
        this.phetTextGraphic.setFont(RampFontSet.getFontSet().getTimeReadoutFont());
        this.addChild(this.phetTextGraphic);
        this.stepInTime(0.0);
    }

    public void stepInTime(double d) {
        double d2 = this.timeModel.getTime();
        String string = MessageFormat.format(TheRampStrings.getString("readout.seconds"), this.format.format(d2));
        this.phetTextGraphic.setText(string);
    }
}

