/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.theramp.view.SurfaceGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class RampTickSetGraphic
extends PNode {
    private SurfaceGraphic surfaceGraphic;
    private ArrayList tickGraphics = new ArrayList();

    public RampTickSetGraphic(SurfaceGraphic surfaceGraphic) {
        this.surfaceGraphic = surfaceGraphic;
        int n = 0;
        while ((double)n <= surfaceGraphic.getSurface().getLength()) {
            double d = n;
            this.addTickGraphic(d);
            ++n;
        }
    }

    private void addTickGraphic(double d) {
        TickGraphic tickGraphic = new TickGraphic(d);
        this.tickGraphics.add(tickGraphic);
        this.addChild(tickGraphic);
    }

    public void update() {
        for (int i = 0; i < this.tickGraphics.size(); ++i) {
            TickGraphic tickGraphic = (TickGraphic)this.tickGraphics.get(i);
            tickGraphic.update();
        }
    }

    public class TickGraphic
    extends PNode {
        private double x;
        private PPath phetShapeGraphic;

        public TickGraphic(double d) {
            this.x = d;
            this.phetShapeGraphic = new PPath(new Line2D.Double(0.0, 0.0, 0.0, 7.0));
            this.phetShapeGraphic.setStroke(new BasicStroke(2.0f));
            this.phetShapeGraphic.setPaint(Color.black);
            this.addChild(this.phetShapeGraphic);
            this.update();
        }

        public void update() {
            Point2D point2D = RampTickSetGraphic.this.surfaceGraphic.getSurface().getLocation(this.x);
            this.setTransform(new AffineTransform());
            this.setOffset(RampTickSetGraphic.this.surfaceGraphic.getViewLocation(point2D));
            this.rotate(RampTickSetGraphic.this.surfaceGraphic.getViewAngle());
        }
    }
}

