/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.PDebugKeyHandler;
import edu.colorado.phet.common.piccolophet.help.DefaultWiggleMe;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.RampPlotSet;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampObject;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.timeseries.TimeSeriesModel;
import edu.colorado.phet.theramp.view.AppliedForceSimpleControl;
import edu.colorado.phet.theramp.view.BlockGraphic;
import edu.colorado.phet.theramp.view.GoPauseClearPanel;
import edu.colorado.phet.theramp.view.OverheatButton;
import edu.colorado.phet.theramp.view.RampLookAndFeel;
import edu.colorado.phet.theramp.view.RampWorld;
import edu.colorado.phet.theramp.view.SpeedReadoutGraphic;
import edu.colorado.phet.theramp.view.SurfaceGraphic;
import edu.colorado.phet.theramp.view.TimeGraphic;
import edu.colorado.phet.theramp.view.UserAddingEnergyHandler;
import edu.colorado.phet.theramp.view.bars.BarGraphSuite;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.Timer;

public class RampPanel
extends PhetPCanvas {
    private RampModule module;
    private RampLookAndFeel rampLookAndFeel;
    private BarGraphSuite barGraphSuite;
    private TimeGraphic timeGraphic;
    private SpeedReadoutGraphic velocityGraphic;
    private RampWorld rampWorld;
    private RampPlotSet rampPlotSet;
    private static final Dimension ORIG_RENDER_SIZE = new Dimension(1042, 818);
    public final PNode appliedForceControl;
    public final PNode goPauseClear;
    private boolean recursing = false;
    public static boolean redRampEnabled = false;
    private DefaultWiggleMe wiggleMe;
    private Timer wiggleMeTimer;

    public static Dimension getDefaultRenderSize() {
        return new Dimension(ORIG_RENDER_SIZE);
    }

    public Dimension getDefaultRenderingSize() {
        return ORIG_RENDER_SIZE;
    }

    public RampPanel(RampModule rampModule) {
        super(RampPanel.getDefaultRenderSize());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                RampPanel.this.requestFocus();
                System.out.println("getSize( ) = " + RampPanel.this.getSize());
            }
        });
        this.addKeyListener(new PDebugKeyHandler());
        this.module = rampModule;
        this.rampLookAndFeel = new RampLookAndFeel();
        this.rampWorld = new RampWorld(rampModule, this);
        double d = 0.96;
        this.rampWorld.scale(d);
        this.rampWorld.translate(0.0, -100.0);
        this.addWorldChild(this.rampWorld);
        this.barGraphSuite = new BarGraphSuite(this, rampModule.getRampPhysicalModel());
        this.barGraphSuite.setOffset((double)this.getDefaultRenderingSize().width - this.barGraphSuite.getFullBounds().getWidth() - 20.0, this.barGraphSuite.getY() + 20.0);
        this.addScreenChild(this.barGraphSuite);
        this.getRampModule().getRampPhysicalModel().addListener(new RampPhysicalModel.Adapter(){

            public void stepFinished() {
                if (RampPanel.this.getRampModule().getRampPhysicalModel().getThermalEnergy() >= RampPanel.this.getOverheatEnergy()) {
                    RampPanel.this.rampWorld.setHeatColor(true);
                } else {
                    RampPanel.this.rampWorld.setHeatColor(false);
                }
            }
        });
        this.getRampModule().getTimeSeriesModel().addPlaybackTimeChangeListener(new TimeSeriesModel.PlaybackTimeListener(){

            public void timeChanged() {
                if (RampPanel.this.getRampModule().getRampPhysicalModel().getThermalEnergy() >= RampPanel.this.getOverheatEnergy()) {
                    RampPanel.this.rampWorld.setHeatColor(true);
                } else {
                    RampPanel.this.rampWorld.setHeatColor(false);
                }
            }
        });
        this.addScreenChild(new OverheatButton(this, rampModule.getRampPhysicalModel(), rampModule));
        this.timeGraphic = new TimeGraphic(rampModule.getTimeSeriesModel());
        this.timeGraphic.setOffset(60.0, 60.0);
        this.addWorldChild(this.timeGraphic);
        rampModule.getModel().addModelElement(this.timeGraphic);
        this.velocityGraphic = new SpeedReadoutGraphic(rampModule.getRampPhysicalModel());
        this.velocityGraphic.setOffset(this.timeGraphic.getFullBounds().getX(), this.timeGraphic.getFullBounds().getMaxY() + 5.0);
        this.addWorldChild(this.velocityGraphic);
        rampModule.getModel().addModelElement(this.velocityGraphic);
        this.requestFocus();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                RampPanel.this.requestFocus();
            }
        });
        this.addMouseListener(new UserAddingEnergyHandler(rampModule));
        this.rampPlotSet = new RampPlotSet(rampModule, this);
        this.addScreenChild(this.rampPlotSet);
        this.appliedForceControl = new AppliedForceSimpleControl(rampModule, this);
        this.addScreenChild(this.appliedForceControl);
        this.goPauseClear = new PSwing(new GoPauseClearPanel(rampModule.getTimeSeriesModel()));
        this.addScreenChild(this.goPauseClear);
        this.layoutAll();
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                RampPanel.this.layoutAll();
            }

            public void componentShown(ComponentEvent componentEvent) {
                RampPanel.this.layoutAll();
            }
        });
    }

    private void layoutAll() {
        this.layoutChildren();
        this.rampPlotSet.layoutChildren();
        this.layoutChildren();
    }

    public double getOverheatEnergy() {
        return this.barGraphSuite.getMaxDisplayableEnergy() * 0.82;
    }

    private void layoutChildren() {
        if (!this.recursing) {
            this.recursing = true;
            double d = this.rampPlotSet.getFullBounds().getY() - this.goPauseClear.getFullBounds().getHeight() - 2.0;
            double d2 = this.getChartTopY() - this.goPauseClear.getFullBounds().getHeight() - 2.0;
            double d3 = this.getChartTopY() - this.appliedForceControl.getFullBounds().getHeight() - 2.0;
            if (d2 <= 0.0) {
                d2 = d;
            }
            int n = 2;
            this.appliedForceControl.setOffset(n, d3);
            this.goPauseClear.setOffset(n, d3 + this.appliedForceControl.getFullBounds().getHeight());
            double d4 = Math.max(this.appliedForceControl.getFullBounds().getMaxX(), this.goPauseClear.getFullBounds().getMaxX());
            this.rampPlotSet.setPlotOffsetX((int)(d4 + 5.0));
            this.barGraphSuite.setOffset((double)this.getWidth() - this.barGraphSuite.getFullBounds().getWidth() - 5.0, d2 - 5.0);
            double d5 = ((double)this.getHeight() - this.barGraphSuite.getOffset().getY()) * 0.8;
            try {
                this.barGraphSuite.setBarChartHeight(d5);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
            this.rampPlotSet.layoutChildren();
            this.recursing = false;
        }
    }

    private double getChartTopY() {
        return this.rampPlotSet.getTopY();
    }

    protected void addWiggleMe() {
        PImage pImage = this.getBlockGraphic().getObjectGraphic();
        PBounds pBounds = pImage.getGlobalFullBounds();
        this.getCamera().globalToLocal(pBounds);
        this.wiggleMe = new DefaultWiggleMe(this, TheRampStrings.getString("invitation"));
        this.wiggleMe.setLocation(0.0, 0.0);
        this.wiggleMe.setArrowTailPosition(DefaultWiggleMe.RIGHT_CENTER);
        this.addScreenChild(this.wiggleMe);
        System.out.println("wiggleMe.getRoot() = " + this.wiggleMe.getRoot());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                RampPanel.this.removeScreenChild(RampPanel.this.wiggleMe);
                RampPanel.this.removeMouseListener(this);
                System.out.println("wiggleMe.getRoot() = " + RampPanel.this.wiggleMe.getRoot());
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    private void updateArrowSetGraphics() {
        this.rampWorld.updateArrowSetGraphics();
    }

    public RampModule getRampModule() {
        return this.module;
    }

    public RampLookAndFeel getLookAndFeel() {
        return this.rampLookAndFeel;
    }

    public BlockGraphic getBlockGraphic() {
        return this.rampWorld.getBlockGraphic();
    }

    public void setCartesianArrowsVisible(boolean bl) {
        this.rampWorld.setCartesianArrowsVisible(bl);
    }

    public void setParallelArrowsVisible(boolean bl) {
        this.rampWorld.setParallelArrowsVisible(bl);
    }

    public void setPerpendicularArrowsVisible(boolean bl) {
        this.rampWorld.setPerpendicularArrowsVisible(bl);
    }

    public void setXArrowsVisible(boolean bl) {
        this.rampWorld.setXArrowsVisible(bl);
    }

    public void setYArrowsVisible(boolean bl) {
        this.rampWorld.setYArrowsVisible(bl);
    }

    public boolean isCartesianVisible() {
        return this.rampWorld.isCartesianVisible();
    }

    public boolean isParallelVisible() {
        return this.rampWorld.isParallelVisible();
    }

    public boolean isPerpendicularVisible() {
        return this.rampWorld.isPerpendicularVisible();
    }

    public boolean isXVisible() {
        return this.rampWorld.isXVisible();
    }

    public boolean isYVisible() {
        return this.rampWorld.isYVisible();
    }

    public void setForceVisible(String string, boolean bl) {
        this.rampWorld.setForceVisible(string, bl);
    }

    public SurfaceGraphic getRampGraphic() {
        return this.rampWorld.getRampGraphic();
    }

    public void setObject(RampObject rampObject) {
        this.getBlockGraphic().setObject(rampObject);
    }

    public RampWorld getRampWorld() {
        return this.rampWorld;
    }

    public void setMeasureTapeVisible(boolean bl) {
        this.rampWorld.setMeasureTapeVisible(bl);
    }

    public void updateGraphics() {
        this.updateArrowSetGraphics();
    }

    public void setEnergyBarsVisible(boolean bl) {
        this.barGraphSuite.setEnergyBarsMaximized(bl);
    }

    public void setWorkBarsVisible(boolean bl) {
        this.barGraphSuite.setWorkBarsMaximized(bl);
    }

    public int numMaximizedBarGraphs() {
        return (this.barGraphSuite.getEnergyBarsMaximized() ? 1 : 0) + (this.barGraphSuite.getWorkBarsMaximized() ? 1 : 0);
    }

    public void setAllBarsMinimized(boolean bl) {
        this.setEnergyBarsVisible(!bl);
        this.setWorkBarsVisible(!bl);
    }

    public void reset() {
        this.rampPlotSet.reset();
        this.resetBarStates();
        this.resetPlotStates();
    }

    protected void resetPlotStates() {
        this.rampPlotSet.setPlotsMaximized(false, true, true);
    }

    public void resetBarStates() {
        this.setAllBarsMinimized(false);
    }

    public void repaintBackground() {
        this.rampPlotSet.repaintBackground();
    }

    public RampPlotSet getRampPlotSet() {
        return this.rampPlotSet;
    }

    public void maximizeForcePlot() {
        this.rampPlotSet.maximizeForcePlot();
    }

    public double getChartLayoutMaxX() {
        int n = 3;
        if (this.barGraphSuite.areBothMinimized()) {
            // empty if block
        }
        return this.barGraphSuite.getFullBounds().getX() - (double)n;
    }

    public void relayoutPiccolo() {
        this.layoutChildren();
    }

    public Rectangle2D getClearButtonCanvasRect() {
        PBounds pBounds = this.goPauseClear.getGlobalFullBounds();
        this.getCamera().globalToLocal(pBounds);
        return pBounds;
    }

    public void graphLayoutChanged() {
        this.layoutAll();
        if (Toolkit.getDefaultToolkit().getScreenSize().width <= 1024) {
            // empty if block
        }
    }

    public BarGraphSuite getBarGraphSuite() {
        return this.barGraphSuite;
    }

    public void updateReadouts() {
        this.rampPlotSet.updateReadouts();
    }

    public void applicationStarted() {
        this.wiggleMeTimer = new Timer(10000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RampPanel.this.wiggleMe.animateTo(RampPanel.this.getBlockGraphic().getObjectGraphic());
                RampPanel.this.wiggleMeTimer.stop();
            }
        });
        this.wiggleMeTimer.setInitialDelay(1000);
        this.wiggleMeTimer.start();
    }
}

