/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.theramp.model.Surface;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.SurfaceGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class RampGraphic
extends SurfaceGraphic {
    private PNode arrowGraphic = this.createArrowGraphic();

    public RampGraphic(RampPanel rampPanel, Surface surface) {
        super(rampPanel, surface);
        this.addChild(this.arrowGraphic);
        this.getSurfaceGraphic().addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                RampGraphic.this.arrowGraphic.setVisible(false);
            }
        });
        this.getSurface().addObserver(new SimpleObserver(){

            public void update() {
                RampGraphic.this.arrowGraphic.setVisible(false);
            }
        });
        this.updateArrowGraphic();
    }

    private void updateArrowGraphic() {
        Point point = this.getViewLocation(this.getSurface().getLocation(this.getSurface().getLength() * 0.8));
        this.arrowGraphic.setOffset((double)point.x - this.arrowGraphic.getWidth() / 2.0, (double)point.y - this.arrowGraphic.getHeight() / 2.0);
    }

    private PNode createArrowGraphic() {
        String string = "the-ramp/images/arrow-2.gif";
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageLoader.loadBufferedImage(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        bufferedImage = BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage, 100);
        PImage pImage = new PImage(bufferedImage);
        pImage.setPickable(false);
        pImage.setChildrenPickable(false);
        return pImage;
    }
}

