/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.SurfaceGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.io.IOException;

public abstract class BarrierGraphic
extends PNode {
    private RampPanel rampPanel;
    private SurfaceGraphic surfaceGraphic;
    protected PImage imageGraphic;

    public BarrierGraphic(Component component, RampPanel rampPanel, SurfaceGraphic surfaceGraphic) {
        this.rampPanel = rampPanel;
        this.surfaceGraphic = surfaceGraphic;
        try {
            this.imageGraphic = new PImage(ImageLoader.loadBufferedImage("the-ramp/images/barrier2.jpg"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addChild(this.imageGraphic);
        surfaceGraphic.getSurface().addObserver(new SimpleObserver(){

            public void update() {
                BarrierGraphic.this.update();
            }
        });
        this.update();
    }

    private AffineTransform createTransform(double d, double d2, double d3) {
        return this.surfaceGraphic.createTransform(d, new Dimension((int)((double)this.imageGraphic.getImage().getWidth(null) * d2), (int)((double)this.imageGraphic.getImage().getHeight(null) * d3)));
    }

    private void update() {
        AffineTransform affineTransform = this.createTransform(this.getBarrierPosition(), 1.0, 1.0);
        affineTransform.concatenate(AffineTransform.getTranslateInstance(0.0, this.getYOffset()));
        affineTransform.concatenate(AffineTransform.getTranslateInstance(this.getOffsetX(), 0.0));
        this.imageGraphic.setTransform(affineTransform);
    }

    protected abstract int getOffsetX();

    protected abstract double getBarrierPosition();

    public RampPanel getRampPanel() {
        return this.rampPanel;
    }

    public SurfaceGraphic getRampGraphic() {
        return this.surfaceGraphic;
    }
}

