/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.timeseries;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.timeseries.HasAudio;
import edu.colorado.phet.theramp.timeseries.TimeSeriesModel;
import edu.colorado.phet.theramp.timeseries.TimeSeriesModelListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class TimeSeriesPlaybackPanel
extends JPanel {
    private JButton record;
    private JButton play;
    private JButton pause;
    private JButton rewind;
    private JButton slowMotion;
    private JButton clear;
    private TimeSeriesModel timeSeriesModel;

    public TimeSeriesPlaybackPanel(final TimeSeriesModel timeSeriesModel) {
        Object object;
        this.timeSeriesModel = timeSeriesModel;
        this.record = new JButton(TheRampStrings.getString("time.record"));
        this.record.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timeSeriesModel.setRecordMode();
                timeSeriesModel.setPaused(false);
            }
        });
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(new ImageLoader().loadImage("the-ramp/images/icons/java/media/Pause24.gif"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.pause = new JButton(TheRampStrings.getString("time.pause"), imageIcon);
        this.pause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timeSeriesModel.setPaused(true);
            }
        });
        ImageIcon imageIcon2 = null;
        try {
            imageIcon2 = new ImageIcon(new ImageLoader().loadImage("the-ramp/images/icons/java/media/Play24.gif"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.play = new JButton(TheRampStrings.getString("time.playback"), imageIcon2);
        this.play.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timeSeriesModel.startPlaybackMode(1.0);
            }
        });
        ImageIcon imageIcon3 = null;
        try {
            imageIcon3 = new ImageIcon(new ImageLoader().loadImage("the-ramp/images/icons/java/media/Rewind24.gif"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.rewind = new JButton(TheRampStrings.getString("time.rewind"), imageIcon3);
        this.rewind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timeSeriesModel.rewind();
                timeSeriesModel.setPaused(true);
            }
        });
        ImageIcon imageIcon4 = null;
        try {
            imageIcon4 = new ImageIcon(new ImageLoader().loadImage("the-ramp/images/icons/java/media/StepForward24.gif"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.slowMotion = new JButton(TheRampStrings.getString("time.slow-motion"), imageIcon4);
        this.slowMotion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timeSeriesModel.startPlaybackMode(0.4);
            }
        });
        this.clear = new JButton(TheRampStrings.getString("controls.clear"));
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timeSeriesModel.confirmAndApplyReset();
            }
        });
        this.add(this.play);
        this.add(this.slowMotion);
        this.add(this.pause);
        this.add(this.rewind);
        this.add(this.clear);
        if (timeSeriesModel instanceof HasAudio) {
            object = new JCheckBox(TheRampStrings.getString("controls.sound"), true);
            ((AbstractButton)object).addActionListener(new ActionListener((JCheckBox)object){
                final /* synthetic */ JCheckBox val$audio;
                {
                    this.val$audio = jCheckBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ((HasAudio)((Object)timeSeriesModel)).setAudioEnabled(this.val$audio.isSelected());
                }
            });
            this.add(new JSeparator());
            this.add((Component)object);
        }
        object = new TimeSeriesModelListener(){

            public void recordingStarted() {
                TimeSeriesPlaybackPanel.this.setButtons(false, false, false, false);
            }

            public void recordingPaused() {
                TimeSeriesPlaybackPanel.this.setButtons(true, true, false, false);
            }

            public void playbackFinished() {
                TimeSeriesPlaybackPanel.this.setButtons(false, false, false, true);
            }

            public void playbackStarted() {
                TimeSeriesPlaybackPanel.this.setButtons(false, false, true, true);
            }

            public void playbackPaused() {
                TimeSeriesPlaybackPanel.this.setButtons(true, true, false, true);
            }

            public void reset() {
                TimeSeriesPlaybackPanel.this.setButtons(false, false, false, false);
            }

            public void rewind() {
                TimeSeriesPlaybackPanel.this.setButtons(true, true, false, false);
            }
        };
        timeSeriesModel.addListener((TimeSeriesModelListener)object);
    }

    private void setButtons(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.play.setEnabled(bl);
        this.slowMotion.setEnabled(bl2);
        this.pause.setEnabled(true);
        this.rewind.setEnabled(bl4);
    }
}

