/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.timeseries;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.theramp.timeseries.Mode;
import edu.colorado.phet.theramp.timeseries.PhetTimer;
import edu.colorado.phet.theramp.timeseries.TimeSeriesModel;

public class PlaybackMode
extends Mode {
    private double playbackSpeed;
    private PhetTimer timer;
    private TimeSeriesModel timeSeriesModel;

    public PlaybackMode(TimeSeriesModel timeSeriesModel) {
        super(timeSeriesModel, "Playback", false);
        this.timeSeriesModel = timeSeriesModel;
        this.timer = new PhetTimer("Playback Timer");
    }

    public void setPlaybackSpeed(double d) {
        this.playbackSpeed = d;
    }

    public void initialize() {
        this.timeSeriesModel.repaintBackground();
    }

    public void clockTicked(ClockEvent clockEvent) {
        double d = clockEvent.getSimulationTimeChange();
        if (!this.timeSeriesModel.isPaused()) {
            this.timeSeriesModel.getPlaybackTimer().stepInTime(d * this.playbackSpeed, this.timeSeriesModel.getRecordTimer().getTime());
            double d2 = this.timeSeriesModel.getPlaybackTimer().getTime();
            double d3 = this.timeSeriesModel.getRecordTimer().getTime();
            if (d2 < d3) {
                this.timeSeriesModel.setReplayTime(d2);
            } else {
                this.timeSeriesModel.setPaused(true);
                this.timeSeriesModel.firePlaybackFinished();
            }
        }
    }

    public void reset() {
        this.timer.reset();
    }

    public void rewind() {
        this.timeSeriesModel.setReplayTime(0.0);
        this.timer.setTime(0.0);
    }

    public PhetTimer getTimer() {
        return this.timer;
    }
}

