/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.timeseries;

import edu.colorado.phet.theramp.timeseries.ObjectTimePoint;
import java.util.ArrayList;

public class ObjectTimeSeries {
    private ArrayList pts = new ArrayList();
    private ArrayList observers = new ArrayList();

    public void addPoint(Object object, double d) {
        ObjectTimePoint objectTimePoint = new ObjectTimePoint(object, d);
        this.pts.add(objectTimePoint);
        this.notifyAdded();
    }

    private void notifyAdded() {
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.dataAdded(this);
        }
    }

    public void reset() {
        this.pts = new ArrayList();
        this.notifyCleared();
    }

    private void notifyCleared() {
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.cleared(this);
        }
    }

    public ObjectTimePoint pointAt(int n) {
        return (ObjectTimePoint)this.pts.get(n);
    }

    public int numPoints() {
        return this.pts.size();
    }

    public ObjectTimePoint getValueForTime(double d) {
        double d2;
        if (this.numPoints() == 0) {
            return new ObjectTimePoint(null, 0.0);
        }
        ObjectTimePoint[] objectTimePointArray = this.getNeighborsForTime(d, 0, this.numPoints() - 1, 0);
        ObjectTimePoint objectTimePoint = objectTimePointArray[0];
        ObjectTimePoint objectTimePoint2 = objectTimePointArray[1];
        double d3 = Math.abs(objectTimePoint.getTime() - d);
        if (d3 <= (d2 = Math.abs(objectTimePoint2.getTime() - d))) {
            return new ObjectTimePoint(objectTimePoint.getValue(), d);
        }
        return new ObjectTimePoint(objectTimePoint2.getValue(), d);
    }

    private ObjectTimePoint[] getNeighborsForTime(double d, int n, int n2, int n3) {
        return new ObjectTimePoint[]{this.getLowerSample(d, n, n2, 0), this.getUpperSample(d, n, n2, 0)};
    }

    private ObjectTimePoint getLowerSample(double d, int n, int n2, int n3) {
        if (n3 > 1000) {
            new RuntimeException("Lower Sample recursed 1000 times.").printStackTrace();
            return new ObjectTimePoint(null, 0.0);
        }
        if (n == n2 || n == n2 - 1) {
            return this.pointAt(n);
        }
        int n4 = (n2 + n) / 2;
        ObjectTimePoint objectTimePoint = this.pointAt(n4);
        if (objectTimePoint.getTime() > d) {
            return this.getLowerSample(d, n, n4, n3 + 1);
        }
        return this.getLowerSample(d, n4, n2, n3 + 1);
    }

    private ObjectTimePoint getUpperSample(double d, int n, int n2, int n3) {
        if (n3 > 1000) {
            new RuntimeException("Lower Sample recursed 1000 times.").printStackTrace();
            return new ObjectTimePoint(null, 0.0);
        }
        if (n == n2 || n == n2 - 1) {
            return this.pointAt(n2);
        }
        int n4 = (n2 + n) / 2;
        ObjectTimePoint objectTimePoint = this.pointAt(n4);
        if (objectTimePoint.getTime() > d) {
            return this.getUpperSample(d, n, n4, n3 + 1);
        }
        return this.getUpperSample(d, n4, n2, n3 + 1);
    }

    public static interface Observer {
        public void dataAdded(ObjectTimeSeries var1);

        public void cleared(ObjectTimeSeries var1);
    }
}

