/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.common;

import java.util.ArrayList;

public class LayoutSet {
    private ArrayList items = new ArrayList();

    public void addItem(LayoutItem layoutItem) {
        this.items.add(layoutItem);
    }

    public int getFixedSize() {
        int n = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            LayoutItem layoutItem = (LayoutItem)this.items.get(i);
            if (!(layoutItem instanceof FixedLayoutItem)) continue;
            FixedLayoutItem fixedLayoutItem = (FixedLayoutItem)layoutItem;
            n = (int)((double)n + fixedLayoutItem.getSize());
        }
        return n;
    }

    public void hideVariableItems() {
        for (int i = 0; i < this.items.size(); ++i) {
            LayoutItem layoutItem = (LayoutItem)this.items.get(i);
            if (!(layoutItem instanceof VariableLayoutItem)) continue;
            ((VariableLayoutItem)layoutItem).setVisible(false);
        }
    }

    public double numVariableItems() {
        int n = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            LayoutItem layoutItem = (LayoutItem)this.items.get(i);
            if (!(layoutItem instanceof VariableLayoutItem)) continue;
            ++n;
        }
        return n;
    }

    public void layoutForVariableItemSize(double d, double d2) {
        double d3 = d;
        for (int i = 0; i < this.items.size(); ++i) {
            LayoutItem layoutItem = (LayoutItem)this.items.get(i);
            layoutItem.setOffset(d3);
            if (layoutItem instanceof VariableLayoutItem) {
                ((VariableLayoutItem)layoutItem).setSize(d2);
                d3 += d2;
                continue;
            }
            if (!(layoutItem instanceof FixedLayoutItem)) continue;
            FixedLayoutItem fixedLayoutItem = (FixedLayoutItem)layoutItem;
            d3 += fixedLayoutItem.getSize();
        }
    }

    public void layout(double d, double d2) {
        double d3 = d2 - (double)this.getFixedSize();
        if (d3 <= 0.0) {
            this.hideVariableItems();
        } else {
            this.layoutForVariableItemSize(d, d3 / this.numVariableItems());
        }
    }

    public static abstract class FixedLayoutItem
    implements LayoutItem {
        private double size;

        public FixedLayoutItem(double d) {
            this.size = d;
        }

        public double getSize() {
            return this.size;
        }
    }

    public static interface LayoutItem {
        public void setOffset(double var1);
    }

    public static interface VariableLayoutItem
    extends LayoutItem {
        public void setSize(double var1);

        public void setVisible(boolean var1);
    }
}

