/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp;

import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.common.LayoutSet;
import edu.colorado.phet.theramp.common.Range2D;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.model.ValueAccessor;
import edu.colorado.phet.theramp.timeseries.TimeSeries;
import edu.colorado.phet.theramp.timeseries.TimeSeriesModel;
import edu.colorado.phet.theramp.view.RampLookAndFeel;
import edu.colorado.phet.theramp.view.RampPanel;
import edu.colorado.phet.theramp.view.plot.TimePlotSuitePNode;
import edu.colorado.phet.theramp.view.plot.TimeSeriesPNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class RampPlotSet
extends PNode {
    private RampModule module;
    private RampPanel rampPanel;
    private ArrayList dataUnits = new ArrayList();
    private TimePlotSuitePNode energyPlot;
    private TimePlotSuitePNode workPlot;
    private TimePlotSuitePNode parallelForcePlot;
    private int plotOffsetX = 120;
    double layoutY = -1.0;
    double layoutHeight = -1.0;
    int layoutWidth = -1;
    ArrayList listeners = new ArrayList();

    public RampPlotSet(RampModule rampModule, final RampPanel rampPanel) {
        this.module = rampModule;
        this.rampPanel = rampPanel;
        int n = 400;
        int n2 = 80;
        int n3 = 2;
        int n4 = 30000;
        this.energyPlot = this.createTimePlotSuitePNode(new Range2D(0.0, -n4, 30.0, n4), TheRampStrings.getString("energy.energy"), TheRampStrings.getString("units.joules"), n, n2, false);
        this.addTimeSeries(this.energyPlot, new ValueAccessor.TotalEnergy(this.getLookAndFeel()), "10000.00").setStroke(new BasicStroke(4.0f));
        this.addTimeSeries(this.energyPlot, new ValueAccessor.ThermalEnergy(this.getLookAndFeel()), "10000.00");
        this.addTimeSeries(this.energyPlot, new ValueAccessor.PotentialEnergy(this.getLookAndFeel()), "10000.00");
        this.addTimeSeries(this.energyPlot, new ValueAccessor.KineticEnergy(this.getLookAndFeel()), "10000.00");
        this.workPlot = this.createTimePlotSuitePNode(new Range2D(0.0, -n4, 30.0, n4), TheRampStrings.getString("energy.work"), TheRampStrings.getString("units.joules"), n + n2 + n3, n2, false);
        this.addTimeSeries(this.workPlot, new ValueAccessor.AppliedWork(this.getLookAndFeel()), "10000.00").setStroke(new BasicStroke(4.0f));
        this.addTimeSeries(this.workPlot, new ValueAccessor.FrictiveWork(this.getLookAndFeel()), "10000.00");
        this.addTimeSeries(this.workPlot, new ValueAccessor.GravityWork(this.getLookAndFeel()), "10000.00");
        this.addTimeSeries(this.workPlot, new ValueAccessor.TotalWork(this.getLookAndFeel()), "10000.00");
        this.parallelForcePlot = this.createTimePlotSuitePNode(new Range2D(0.0, -1000.0, 30.0, 1000.0), TheRampStrings.getString("forces.parallel"), TheRampStrings.getString("units.newtons"), n + n2 * 2 + n3, n2, true);
        this.addTimeSeries(this.parallelForcePlot, new ValueAccessor.ParallelAppliedAccessor(this.getLookAndFeel()), "10000.00").setStroke(new BasicStroke(4.0f));
        this.addTimeSeries(this.parallelForcePlot, new ValueAccessor.ParallelFrictionAccessor(this.getLookAndFeel()), "10000.00");
        this.addTimeSeries(this.parallelForcePlot, new ValueAccessor.ParallelGravityAccessor(this.getLookAndFeel()), "10000.00");
        this.addTimeSeries(this.parallelForcePlot, new ValueAccessor.ParallelWallForceAccessor(this.getLookAndFeel()), "10000.00");
        this.addChild(this.energyPlot);
        this.addChild(this.workPlot);
        this.addChild(this.parallelForcePlot);
        this.parallelForcePlot.setMinimized(true);
        TimePlotSuitePNode.Listener listener = new TimePlotSuitePNode.Listener(){

            public void minimizeStateChanged() {
                RampPlotSet.this.invalidateLayout();
                rampPanel.graphLayoutChanged();
            }
        };
        this.energyPlot.addListener(listener);
        this.workPlot.addListener(listener);
        this.invalidateLayout();
        rampPanel.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                RampPlotSet.this.invalidateLayout();
            }

            public void componentShown(ComponentEvent componentEvent) {
                RampPlotSet.this.invalidateLayout();
            }
        });
    }

    public void setPlotOffsetX(int n) {
        if (this.plotOffsetX != n) {
            this.plotOffsetX = n;
            this.invalidateLayout();
            this.repaint();
        }
    }

    public void minimizeAllPlots() {
        this.energyPlot.setMinimized(true);
        this.workPlot.setMinimized(true);
        this.parallelForcePlot.setMinimized(true);
    }

    public void maximizeForcePlot() {
        this.parallelForcePlot.setMinimized(false);
    }

    public double getTopY() {
        return this.parallelForcePlot.getTopY();
    }

    public void updateReadouts() {
        this.energyPlot.updateReadouts();
        this.workPlot.updateReadouts();
        this.parallelForcePlot.updateReadouts();
    }

    public void setPlotsMaximized(boolean bl, boolean bl2, boolean bl3) {
        this.parallelForcePlot.setMinimized(!bl);
        this.energyPlot.setMinimized(!bl2);
        this.workPlot.setMinimized(!bl3);
    }

    public void layoutChildren() {
        super.layoutChildren();
        LayoutSet layoutSet = new LayoutSet();
        int n = (int)this.getAvailableWidth();
        if (n > 0) {
            layoutSet.addItem(this.toPlotLayoutItem(n, this.parallelForcePlot));
            layoutSet.addItem(this.toPlotLayoutItem(n, this.energyPlot));
            layoutSet.addItem(this.toPlotLayoutItem(n, this.workPlot));
            layoutSet.layout(this.getLayoutStartY(), this.getAvailableHeight());
            this.layoutY = this.getLayoutStartY();
            this.layoutHeight = this.getAvailableHeight();
            this.layoutWidth = n;
        }
        this.notifyLayedOutChildren();
    }

    private void notifyLayedOutChildren() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.layoutChanged();
        }
    }

    private double getAvailableHeight() {
        return (double)this.rampPanel.getSize().height - this.getLayoutStartY();
    }

    private double getAvailableWidth() {
        return this.rampPanel.getChartLayoutMaxX() - (double)this.plotOffsetX;
    }

    private double getLayoutStartY() {
        Point2D point2D = this.rampPanel.getRampWorld().getEarthGraphic().getGlobalFullBounds().getOrigin();
        this.globalToLocal(point2D);
        this.localToParent(point2D);
        return point2D.getY() + 80.0;
    }

    private LayoutSet.LayoutItem toPlotLayoutItem(int n, TimePlotSuitePNode timePlotSuitePNode) {
        if (timePlotSuitePNode.isMinimized()) {
            return new FixedPlotItem(timePlotSuitePNode, this.plotOffsetX);
        }
        return new VariablePlotItem(timePlotSuitePNode, this.plotOffsetX, n);
    }

    public void repaintBackground() {
        this.parallelForcePlot.repaintAll();
        this.energyPlot.repaintAll();
        this.workPlot.repaintAll();
    }

    public int numDataUnits() {
        return this.dataUnits.size();
    }

    private TimeSeriesPNode addTimeSeries(TimePlotSuitePNode timePlotSuitePNode, ValueAccessor valueAccessor, String string) {
        TimeSeries timeSeries = new TimeSeries();
        TimeSeriesPNode timeSeriesPNode = new TimeSeriesPNode(timePlotSuitePNode, timeSeries, valueAccessor, valueAccessor.getColor(), string);
        timePlotSuitePNode.addTimeSeries(timeSeriesPNode);
        this.dataUnits.add(new DataUnit(valueAccessor, timeSeries, timePlotSuitePNode, timeSeriesPNode));
        return timeSeriesPNode;
    }

    private RampLookAndFeel getLookAndFeel() {
        return this.getRampPanel().getLookAndFeel();
    }

    private RampPanel getRampPanel() {
        return this.rampPanel;
    }

    private TimePlotSuitePNode createTimePlotSuitePNode(Range2D range2D, String string, String string2, int n, int n2, boolean bl) {
        TimeSeriesModel timeSeriesModel = this.module.getTimeSeriesModel();
        TimePlotSuitePNode timePlotSuitePNode = new TimePlotSuitePNode(this.module, this.getRampPanel(), range2D, string, string2, timeSeriesModel, n2, bl);
        timePlotSuitePNode.setOffset(0.0, n);
        return timePlotSuitePNode;
    }

    public void updatePlots(RampPhysicalModel rampPhysicalModel, double d) {
        for (int i = 0; i < this.dataUnits.size(); ++i) {
            DataUnit dataUnit = (DataUnit)this.dataUnits.get(i);
            dataUnit.updatePlot(rampPhysicalModel, d);
        }
    }

    public void reset() {
        for (int i = 0; i < this.dataUnits.size(); ++i) {
            this.dataUnitAt(i).reset();
        }
    }

    public DataUnit dataUnitAt(int n) {
        return (DataUnit)this.dataUnits.get(n);
    }

    public static class DataUnit {
        private ValueAccessor valueAccessor;
        private TimeSeries timeSeries;
        private TimePlotSuitePNode plotDeviceSeries;
        private TimeSeriesPNode seriesGraphic;

        public DataUnit(ValueAccessor valueAccessor, TimeSeries timeSeries, TimePlotSuitePNode timePlotSuitePNode, TimeSeriesPNode timeSeriesPNode) {
            this.valueAccessor = valueAccessor;
            this.timeSeries = timeSeries;
            this.plotDeviceSeries = timePlotSuitePNode;
            this.seriesGraphic = timeSeriesPNode;
        }

        public void reset() {
            this.timeSeries.reset();
            this.plotDeviceSeries.reset();
            this.seriesGraphic.reset();
        }

        public void updatePlot(RampPhysicalModel rampPhysicalModel, double d) {
            double d2 = this.valueAccessor.getValue(rampPhysicalModel);
            this.timeSeries.addPoint(d2, d);
        }

        public void setVisible(boolean bl) {
            this.seriesGraphic.setVisible(bl);
            this.plotDeviceSeries.repaintAll();
        }

        public Color getColor() {
            return this.valueAccessor.getColor();
        }

        public String getFullName() {
            return this.valueAccessor.getFullName();
        }
    }

    static class FixedPlotItem
    extends LayoutSet.FixedLayoutItem {
        private TimePlotSuitePNode plot;
        private int x;

        public FixedPlotItem(TimePlotSuitePNode timePlotSuitePNode, int n) {
            super(timePlotSuitePNode.getButtonHeight());
            this.plot = timePlotSuitePNode;
            this.x = n;
        }

        public void setOffset(double d) {
            this.plot.setOffset(this.x, d);
        }
    }

    public static interface Listener {
        public void layoutChanged();
    }

    static class VariablePlotItem
    implements LayoutSet.VariableLayoutItem {
        private TimePlotSuitePNode plot;
        private int x;
        private int width;

        public VariablePlotItem(TimePlotSuitePNode timePlotSuitePNode, int n, int n2) {
            this.plot = timePlotSuitePNode;
            this.x = n;
            this.width = n2;
        }

        public void setOffset(double d) {
            this.plot.setOffset(this.x, d);
        }

        public void setSize(double d) {
            this.plot.setChartSize(this.width, (int)d);
        }

        public void setVisible(boolean bl) {
            if (!bl) {
                // empty if block
            }
        }
    }
}

