/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.theramp.AdvancedRampControlPanel;
import edu.colorado.phet.theramp.TheRampStrings;
import edu.colorado.phet.theramp.model.RampObject;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JList;

public class ObjectComboBox
extends JComboBox {
    private AdvancedRampControlPanel controlPanel;

    public ObjectComboBox(final RampObject[] rampObjectArray, final AdvancedRampControlPanel advancedRampControlPanel) {
        super(ObjectComboBox.toLabelArray(rampObjectArray, advancedRampControlPanel));
        this.setRenderer(new ComboBoxRenderer());
        this.controlPanel = advancedRampControlPanel;
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = ObjectComboBox.this.getSelectedIndex();
                advancedRampControlPanel.setup(rampObjectArray[n]);
            }
        });
    }

    private static ImageIcon[] toLabelArray(RampObject[] rampObjectArray, Component component) {
        ImageIcon[] imageIconArray = new ImageIcon[rampObjectArray.length];
        for (int i = 0; i < imageIconArray.length; ++i) {
            try {
                BufferedImage bufferedImage = ImageLoader.loadBufferedImage(rampObjectArray[i].getLocation());
                bufferedImage = BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage, 35);
                imageIconArray[i] = new ImageIcon(bufferedImage);
                imageIconArray[i].setDescription(MessageFormat.format(TheRampStrings.getString("readout.mass"), rampObjectArray[i].getName(), new Double(rampObjectArray[i].getMass())));
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return imageIconArray;
    }

    public static class ComboBoxRenderer
    extends DefaultListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            ImageIcon imageIcon = (ImageIcon)object;
            this.setText(imageIcon.getDescription());
            this.setIcon(imageIcon);
            return defaultListCellRenderer;
        }
    }
}

