/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp;

import edu.colorado.phet.common.phetcommon.audio.PhetAudioClip;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.model.Collision;

public class CollisionHandler
extends Block.Adapter {
    private RampModule rampModule;
    private PhetAudioClip smash0;
    private PhetAudioClip smash1;
    private PhetAudioClip smash2;

    public CollisionHandler(RampModule rampModule) {
        this.rampModule = rampModule;
        this.smash0 = new PhetAudioClip("the-ramp/audio/smash0.wav");
        this.smash1 = new PhetAudioClip("the-ramp/audio/smash1.wav");
        this.smash2 = new PhetAudioClip("the-ramp/audio/smash2.wav");
    }

    public void collisionOccurred(Collision collision) {
        this.handleAudio(collision);
        double d = collision.getMomentumChange();
        this.rampModule.getRampPhysicalModel().setWallForce(d / collision.getDt());
    }

    private void handleAudio(Collision collision) {
        double d = collision.getAbsoluteMomentumChange();
        if (!(d < 50.0)) {
            if (d < 2000.0) {
                this.smash0.play();
            } else if (d < 4000.0) {
                this.smash1.play();
            } else {
                this.smash2.play();
            }
        }
    }
}

