/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import java.awt.Component;
import javax.swing.JComponent;

public class PiccoloModule
extends Module {
    private Component helpPane;
    private Component restoreGlassPane;

    public PiccoloModule(String string, IClock iClock) {
        this(string, iClock, false);
    }

    public PiccoloModule(String string, IClock iClock, boolean bl) {
        super(string, iClock, bl);
        if (this.hasHelp()) {
            this.helpPane = new HelpPane(PhetApplication.getInstance().getPhetFrame());
        }
    }

    public PhetPCanvas getPhetPCanvas() {
        PhetPCanvas phetPCanvas = null;
        JComponent jComponent = this.getSimulationPanel();
        if (jComponent instanceof PhetPCanvas) {
            phetPCanvas = (PhetPCanvas)jComponent;
        }
        return phetPCanvas;
    }

    public void setPhetPCanvas(PhetPCanvas phetPCanvas) {
        super.setSimulationPanel(phetPCanvas);
    }

    protected void handleUserInput() {
    }

    public void setHelpPane(Component component) {
        this.helpPane = component;
        if (this.isActive()) {
            this.setGlassPane(component);
            component.setVisible(this.isHelpEnabled());
        }
    }

    public HelpPane getDefaultHelpPane() {
        if (this.helpPane != null && this.helpPane instanceof HelpPane) {
            return (HelpPane)this.helpPane;
        }
        return null;
    }

    public void setHelpEnabled(boolean bl) {
        super.setHelpEnabled(bl);
        if (this.helpPane != null) {
            this.helpPane.setVisible(bl);
        }
    }

    public void activate() {
        super.activate();
        if (this.helpPane != null) {
            this.setGlassPane(this.helpPane);
            this.helpPane.setVisible(this.isHelpEnabled());
        }
    }

    public void deactivate() {
        if (this.helpPane != null) {
            this.setGlassPane(this.restoreGlassPane);
            this.helpPane.setVisible(false);
        }
        super.deactivate();
    }

    private Component getGlassPane() {
        return PhetApplication.getInstance().getPhetFrame().getGlassPane();
    }

    private void setGlassPane(Component component) {
        if (component != null) {
            this.restoreGlassPane = this.getGlassPane();
            PhetApplication.getInstance().getPhetFrame().setGlassPane(component);
        }
    }

    protected JComponent createClockControlPanel(IClock iClock) {
        return new PiccoloClockControlPanel(iClock);
    }
}

