/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.graphics.transforms;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LinearTransform2D {
    private Rectangle2D sourceBounds;
    private Rectangle2D destBounds;
    private boolean forwardTransformDirty = true;
    private AffineTransform forwardTransform;
    private boolean backTransformDirty = true;
    private AffineTransform backTransform;
    private boolean invertY;

    public LinearTransform2D(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX(), point2D.getY(), 0.0, 0.0);
        double_.add(point2D2);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(point2D3.getX(), point2D3.getY(), 0.0, 0.0);
        double_2.add(point2D4);
        this.setSourceBounds(double_);
        this.setDestinationBounds(double_2);
    }

    private void fixForwardTransform() {
        if (this.forwardTransformDirty) {
            this.forwardTransform = this.createForwardTransform();
            this.forwardTransformDirty = false;
        }
    }

    protected AffineTransform createForwardTransform() {
        if (this.invertY) {
            return LinearTransform2D.createTXInvertY(this.destBounds, this.sourceBounds);
        }
        return LinearTransform2D.createTX(this.destBounds, this.sourceBounds);
    }

    public String toString() {
        return "sourceBounds=" + this.sourceBounds + ", destBounds=" + this.destBounds;
    }

    public static AffineTransform createTX(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D.getWidth() / rectangle2D2.getWidth();
        double d2 = rectangle2D.getX() - d * rectangle2D2.getX();
        double d3 = rectangle2D.getHeight() / rectangle2D2.getHeight();
        double d4 = rectangle2D.getY() - d3 * rectangle2D2.getY();
        return new AffineTransform(d, 0.0, 0.0, d3, d2, d4);
    }

    public static AffineTransform createTXInvertY(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D.getWidth() / rectangle2D2.getWidth();
        double d2 = -rectangle2D.getHeight() / rectangle2D2.getHeight();
        double d3 = rectangle2D.getX() - d * rectangle2D2.getX();
        double d4 = rectangle2D.getY() + rectangle2D.getHeight() / rectangle2D2.getHeight() * (rectangle2D2.getY() + rectangle2D2.getHeight());
        return new AffineTransform(d, 0.0, 0.0, d2, d3, d4);
    }

    private void fixBackTransform() {
        if (this.backTransformDirty) {
            this.backTransform = this.createBackTransform();
            this.backTransformDirty = false;
        }
    }

    private AffineTransform createBackTransform() {
        this.fixForwardTransform();
        try {
            return this.forwardTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new RuntimeException(noninvertibleTransformException);
        }
    }

    public void setSourceBounds(Rectangle2D rectangle2D) {
        if (rectangle2D.getWidth() <= 0.0) {
            throw new RuntimeException("Model Width <= 0");
        }
        if (rectangle2D.getHeight() <= 0.0) {
            throw new RuntimeException("Model height<= 0");
        }
        this.sourceBounds = rectangle2D;
        this.forwardTransformDirty = true;
        this.backTransformDirty = true;
    }

    public void setDestinationBounds(Rectangle2D rectangle2D) {
        if (rectangle2D.getWidth() <= 0.0) {
            throw new RuntimeException("View Bounds width must be positive.");
        }
        if (rectangle2D.getHeight() <= 0.0) {
            throw new RuntimeException("View Bounds height must be positive.");
        }
        this.forwardTransformDirty = true;
        this.backTransformDirty = true;
        this.destBounds = rectangle2D;
    }

    public AffineTransform getInverseTransform() {
        this.fixBackTransform();
        return this.backTransform;
    }
}

