/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.shape.ShapeRenderer;
import org.jmol.viewer.JmolConstants;

public class SticksRenderer
extends ShapeRenderer {
    private boolean showMultipleBonds;
    private float multipleBondSpacing;
    private float multipleBondRadiusFactor;
    private byte modeMultipleBond;
    private byte endcaps;
    private boolean ssbondsBackbone;
    private boolean hbondsBackbone;
    private boolean bondsBackbone;
    private boolean hbondsSolid;
    private Atom atomA;
    private Atom atomB;
    private Bond bond;
    private int xA;
    private int yA;
    private int zA;
    private int xB;
    private int yB;
    private int zB;
    private int dx;
    private int dy;
    private int mag2d;
    private short colixA;
    private short colixB;
    private int width;
    private boolean lineBond;
    private int bondOrder;
    private boolean renderWireframe;
    private boolean isAntialiased;
    private boolean slabbing;
    private boolean slabByAtom;
    private Vector3f x;
    private Vector3f y;
    private Vector3f z;
    private Point3f p1;
    private Point3f p2;
    private Point3i s1;
    private Point3i s2;
    private int xAxis1;
    private int yAxis1;
    private int xAxis2;
    private int yAxis2;
    private int dxStep;
    private int dyStep;

    protected void render() {
        this.slabbing = this.viewer.getSlabEnabled();
        this.slabByAtom = this.viewer.getSlabByAtom();
        this.endcaps = (byte)3;
        this.multipleBondSpacing = this.viewer.getMultipleBondSpacing();
        this.multipleBondRadiusFactor = this.viewer.getMultipleBondRadiusFactor();
        if (this.multipleBondSpacing > 0.0f) {
            this.z = new Vector3f();
            this.x = new Vector3f();
            this.y = new Vector3f();
            this.p1 = new Point3f();
            this.p2 = new Point3f();
            this.s1 = new Point3i();
            this.s2 = new Point3i();
        }
        this.showMultipleBonds = this.multipleBondSpacing != 0.0f && this.viewer.getShowMultipleBonds();
        this.modeMultipleBond = this.viewer.getModeMultipleBond();
        this.renderWireframe = this.viewer.getInMotion() && this.viewer.getWireframeRotation();
        this.ssbondsBackbone = this.viewer.getSsbondsBackbone();
        this.hbondsBackbone = this.viewer.getHbondsBackbone();
        this.bondsBackbone = this.hbondsBackbone | this.ssbondsBackbone;
        this.hbondsSolid = this.viewer.getHbondsSolid();
        this.isAntialiased = this.g3d.isAntialiased();
        Bond[] bondArray = this.modelSet.getBonds();
        int n = this.modelSet.getBondCount();
        while (--n >= 0) {
            this.bond = bondArray[n];
            if ((this.bond.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0) continue;
            this.renderBond();
        }
    }

    private void renderBond() {
        this.atomA = this.bond.getAtom1();
        this.atomB = this.bond.getAtom2();
        int n = this.bond.getOrder() & 0xFFFDFFFF;
        if (this.bondsBackbone) {
            if (this.ssbondsBackbone && (n & 0x100) != 0) {
                this.atomA = this.atomA.getGroup().getLeadAtom(this.atomA);
                this.atomB = this.atomB.getGroup().getLeadAtom(this.atomB);
            } else if (this.hbondsBackbone && Bond.isHydrogen(n)) {
                this.atomA = this.atomA.getGroup().getLeadAtom(this.atomA);
                this.atomB = this.atomB.getGroup().getLeadAtom(this.atomB);
            }
        }
        if (!this.atomA.isInFrame() || !this.atomB.isInFrame() || !this.g3d.isInDisplayRange(this.atomA.screenX, this.atomA.screenY) || !this.g3d.isInDisplayRange(this.atomB.screenX, this.atomB.screenY) || this.modelSet.isAtomHidden(this.atomA.getIndex()) || this.modelSet.isAtomHidden(this.atomB.getIndex())) {
            return;
        }
        if (this.slabbing) {
            if (this.g3d.isClippedZ(this.atomA.screenZ) && this.g3d.isClippedZ(this.atomB.screenZ)) {
                return;
            }
            if (this.slabByAtom && (this.g3d.isClippedZ(this.atomA.screenZ) || this.g3d.isClippedZ(this.atomB.screenZ))) {
                return;
            }
        }
        this.colixA = this.atomA.getColix();
        this.colixB = this.atomB.getColix();
        this.colix = this.bond.getColix();
        if ((this.colix & 0xFFFF87FF) == 2) {
            this.colix = (short)(this.colix & 0x7800);
            this.colixA = Graphics3D.getColixInherited((short)(this.colix | this.viewer.getColixAtomPalette(this.atomA, (byte)1)), this.colixA);
            this.colixB = Graphics3D.getColixInherited((short)(this.colix | this.viewer.getColixAtomPalette(this.atomB, (byte)1)), this.colixB);
        } else {
            this.colixA = Graphics3D.getColixInherited(this.colix, this.colixA);
            this.colixB = Graphics3D.getColixInherited(this.colix, this.colixB);
        }
        this.xA = this.atomA.screenX;
        this.yA = this.atomA.screenY;
        this.zA = this.atomA.screenZ;
        this.xB = this.atomB.screenX;
        this.yB = this.atomB.screenY;
        this.zB = this.atomB.screenZ;
        if (this.zA == 1 || this.zB == 1) {
            return;
        }
        this.bondOrder = n & 0xFFFDFFFF;
        if ((this.bondOrder & 0xE0) == 0) {
            if ((this.bondOrder & 0x100) != 0) {
                this.bondOrder &= 0xFFFFFEFF;
            }
            if ((this.bondOrder & 0x3FF) != 0 && (!this.showMultipleBonds || this.modeMultipleBond == 0 || this.modeMultipleBond == 2 && this.mad > 500)) {
                this.bondOrder = 1;
            }
        }
        int n2 = 0;
        switch (this.bondOrder) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 17: 
            case 513: {
                this.bondOrder = 1;
                n2 = n == 513 ? 0 : 1;
                break;
            }
            case 514: 
            case 515: {
                this.bondOrder = 2;
                n2 = n == 515 ? this.getAromaticDottedBondMask() : 0;
                break;
            }
            default: {
                if ((this.bondOrder & 0xE0) != 0) {
                    this.bondOrder = JmolConstants.getPartialBondOrder(n);
                    n2 = JmolConstants.getPartialBondDotted(n);
                    break;
                }
                if (Bond.isHydrogen(this.bondOrder)) {
                    this.bondOrder = 1;
                    if (this.hbondsSolid) break;
                    n2 = -1;
                    break;
                }
                if (this.bondOrder != 32768) break;
                this.bondOrder = 1;
            }
        }
        this.mad = this.bond.getMad();
        if (this.multipleBondRadiusFactor > 0.0f && this.bondOrder > 1) {
            this.mad = (short)((float)this.mad * this.multipleBondRadiusFactor);
        }
        this.dx = this.xB - this.xA;
        this.dy = this.yB - this.yA;
        this.width = this.viewer.scaleToScreen((this.zA + this.zB) / 2, this.mad);
        if (this.renderWireframe && this.width > 0) {
            this.width = 1;
        }
        boolean bl = this.lineBond = this.width <= 1;
        if (this.lineBond && this.isAntialiased) {
            this.width = 3;
            this.lineBond = false;
        }
        switch (n2) {
            case -1: {
                this.renderHbondDashed();
                break;
            }
            default: {
                this.drawBond(n2);
            }
        }
    }

    private void drawBond(int n) {
        boolean bl;
        boolean bl2;
        if (this.exportType == 1 && this.bondOrder == 1) {
            this.g3d.drawBond(this.atomA, this.atomB, this.colixA, this.colixB, this.endcaps, this.mad);
            return;
        }
        boolean bl3 = bl2 = this.dx == 0 && this.dy == 0;
        if (bl2 && this.lineBond) {
            return;
        }
        boolean bl4 = bl = this.bondOrder > 1 && this.multipleBondSpacing > 0.0f && (this.viewer.getHybridizationAndAxes(this.atomA.index, this.z, this.x, "pz") != null || this.viewer.getHybridizationAndAxes(this.atomB.index, this.z, this.x, "pz") != null) && !Float.isNaN(this.x.x);
        if (bl2 && !bl) {
            int n2 = this.width / 8 + 3;
            int n3 = this.width + n2;
            int n4 = this.yA - (this.bondOrder - 1) * n3 / 2;
            do {
                this.fillCylinder(this.colixA, this.colixA, this.endcaps, this.width, this.xA, n4, this.zA, this.xA, n4, this.zA);
                n4 += n3;
            } while (--this.bondOrder > 0);
            return;
        }
        if (this.bondOrder == 1) {
            if ((n & 1) != 0) {
                this.drawDashed(this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            }
            return;
        }
        if (bl) {
            this.x.sub(this.atomB, this.atomA);
            this.y.cross(this.x, this.z);
            this.y.normalize();
            this.y.scale(this.multipleBondSpacing);
            this.x.set(this.y);
            this.x.scale((float)(this.bondOrder - 1) / 2.0f);
            this.p1.sub(this.atomA, this.x);
            this.p2.sub(this.atomB, this.x);
            while (true) {
                this.viewer.transformPoint(this.p1, this.s1);
                this.viewer.transformPoint(this.p2, this.s2);
                this.p1.add(this.y);
                this.p2.add(this.y);
                if ((n & 1) != 0) {
                    this.drawDashed(this.s1.x, this.s1.y, this.s1.z, this.s2.x, this.s2.y, this.s2.z);
                } else {
                    this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.s1.x, this.s1.y, this.s1.z, this.s2.x, this.s2.y, this.s2.z);
                }
                n >>= 1;
                if (--this.bondOrder <= 0) break;
                this.stepAxisCoordinates();
            }
            return;
        }
        int n5 = this.dx * this.dx;
        int n6 = this.dy * this.dy;
        this.mag2d = (int)(Math.sqrt(n5 + n6) + 0.5);
        this.resetAxisCoordinates();
        while (true) {
            if ((n & 1) != 0) {
                this.drawDashed(this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            }
            n >>= 1;
            if (--this.bondOrder <= 0) break;
            this.stepAxisCoordinates();
        }
    }

    private void resetAxisCoordinates() {
        int n = this.mag2d >> 3;
        if (this.multipleBondSpacing != -1.0f && this.multipleBondSpacing < 0.0f) {
            n = (int)((float)n * -this.multipleBondSpacing);
        }
        int n2 = this.width + n;
        this.dxStep = n2 * this.dy / this.mag2d;
        this.dyStep = n2 * -this.dx / this.mag2d;
        this.xAxis1 = this.xA;
        this.yAxis1 = this.yA;
        this.xAxis2 = this.xB;
        this.yAxis2 = this.yB;
        int n3 = this.bondOrder - 1;
        this.xAxis1 -= this.dxStep * n3 / 2;
        this.yAxis1 -= this.dyStep * n3 / 2;
        this.xAxis2 -= this.dxStep * n3 / 2;
        this.yAxis2 -= this.dyStep * n3 / 2;
    }

    private void stepAxisCoordinates() {
        this.xAxis1 += this.dxStep;
        this.yAxis1 += this.dyStep;
        this.xAxis2 += this.dxStep;
        this.yAxis2 += this.dyStep;
    }

    private int getAromaticDottedBondMask() {
        Atom atom = this.atomB.findAromaticNeighbor(this.atomA.getIndex());
        if (atom == null) {
            return 1;
        }
        int n = atom.screenY - this.yA;
        int n2 = atom.screenX - this.xA;
        return this.dx * n - this.dy * n2 < 0 ? 2 : 1;
    }

    private void drawDashed(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n4 - n;
        int n8 = n5 - n2;
        int n9 = n6 - n3;
        for (int i = 2; i <= 9; i += 2) {
            int n10 = n + n7 * i / 12;
            int n11 = n2 + n8 * i / 12;
            int n12 = n3 + n9 * i / 12;
            int n13 = n + n7 * (i += 3) / 12;
            int n14 = n2 + n8 * i / 12;
            int n15 = n3 + n9 * i / 12;
            this.fillCylinder(this.colixA, this.colixB, (byte)2, this.width, n10, n11, n12, n13, n14, n15);
        }
    }

    private void renderHbondDashed() {
        int n = this.xB - this.xA;
        int n2 = this.yB - this.yA;
        int n3 = this.zB - this.zA;
        for (int i = 1; i < 10; ++i) {
            int n4 = this.xA + n * i / 10;
            int n5 = this.yA + n2 * i / 10;
            int n6 = this.zA + n3 * i / 10;
            short s = i < 5 ? this.colixA : this.colixB;
            int n7 = this.xA + n * (i += 2) / 10;
            int n8 = this.yA + n2 * i / 10;
            int n9 = this.zA + n3 * i / 10;
            short s2 = i < 5 ? this.colixA : this.colixB;
            this.fillCylinder(s, s2, (byte)2, this.width, n4, n5, n6, n7, n8, n9);
        }
    }

    private void fillCylinder(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.lineBond) {
            this.g3d.drawLine(s, s2, n2, n3, n4, n5, n6, n7);
        } else {
            this.g3d.fillCylinder(s, s2, by, this.exportType == 0 || this.mad == 1 ? n : (int)this.mad, n2, n3, n4, n5, n6, n7);
        }
    }
}

