/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.Logger;

public class HBond
extends Bond {
    float energy;
    private byte paletteID;

    public HBond(Atom atom, Atom atom2, int n, short s, short s2, float f) {
        super(atom, atom2, n, s, s2);
        this.energy = f;
        if (Logger.debugging) {
            Logger.info("HBond energy = " + f + " #" + this.getIdentity());
        }
    }

    public HBond(Atom atom, Atom atom2, int n, float f) {
        super(atom, atom2, n, (short)1, (short)0);
        this.energy = f;
        if (Logger.debugging) {
            Logger.info("HBond energy = " + f + " #" + this.getIdentity());
        }
    }

    public float getEnergy() {
        return this.energy;
    }

    public void setPaletteID(byte by) {
        this.paletteID = by;
    }

    public static final int getEnergy(double d, double d2, double d3, double d4) {
        int n = (int)Math.floor(-27888.0 / d - -27888.0 / d4 + -27888.0 / d3 - -27888.0 / d2 + 0.5);
        return n;
    }
}

