/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.sph;

import org.jbox2d.collision.AABB;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.util.sph.Parameter;
import org.jbox2d.util.sph.SmoothParticle;

public class SPHGroup {
    public SmoothParticle[] t;
    public Parameter param = new Parameter();

    public SPHGroup(int n, AABB aABB, float f) {
        this.param.numPts = n;
        this.param.initVel = new Vec2(0.0f, 0.0f);
        this.param.machNum = 0.5;
        this.param.initDensity = 1000.0;
        this.param.initPressure = 10000.0;
        this.param.nu = 1000.0;
        this.param.deltaT = f;
        this.param.numSteps = 500000;
        this.param.outputEvery = 5000;
        this.param.firstOutput = 0;
        this.param.densityVariation = 0.3;
        this.param.lengthScale = 1000.0;
        this.param.bodyFX = 0.0;
        this.param.bodyFY = 0.0;
        this.param.c = 1.0;
        this.param.h = 1000.0;
        this.t = new SmoothParticle[n];
        for (int i = 0; i < n; ++i) {
            float f2 = MathUtils.randomFloat(aABB.lowerBound.x, aABB.upperBound.x);
            float f3 = MathUtils.randomFloat(aABB.lowerBound.y, aABB.upperBound.y);
            this.t[i] = new SmoothParticle();
            this.t[i].pos.set(new Vec2(f2, f3));
            this.t[i].vel.set(this.param.initVel);
            this.t[i].mass = 1.0;
            this.t[i].setDensity(this.param.initDensity);
            this.t[i].setPressure(this.param.initPressure);
            this.t[i].setSmoothingLength(this.param.h);
            this.t[i].setSpeedSound(this.param.c);
            this.t[i].undeleteParticle();
            this.t[i].ID = i;
            this.t[i].setShapeID(-1);
        }
    }

    public void calcPressure() {
        for (int i = 0; i < this.t.length; ++i) {
            if (this.t[i].isEmpty()) continue;
            this.t[i].setMinMaxDensity();
            this.t[i].calcPressure(this.param);
        }
    }

    public void calcSPHEquations(SmoothParticle smoothParticle, SmoothParticle smoothParticle2) {
        if (smoothParticle.isEmpty() || smoothParticle2.isEmpty()) {
            System.out.println("Panic!  Particle is empty!");
        }
        Vec2 vec2 = new Vec2(smoothParticle.vel.x - smoothParticle2.vel.x, smoothParticle.vel.y - smoothParticle2.vel.y);
        smoothParticle.calcChangeDensity(smoothParticle2, vec2);
        smoothParticle.calcChangeVelocity(smoothParticle2, vec2, this.param);
        smoothParticle.addForceX(this.param);
        smoothParticle.addForceY(this.param);
    }

    public void calcCorrectDeltaT() {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        d3 = 0.0;
        for (n = 0; n < this.t.length; ++n) {
            if (this.t[n].isEmpty() || !((d4 = (d = this.t[n].getChangeVelocityX()) * d + (d2 = this.t[n].getChangeVelocityY()) * d2) > d3)) continue;
            d3 = d4;
        }
        double d5 = 1.0E7;
        if (d3 > 0.0) {
            d5 = 0.25 * Math.sqrt(this.param.h / Math.sqrt(d3));
        }
        if (d5 < this.param.deltaT) {
            System.out.println("current DT: " + this.param.deltaT + " is not small enough.");
            System.out.println("It should be: " + d5);
        }
    }

    public void updateParticles() {
        int n;
        this.calcPressure();
        for (int i = 0; i < this.t.length; ++i) {
            this.t[i].zeroSPHVars();
            for (n = 0; n < this.t.length; ++n) {
                if (i == n) continue;
                this.calcSPHEquations(this.t[i], this.t[n]);
            }
        }
        float f = (float)this.param.deltaT;
        for (n = 0; n < this.t.length; ++n) {
            SmoothParticle smoothParticle = this.t[n];
            smoothParticle.vel.x += (float)smoothParticle.getChangeVelocityX() * f;
            smoothParticle.vel.y += (float)smoothParticle.getChangeVelocityY() * f;
            smoothParticle.density += (double)((float)smoothParticle.getChangeDensity() * f);
            smoothParticle.pos.x += smoothParticle.vel.x * f;
            smoothParticle.pos.y += smoothParticle.vel.y * f;
            System.out.println(smoothParticle.getChangeVelocityY());
        }
    }
}

