/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class VerticalStack
extends TestbedTest {
    public static final int e_columnCount = 5;
    public static final int e_rowCount = 16;
    Body m_bullet;
    Body[] m_bodies = new Body[80];
    int[] m_indices = new int[80];

    public void initTest() {
        Object object = new BodyDef();
        Body body = this.m_world.createBody((BodyDef)object);
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        body.createFixture(polygonShape, 0.0f);
        polygonShape.setAsEdge(new Vec2(20.0f, 0.0f), new Vec2(20.0f, 20.0f));
        body.createFixture(polygonShape, 0.0f);
        object = new float[]{0.0f, -10.0f, -5.0f, 5.0f, 10.0f};
        for (int i = 0; i < 5; ++i) {
            polygonShape = new PolygonShape();
            polygonShape.setAsBox(0.5f, 0.5f);
            FixtureDef fixtureDef = new FixtureDef();
            fixtureDef.shape = polygonShape;
            fixtureDef.density = 1.0f;
            fixtureDef.friction = 0.3f;
            for (int j = 0; j < 16; ++j) {
                Body body2;
                BodyDef bodyDef = new BodyDef();
                bodyDef.type = BodyType.DYNAMIC;
                int n = i * 16 + j;
                assert (n < 80);
                this.m_indices[n] = n;
                bodyDef.userData = this.m_indices[n];
                float f = 0.0f;
                bodyDef.position.set((float)(object[i] + f), 0.752f + 1.54f * (float)j);
                this.m_bodies[n] = body2 = this.m_world.createBody(bodyDef);
                body2.createFixture(fixtureDef);
            }
        }
        this.m_bullet = null;
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case ',': {
                if (this.m_bullet != null) {
                    this.m_world.destroyBody(this.m_bullet);
                    this.m_bullet = null;
                }
                CircleShape circleShape = new CircleShape();
                circleShape.m_radius = 0.25f;
                FixtureDef fixtureDef = new FixtureDef();
                fixtureDef.shape = circleShape;
                fixtureDef.density = 20.0f;
                fixtureDef.restitution = 0.05f;
                BodyDef bodyDef = new BodyDef();
                bodyDef.type = BodyType.DYNAMIC;
                bodyDef.bullet = true;
                bodyDef.position.set(-31.0f, 5.0f);
                this.m_bullet = this.m_world.createBody(bodyDef);
                this.m_bullet.createFixture(fixtureDef);
                this.m_bullet.setLinearVelocity(new Vec2(400.0f, 0.0f));
            }
        }
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        this.addTextLine("Press ',' to launch bullet.");
    }

    public String getTestName() {
        return "Vertical Stack";
    }
}

