/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import java.util.ArrayList;
import java.util.Arrays;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class LiquidTest
extends TestbedTest {
    private boolean firstTime = true;
    private int nParticles = 1000;
    private float totalMass = 10.0f;
    private float boxWidth = 2.0f;
    private float boxHeight = 20.0f;
    private float fluidMinX = -11.0f;
    private float fluidMaxX = 5.0f;
    private float fluidMinY = -10.0f;
    private float fluidMaxY = 10.0f;
    private Body[] liquid;
    private float rad = 0.6f;
    private float visc = 0.004f;
    private ArrayList<Integer>[][] hash = new ArrayList[40][40];
    private int hashWidth;
    private int hashHeight;
    public static Integer LIQUID_INT = new Integer(1234598372);
    private Body bod;

    private int hashX(float f) {
        float f2 = MathUtils.map(f, this.fluidMinX, this.fluidMaxX, 0.0f, (float)this.hashWidth - 0.001f);
        return (int)f2;
    }

    private int hashY(float f) {
        float f2 = MathUtils.map(f, this.fluidMinY, this.fluidMaxY, 0.0f, (float)this.hashHeight - 0.001f);
        return (int)f2;
    }

    public LiquidTest() {
        for (int i = 0; i < 40; ++i) {
            for (int j = 0; j < 40; ++j) {
                this.hash[i][j] = new ArrayList();
            }
        }
        this.hashWidth = 40;
        this.hashHeight = 40;
    }

    private void hashLocations() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.hashWidth; ++n2) {
            for (n = 0; n < this.hashHeight; ++n) {
                this.hash[n2][n].clear();
            }
        }
        for (n2 = 0; n2 < this.liquid.length; ++n2) {
            n = this.hashX(this.liquid[n2].m_sweep.c.x);
            int n3 = this.hashY(this.liquid[n2].m_sweep.c.y);
            if (n <= -1 || n >= this.hashWidth || n3 <= -1 || n3 >= this.hashHeight) continue;
            this.hash[n][n3].add(new Integer(n2));
        }
    }

    private void applyLiquidConstraint(float f) {
        int n;
        float f2 = 50.0f / this.rad;
        float[] fArray = new float[this.liquid.length];
        float[] fArray2 = new float[this.liquid.length];
        Arrays.fill(fArray, 0.0f);
        Arrays.fill(fArray2, 0.0f);
        float[] fArray3 = new float[this.liquid.length];
        float[] fArray4 = new float[this.liquid.length];
        float[] fArray5 = new float[this.liquid.length];
        float[] fArray6 = new float[this.liquid.length];
        for (n = 0; n < this.liquid.length; ++n) {
            fArray3[n] = f2 * this.liquid[n].m_sweep.c.x;
            fArray4[n] = f2 * this.liquid[n].m_sweep.c.y;
            fArray5[n] = f2 * this.liquid[n].m_linearVelocity.x;
            fArray6[n] = f2 * this.liquid[n].m_linearVelocity.y;
        }
        n = 0;
        while (n < this.liquid.length) {
            float f3;
            int n2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n3 = this.hashX(this.liquid[n].m_sweep.c.x);
            int n4 = this.hashY(this.liquid[n].m_sweep.c.y);
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    int n5 = n3 + i;
                    n2 = n4 + j;
                    if (n5 <= -1 || n5 >= this.hashWidth || n2 <= -1 || n2 >= this.hashHeight || this.hash[n5][n2].size() <= 0) continue;
                    for (int k = 0; k < this.hash[n5][n2].size(); ++k) {
                        Integer n6 = this.hash[n5][n2].get(k);
                        if (n6 == null || n6 == n) continue;
                        arrayList.add(n6);
                    }
                }
            }
            float[] fArray7 = new float[arrayList.size()];
            float f4 = 0.0f;
            float f5 = 0.0f;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                Integer n7 = (Integer)arrayList.get(n2);
                int n8 = n7;
                f3 = fArray3[n8] - fArray3[n];
                float f6 = fArray4[n8] - fArray4[n];
                if (!(f3 > -50.0f) || !(f3 < 50.0f) || !(f6 > -50.0f) || !(f6 < 50.0f)) continue;
                float f7 = f3 * f3 + f6 * f6;
                if (f7 < 2500.0f) {
                    fArray7[n2] = (float)Math.sqrt(f7);
                    if (fArray7[n2] < 1.1920929E-7f) {
                        fArray7[n2] = 49.99f;
                    }
                    float f8 = 1.0f - fArray7[n2] / 50.0f;
                    f4 += f8 * f8;
                    f5 += f8 * f8 * f8;
                    continue;
                }
                fArray7[n2] = Float.MAX_VALUE;
            }
            float f9 = (f4 - 5.0f) / 2.0f;
            float f10 = f5 / 2.0f;
            float f11 = 0.0f;
            f3 = 0.0f;
            for (int i = 0; i < arrayList.size(); ++i) {
                Integer n9 = (Integer)arrayList.get(i);
                int n10 = n9;
                float f12 = fArray3[n10] - fArray3[n];
                float f13 = fArray4[n10] - fArray4[n];
                if (!(f12 > -50.0f) || !(f12 < 50.0f) || !(f13 > -50.0f) || !(f13 < 50.0f) || !(fArray7[i] < 50.0f)) continue;
                float f14 = fArray7[i] / 50.0f;
                float f15 = 1.0f - f14;
                float f16 = f15 * (f9 + f10 * f15) / (2.0f * fArray7[i]);
                float f17 = f12 * f16;
                float f18 = f13 * f16;
                float f19 = fArray5[n10] - fArray5[n];
                float f20 = fArray6[n10] - fArray6[n];
                f16 = this.visc * f15 * f;
                int n11 = n10;
                fArray[n11] = fArray[n11] + (f17 -= f19 * f16);
                int n12 = n10;
                fArray2[n12] = fArray2[n12] + (f18 -= f20 * f16);
                f11 -= f17;
                f3 -= f18;
            }
            int n13 = n;
            fArray[n13] = fArray[n13] + f11;
            int n14 = n++;
            fArray2[n14] = fArray2[n14] + f3;
        }
        for (n = 0; n < this.liquid.length; ++n) {
            this.liquid[n].m_xf.position.x += fArray[n] / f2;
            this.liquid[n].m_xf.position.y += fArray2[n] / f2;
            this.liquid[n].m_linearVelocity.x += fArray[n] / (f2 * f);
            this.liquid[n].m_linearVelocity.y += fArray2[n] / (f2 * f);
        }
    }

    public void initTest() {
        BodyDef bodyDef;
        if (this.firstTime) {
            this.setCamera(0.0f, 2.0f, 35.0f);
            this.firstTime = false;
        }
        Body body = null;
        BodyDef bodyDef2 = new BodyDef();
        bodyDef2.position.set(0.0f, 0.0f);
        body = this.m_world.createBody(bodyDef2);
        Shape shape = new PolygonShape();
        shape.setAsBox(5.0f, 0.5f);
        body.createFixture(shape, 0.0f);
        shape.setAsBox(1.0f, 0.2f, new Vec2(0.0f, 4.0f), -0.2f);
        body.createFixture(shape, 0.0f);
        shape.setAsBox(1.5f, 0.2f, new Vec2(-1.2f, 5.2f), -1.5f);
        body.createFixture(shape, 0.0f);
        shape.setAsBox(0.5f, 50.0f, new Vec2(5.0f, 0.0f), 0.0f);
        body.createFixture(shape, 0.0f);
        shape.setAsBox(0.5f, 3.0f, new Vec2(-8.0f, 0.0f), 0.0f);
        body.createFixture(shape, 0.0f);
        shape.setAsBox(2.0f, 0.1f, new Vec2(-6.0f, -2.8f), 0.1f);
        body.createFixture(shape, 0.0f);
        Object object = new CircleShape();
        ((CircleShape)object).m_radius = 0.5f;
        ((CircleShape)object).m_p.set(-0.5f, -4.0f);
        body.createFixture((Shape)object, 0.0f);
        this.liquid = new Body[this.nParticles];
        float f = this.totalMass / (float)this.nParticles;
        shape = new CircleShape();
        object = new FixtureDef();
        ((FixtureDef)object).shape = shape;
        ((FixtureDef)object).density = 1.0f;
        ((FixtureDef)object).filter.groupIndex = -10;
        ((CircleShape)shape).m_radius = 0.05f;
        ((FixtureDef)object).restitution = 0.4f;
        ((FixtureDef)object).friction = 0.0f;
        float f2 = 0.0f;
        float f3 = 25.0f;
        for (int i = 0; i < this.nParticles; ++i) {
            bodyDef = new BodyDef();
            bodyDef.position = new Vec2(MathUtils.randomFloat(f2 - this.boxWidth * 0.5f, f2 + this.boxWidth * 0.5f), MathUtils.randomFloat(f3 - this.boxHeight * 0.5f, f3 + this.boxHeight * 0.5f));
            bodyDef.fixedRotation = true;
            bodyDef.type = BodyType.DYNAMIC;
            Body body2 = this.m_world.createBody(bodyDef);
            body2.createFixture((FixtureDef)object).setUserData(LIQUID_INT);
            MassData massData = new MassData();
            massData.mass = f;
            massData.I = 1.0f;
            body2.setMassData(massData);
            body2.setSleepingAllowed(false);
            this.liquid[i] = body2;
        }
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsBox(MathUtils.randomFloat(0.3f, 0.7f), MathUtils.randomFloat(0.3f, 0.7f));
        bodyDef = new BodyDef();
        bodyDef.position = new Vec2(0.0f, 25.0f);
        bodyDef.type = BodyType.DYNAMIC;
        this.bod = this.m_world.createBody(bodyDef);
        this.bod.createFixture(polygonShape, 1.0f);
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        float f = 1.0f / testbedSettings.hz;
        int n = 1;
        for (int i = 0; i < n; ++i) {
            this.hashLocations();
            this.applyLiquidConstraint(f * (float)n);
        }
        this.dampenLiquid();
        this.checkBounds();
    }

    private void checkBounds() {
        for (int i = 0; i < this.liquid.length; ++i) {
            if (!(this.liquid[i].getWorldCenter().y < -10.0f)) continue;
            this.m_world.destroyBody(this.liquid[i]);
            float f = this.totalMass / (float)this.nParticles;
            CircleShape circleShape = new CircleShape();
            FixtureDef fixtureDef = new FixtureDef();
            fixtureDef.shape = circleShape;
            fixtureDef.density = 1.0f;
            fixtureDef.filter.groupIndex = -10;
            circleShape.m_radius = 0.05f;
            fixtureDef.restitution = 0.4f;
            fixtureDef.friction = 0.0f;
            float f2 = 0.0f + MathUtils.randomFloat(-0.6f, 0.6f);
            float f3 = 15.0f + MathUtils.randomFloat(-2.3f, 2.0f);
            BodyDef bodyDef = new BodyDef();
            bodyDef.position = new Vec2(f2, f3);
            bodyDef.fixedRotation = true;
            bodyDef.type = BodyType.DYNAMIC;
            Body body = this.m_world.createBody(bodyDef);
            body.createFixture(fixtureDef).setUserData(LIQUID_INT);
            MassData massData = new MassData();
            massData.mass = f;
            massData.I = 1.0f;
            body.setMassData(massData);
            body.setSleepingAllowed(false);
            this.liquid[i] = body;
        }
        if (this.bod.getWorldCenter().y < -15.0f) {
            this.m_world.destroyBody(this.bod);
            PolygonShape polygonShape = new PolygonShape();
            polygonShape.setAsBox(MathUtils.randomFloat(0.3f, 0.7f), MathUtils.randomFloat(0.3f, 0.7f));
            BodyDef bodyDef = new BodyDef();
            bodyDef.position = new Vec2(0.0f, 25.0f);
            bodyDef.type = BodyType.DYNAMIC;
            this.bod = this.m_world.createBody(bodyDef);
            this.bod.createFixture(polygonShape, 1.0f);
        }
    }

    private void dampenLiquid() {
        for (int i = 0; i < this.liquid.length; ++i) {
            Body body = this.liquid[i];
            body.setLinearVelocity(body.getLinearVelocity().mul(0.995f));
        }
    }

    public String getTestName() {
        return "Liquid Test";
    }
}

