/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import java.util.Random;
import org.jbox2d.callbacks.TreeCallback;
import org.jbox2d.callbacks.TreeRayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.broadphase.DynamicTree;
import org.jbox2d.collision.broadphase.DynamicTreeNode;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.arrays.Vec2Array;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class DynamicTreeTest
extends TestbedTest
implements TreeCallback,
TreeRayCastCallback {
    int e_actorCount = 128;
    float worldExtent;
    float m_proxyExtent;
    DynamicTree m_tree;
    AABB m_queryAABB;
    RayCastInput m_rayCastInput;
    RayCastOutput m_rayCastOutput;
    Actor m_rayActor;
    Actor[] m_actors = new Actor[this.e_actorCount];
    int m_stepCount;
    boolean m_automated;
    Random rand = new Random();
    private Vec2Array vecPool = new Vec2Array();

    public void initTest() {
        this.worldExtent = 15.0f;
        this.m_proxyExtent = 0.5f;
        this.m_tree = new DynamicTree();
        for (int i = 0; i < this.e_actorCount; ++i) {
            Actor actor = this.m_actors[i] = new Actor();
            this.GetRandomAABB(actor.aabb);
            actor.proxyId = this.m_tree.createProxy(actor.aabb, actor);
        }
        this.m_stepCount = 0;
        float f = this.worldExtent;
        this.m_queryAABB = new AABB();
        this.m_queryAABB.lowerBound.set(-3.0f, -4.0f + f);
        this.m_queryAABB.upperBound.set(5.0f, 6.0f + f);
        this.m_rayCastInput = new RayCastInput();
        this.m_rayCastInput.p1.set(-5.0f, 5.0f + f);
        this.m_rayCastInput.p2.set(7.0f, -4.0f + f);
        this.m_rayCastInput.maxFraction = 1.0f;
        this.m_rayCastOutput = new RayCastOutput();
        this.m_automated = false;
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case 'a': {
                this.m_automated = !this.m_automated;
                break;
            }
            case 'c': {
                this.CreateProxy();
                break;
            }
            case 'd': {
                this.DestroyProxy();
                break;
            }
            case 'm': {
                this.MoveProxy();
            }
        }
    }

    public void step(TestbedSettings testbedSettings) {
        Color3f color3f;
        Object object;
        int n;
        int n2;
        this.m_rayActor = null;
        for (n2 = 0; n2 < this.e_actorCount; ++n2) {
            this.m_actors[n2].fraction = 1.0f;
            this.m_actors[n2].overlap = false;
        }
        if (this.m_automated) {
            n2 = MathUtils.max(1, this.e_actorCount >> 2);
            for (n = 0; n < n2; ++n) {
                this.Action();
            }
        }
        this.Query();
        this.RayCast();
        Vec2[] vec2Array = (Vec2[])this.vecPool.get(4);
        for (n = 0; n < this.e_actorCount; ++n) {
            object = this.m_actors[n];
            if (((Actor)object).proxyId == null) continue;
            color3f = new Color3f(0.9f, 0.9f, 0.9f);
            if (object == this.m_rayActor && ((Actor)object).overlap) {
                color3f.set(0.9f, 0.6f, 0.6f);
            } else if (object == this.m_rayActor) {
                color3f.set(0.6f, 0.9f, 0.6f);
            } else if (((Actor)object).overlap) {
                color3f.set(0.6f, 0.6f, 0.9f);
            }
            ((Actor)object).aabb.getVertices(vec2Array);
            this.m_debugDraw.drawPolygon(vec2Array, 4, color3f);
        }
        Color3f color3f2 = new Color3f(0.7f, 0.7f, 0.7f);
        this.m_queryAABB.getVertices(vec2Array);
        this.m_debugDraw.drawPolygon(vec2Array, 4, color3f2);
        this.m_debugDraw.drawSegment(this.m_rayCastInput.p1, this.m_rayCastInput.p2, color3f2);
        object = new Color3f(0.2f, 0.9f, 0.2f);
        color3f = new Color3f(0.9f, 0.2f, 0.2f);
        this.m_debugDraw.drawPoint(this.m_rayCastInput.p1, 6.0f, (Color3f)object);
        this.m_debugDraw.drawPoint(this.m_rayCastInput.p2, 6.0f, color3f);
        if (this.m_rayActor != null) {
            Color3f color3f3 = new Color3f(0.2f, 0.2f, 0.9f);
            Vec2 vec2 = this.m_rayCastInput.p2.sub(this.m_rayCastInput.p1).mulLocal(this.m_rayActor.fraction).addLocal(this.m_rayCastInput.p1);
            this.m_debugDraw.drawPoint(vec2, 6.0f, color3f3);
        }
        ++this.m_stepCount;
        if (testbedSettings.drawDynamicTree) {
            this.m_tree.drawTree(this.m_debugDraw);
        }
        this.m_textLine += 15;
        this.m_debugDraw.drawString(5.0f, this.m_textLine, "(c)reate proxy, (d)estroy proxy, (a)utomate", Color3f.WHITE);
    }

    public boolean treeCallback(DynamicTreeNode dynamicTreeNode) {
        Actor actor = (Actor)dynamicTreeNode.userData;
        actor.overlap = AABB.testOverlap(this.m_queryAABB, actor.aabb);
        return true;
    }

    public float raycastCallback(RayCastInput rayCastInput, DynamicTreeNode dynamicTreeNode) {
        Actor actor = (Actor)dynamicTreeNode.userData;
        RayCastOutput rayCastOutput = new RayCastOutput();
        boolean bl = actor.aabb.raycast(rayCastOutput, rayCastInput, this.m_world.getPool());
        if (bl) {
            this.m_rayCastOutput = rayCastOutput;
            this.m_rayActor = actor;
            this.m_rayActor.fraction = rayCastOutput.fraction;
            return rayCastOutput.fraction;
        }
        return rayCastInput.maxFraction;
    }

    public void GetRandomAABB(AABB aABB) {
        Vec2 vec2 = new Vec2();
        vec2.set(2.0f * this.m_proxyExtent, 2.0f * this.m_proxyExtent);
        aABB.lowerBound.x = MathUtils.randomFloat(this.rand, -this.worldExtent, this.worldExtent);
        aABB.lowerBound.y = MathUtils.randomFloat(this.rand, 0.0f, 2.0f * this.worldExtent);
        aABB.upperBound.set(aABB.lowerBound).addLocal(vec2);
    }

    public void MoveAABB(AABB aABB) {
        Vec2 vec2 = new Vec2();
        vec2.x = MathUtils.randomFloat(this.rand, -0.5f, 0.5f);
        vec2.y = MathUtils.randomFloat(this.rand, -0.5f, 0.5f);
        aABB.lowerBound.addLocal(vec2);
        aABB.upperBound.addLocal(vec2);
        Vec2 vec22 = aABB.lowerBound.add(aABB.upperBound).mulLocal(0.5f);
        Vec2 vec23 = new Vec2();
        vec23.set(-this.worldExtent, 0.0f);
        Vec2 vec24 = new Vec2();
        vec24.set(this.worldExtent, 2.0f * this.worldExtent);
        Vec2 vec25 = MathUtils.clamp(vec22, vec23, vec24);
        aABB.lowerBound.addLocal(vec25.sub(vec22));
        aABB.upperBound.addLocal(vec25.sub(vec22));
    }

    public void CreateProxy() {
        for (int i = 0; i < this.e_actorCount; ++i) {
            int n = MathUtils.abs(this.rand.nextInt() % this.e_actorCount);
            Actor actor = this.m_actors[n];
            if (actor.proxyId != null) continue;
            this.GetRandomAABB(actor.aabb);
            actor.proxyId = this.m_tree.createProxy(actor.aabb, actor);
            return;
        }
    }

    public void DestroyProxy() {
        for (int i = 0; i < this.e_actorCount; ++i) {
            int n = MathUtils.abs(this.rand.nextInt() % this.e_actorCount);
            Actor actor = this.m_actors[n];
            if (actor.proxyId == null) continue;
            this.m_tree.destroyProxy(actor.proxyId);
            actor.proxyId = null;
            return;
        }
    }

    public void MoveProxy() {
        for (int i = 0; i < this.e_actorCount; ++i) {
            int n = MathUtils.abs(this.rand.nextInt() % this.e_actorCount);
            Actor actor = this.m_actors[n];
            if (actor.proxyId == null) continue;
            AABB aABB = new AABB(actor.aabb);
            this.MoveAABB(actor.aabb);
            Vec2 vec2 = actor.aabb.getCenter().sub(aABB.getCenter());
            this.m_tree.moveProxy(actor.proxyId, new AABB(actor.aabb), vec2);
            return;
        }
    }

    public void Action() {
        int n = MathUtils.abs(this.rand.nextInt() % 20);
        switch (n) {
            case 0: {
                this.CreateProxy();
                break;
            }
            case 1: {
                this.DestroyProxy();
                break;
            }
            default: {
                this.MoveProxy();
            }
        }
    }

    public void Query() {
        this.m_tree.query(this, this.m_queryAABB);
        for (int i = 0; i < this.e_actorCount; ++i) {
            if (this.m_actors[i].proxyId == null) continue;
            boolean bl = AABB.testOverlap(this.m_queryAABB, this.m_actors[i].aabb);
            assert (bl == this.m_actors[i].overlap);
        }
    }

    public void RayCast() {
        this.m_rayActor = null;
        RayCastInput rayCastInput = this.m_rayCastInput;
        this.m_tree.raycast(this, rayCastInput);
        Actor actor = null;
        RayCastOutput rayCastOutput = new RayCastOutput();
        for (int i = 0; i < this.e_actorCount; ++i) {
            RayCastOutput rayCastOutput2;
            boolean bl;
            if (this.m_actors[i].proxyId == null || !(bl = this.m_actors[i].aabb.raycast(rayCastOutput2 = new RayCastOutput(), rayCastInput, this.m_world.getPool()))) continue;
            actor = this.m_actors[i];
            rayCastOutput = rayCastOutput2;
        }
        if (actor != null) assert (MathUtils.abs(rayCastOutput.fraction - this.m_rayCastOutput.fraction) <= 1.1920929E-7f);
    }

    public String getTestName() {
        return "Dynamic Tree";
    }

    public static class Actor {
        AABB aabb = new AABB();
        float fraction;
        boolean overlap;
        DynamicTreeNode proxyId;
    }
}

