/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import java.util.HashSet;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.ContactPoint;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class CollisionProcessing
extends TestbedTest {
    public void initTest() {
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsEdge(new Vec2(-50.0f, 0.0f), new Vec2(50.0f, 0.0f));
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.shape = polygonShape;
        BodyDef bodyDef = new BodyDef();
        Body body = this.m_world.createBody(bodyDef);
        body.createFixture(fixtureDef);
        float f = -5.0f;
        float f2 = 5.0f;
        float f3 = 2.0f;
        float f4 = 35.0f;
        Vec2[] vec2Array = new Vec2[]{new Vec2(-1.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 2.0f)};
        PolygonShape polygonShape2 = new PolygonShape();
        polygonShape2.set(vec2Array, 3);
        FixtureDef fixtureDef2 = new FixtureDef();
        fixtureDef2.shape = polygonShape2;
        fixtureDef2.density = 1.0f;
        BodyDef bodyDef2 = new BodyDef();
        bodyDef2.type = BodyType.DYNAMIC;
        bodyDef2.position.set(MathUtils.randomFloat(f, f2), MathUtils.randomFloat(f3, f4));
        Body body2 = this.m_world.createBody(bodyDef2);
        body2.createFixture(fixtureDef2);
        vec2Array[0].mulLocal(2.0f);
        vec2Array[1].mulLocal(2.0f);
        vec2Array[2].mulLocal(2.0f);
        polygonShape2.set(vec2Array, 3);
        bodyDef2.position.set(MathUtils.randomFloat(f, f2), MathUtils.randomFloat(f3, f4));
        Body body3 = this.m_world.createBody(bodyDef2);
        body3.createFixture(fixtureDef2);
        polygonShape2.setAsBox(1.0f, 0.5f);
        FixtureDef fixtureDef3 = new FixtureDef();
        fixtureDef3.shape = polygonShape2;
        fixtureDef3.density = 1.0f;
        BodyDef bodyDef3 = new BodyDef();
        bodyDef3.type = BodyType.DYNAMIC;
        bodyDef3.position.set(MathUtils.randomFloat(f, f2), MathUtils.randomFloat(f3, f4));
        Body body4 = this.m_world.createBody(bodyDef3);
        body4.createFixture(fixtureDef3);
        polygonShape2.setAsBox(2.0f, 1.0f);
        bodyDef3.position.set(MathUtils.randomFloat(f, f2), MathUtils.randomFloat(f3, f4));
        Body body5 = this.m_world.createBody(bodyDef3);
        body5.createFixture(fixtureDef3);
        CircleShape circleShape = new CircleShape();
        circleShape.m_radius = 1.0f;
        FixtureDef fixtureDef4 = new FixtureDef();
        fixtureDef4.shape = circleShape;
        fixtureDef4.density = 1.0f;
        BodyDef bodyDef4 = new BodyDef();
        bodyDef4.type = BodyType.DYNAMIC;
        bodyDef4.position.set(MathUtils.randomFloat(f, f2), MathUtils.randomFloat(f3, f4));
        Body body6 = this.m_world.createBody(bodyDef4);
        body6.createFixture(fixtureDef4);
        circleShape.m_radius *= 2.0f;
        bodyDef4.position.set(MathUtils.randomFloat(f, f2), MathUtils.randomFloat(f3, f4));
        Body body7 = this.m_world.createBody(bodyDef4);
        body7.createFixture(fixtureDef4);
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        HashSet<Body> hashSet = new HashSet<Body>();
        for (int i = 0; i < this.m_pointCount; ++i) {
            ContactPoint object = points[i];
            Body body = object.fixtureA.getBody();
            Body body2 = object.fixtureB.getBody();
            float f = body.getMass();
            float f2 = body2.getMass();
            if (!(f > 0.0f) || !(f2 > 0.0f)) continue;
            if (f2 > f) {
                hashSet.add(body);
                continue;
            }
            hashSet.add(body2);
        }
        for (Body body : hashSet) {
            if (body == this.m_bomb) continue;
            this.m_world.destroyBody(body);
        }
    }

    public String getTestName() {
        return "Collision Processing";
    }
}

