/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.perf;

public abstract class PerfTest {
    private final int numTests;
    private final int iters;
    private final long[] times;

    public PerfTest(int n, int n2) {
        this.numTests = n;
        this.iters = n2;
        this.times = new long[this.numTests];
        for (int i = 0; i < this.numTests; ++i) {
            this.times[i] = 0L;
        }
    }

    public void go() {
        int n;
        for (n = 0; n < this.iters; ++n) {
            System.out.println((double)n * 100.0 / (double)this.iters + "%");
            int n2 = 0;
            while (n2 < this.numTests) {
                long l = System.nanoTime();
                this.runTest(n2);
                long l2 = System.nanoTime();
                int n3 = n2++;
                this.times[n3] = this.times[n3] + (l2 - l);
            }
        }
        n = 0;
        while (n < this.numTests) {
            int n4 = n++;
            this.times[n4] = this.times[n4] / (long)this.iters;
        }
        this.printResults();
    }

    public void printResults() {
        System.out.printf("%-20s%20s\n", "Test Name", "Milliseconds Avg");
        for (int i = 0; i < this.numTests; ++i) {
            double d = (double)this.times[i] * 1.0 / 1000000.0;
            System.out.printf("%-20s%20.4f\n", this.getTestName(i), d);
        }
    }

    public abstract void runTest(int var1);

    public abstract String getTestName(int var1);
}

