/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.OBBViewportTransform;
import org.jbox2d.common.Vec2;
import org.jbox2d.testbed.framework.DebugDrawJ2D;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class TestPanel
extends JPanel
implements Runnable {
    public static final int INIT_WIDTH = 600;
    public static final int INIT_HEIGHT = 600;
    public static volatile boolean[] keys = new boolean[256];
    public static volatile boolean[] codedKeys = new boolean[512];
    private TestbedTest currTest = null;
    private TestbedTest nextTest = null;
    public DebugDraw draw = new DebugDrawJ2D(this);
    public final Vec2 mouse = new Vec2();
    public int mouseButton = -1;
    public final TestbedSettings settings;
    private long startTime;
    private long frameCount;
    private int targetFrameRate;
    private float frameRate = 0.0f;
    private boolean animating = false;
    private Graphics2D dbg = null;
    protected Image dbImage = null;
    private Thread animator;
    private int panelWidth;
    private int panelHeight;

    public TestPanel(TestbedSettings testbedSettings) {
        this.setBackground(Color.black);
        this.settings = testbedSettings;
        this.updateSize(600, 600);
        this.setFrameRate(60);
        this.animator = new Thread((Runnable)this, "Animation Thread");
    }

    public Graphics2D getDBGraphics() {
        return this.dbg;
    }

    public void updateSize(int n, int n2) {
        this.panelWidth = n;
        this.panelHeight = n2;
        this.draw.getViewportTranform().setExtents(n / 2, n2 / 2);
        this.setPreferredSize(new Dimension(this.panelWidth, this.panelHeight));
    }

    public void init() {
        this.grabFocus();
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                int n = keyEvent.getKeyCode();
                if (c != '\uffff') {
                    TestPanel.keys[c] = false;
                }
                TestPanel.codedKeys[n] = false;
            }

            public void keyPressed(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                int n = keyEvent.getKeyCode();
                if (c != '\uffff') {
                    TestPanel.keys[c] = true;
                }
                TestPanel.codedKeys[n] = true;
                if (c == ' ') {
                    TestPanel.this.currTest.lanchBomb();
                } else if (TestPanel.this.currTest != null) {
                    TestPanel.this.currTest.queueKeyPressed(c, n);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){
            private final Vec2 posDif = new Vec2();
            private final Vec2 pos = new Vec2();

            public void mouseDragged(MouseEvent mouseEvent) {
                if (TestPanel.this.mouseButton == 3) {
                    this.posDif.set(TestPanel.this.mouse);
                    TestPanel.this.mouse.set(mouseEvent.getX(), mouseEvent.getY());
                    this.posDif.subLocal(TestPanel.this.mouse);
                    TestPanel.this.draw.getViewportTranform().getScreenVectorToWorld(this.posDif, this.posDif);
                    TestPanel.this.draw.getViewportTranform().getCenter().addLocal(this.posDif);
                    if (TestPanel.this.currTest != null) {
                        ((TestPanel)TestPanel.this).currTest.cachedCameraX = TestPanel.this.draw.getViewportTranform().getCenter().x;
                        ((TestPanel)TestPanel.this).currTest.cachedCameraY = TestPanel.this.draw.getViewportTranform().getCenter().y;
                    }
                }
                if (TestPanel.this.currTest != null) {
                    this.pos.set(mouseEvent.getX(), mouseEvent.getY());
                    TestPanel.this.mouse.set(this.pos);
                    TestPanel.this.draw.getScreenToWorldToOut(this.pos, this.pos);
                    TestPanel.this.currTest.queueMouseMove(this.pos);
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (TestPanel.this.currTest != null) {
                    this.pos.set(mouseEvent.getX(), mouseEvent.getY());
                    TestPanel.this.mouse.set(this.pos);
                    TestPanel.this.draw.getScreenToWorldToOut(this.pos, this.pos);
                    TestPanel.this.currTest.queueMouseMove(this.pos);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){
            private final Vec2 pos = new Vec2();
            private final Vec2 pos2 = new Vec2();

            public void mouseReleased(MouseEvent mouseEvent) {
                if (TestPanel.this.currTest != null) {
                    this.pos.x = mouseEvent.getX();
                    this.pos.y = mouseEvent.getY();
                    TestPanel.this.mouse.set(this.pos);
                    TestPanel.this.draw.getScreenToWorldToOut(this.pos, this.pos);
                    TestPanel.this.currTest.queueMouseUp(this.pos);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                TestPanel.this.grabFocus();
                if (TestPanel.this.currTest != null) {
                    this.pos2.x = mouseEvent.getX();
                    this.pos2.y = mouseEvent.getY();
                    TestPanel.this.mouse.set(this.pos2);
                    TestPanel.this.mouseButton = mouseEvent.getButton();
                    if (mouseEvent.getButton() == 1) {
                        TestPanel.this.draw.getScreenToWorldToOut(this.pos2, this.pos2);
                        if (codedKeys[16]) {
                            TestPanel.this.currTest.queueShiftMouseDown(this.pos2);
                        } else {
                            TestPanel.this.currTest.queueMouseDown(this.pos2);
                        }
                    }
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){
            private final Vec2 oldCenter = new Vec2();
            private final Vec2 newCenter = new Vec2();
            private final Mat22 upScale = Mat22.createScaleTransform(1.05f);
            private final Mat22 downScale = Mat22.createScaleTransform(0.95f);

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                DebugDraw debugDraw = TestPanel.this.draw;
                int n = mouseWheelEvent.getWheelRotation();
                OBBViewportTransform oBBViewportTransform = (OBBViewportTransform)debugDraw.getViewportTranform();
                this.oldCenter.set(((TestPanel)TestPanel.this).currTest.m_mouseWorld);
                if (n < 0) {
                    oBBViewportTransform.mulByTransform(this.upScale);
                    ((TestPanel)TestPanel.this).currTest.cachedCameraScale = (float)((double)((TestPanel)TestPanel.this).currTest.cachedCameraScale * 1.05);
                } else if (n > 0) {
                    oBBViewportTransform.mulByTransform(this.downScale);
                    ((TestPanel)TestPanel.this).currTest.cachedCameraScale *= 0.95f;
                }
                debugDraw.getScreenToWorldToOut(TestPanel.this.mouse, this.newCenter);
                Vec2 vec2 = this.oldCenter.subLocal(this.newCenter);
                debugDraw.getViewportTranform().setCenter(debugDraw.getViewportTranform().getCenter().addLocal(vec2));
                ((TestPanel)TestPanel.this).currTest.cachedCameraX = debugDraw.getViewportTranform().getCenter().x;
                ((TestPanel)TestPanel.this).currTest.cachedCameraY = debugDraw.getViewportTranform().getCenter().y;
            }
        });
        this.addComponentListener(new ComponentListener(){

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                TestPanel.this.updateSize(TestPanel.this.getWidth(), TestPanel.this.getHeight());
                TestPanel.this.dbImage = null;
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        if (this.currTest != null) {
            this.currTest.init(this.draw);
        }
    }

    public void changeTest(TestbedTest testbedTest) {
        this.nextTest = testbedTest;
    }

    public void resetTest() {
        if (this.currTest != null) {
            this.currTest.init(this.draw);
        }
    }

    public void update() {
        if (this.currTest != null) {
            this.currTest.update(this.settings);
        }
    }

    public void setFrameRate(int n) {
        if (n == 0) {
            System.err.println("Animation: fps cannot be zero.  Setting looping to false");
        }
        if (n < 0) {
            System.err.println("Animation: fps cannot be negative.  Re-assigning fps to default 30 fps.");
            n = 30;
        }
        this.targetFrameRate = n;
        this.frameRate = n;
    }

    public int getFrameRate() {
        return this.targetFrameRate;
    }

    public float getCalculatedFrameRate() {
        return this.frameRate;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFrameCount() {
        return this.frameCount;
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void start() {
        if (!this.animating) {
            this.frameCount = 0L;
            this.animator.start();
        } else {
            System.err.println("\nAnimation is already animating.");
            System.err.println("\n");
        }
    }

    public void stop() {
        this.animating = false;
    }

    public void render() {
        if (this.dbImage == null) {
            if (this.panelWidth <= 0 || this.panelHeight <= 0) {
                return;
            }
            this.dbImage = this.createImage(this.panelWidth, this.panelHeight);
            if (this.dbImage == null) {
                System.err.println("dbImage is null");
                return;
            }
            this.dbg = (Graphics2D)this.dbImage.getGraphics();
        }
        this.dbg.setColor(Color.black);
        this.dbg.fillRect(0, 0, this.panelWidth, this.panelHeight);
    }

    public void paintScreen() {
        try {
            Graphics graphics = this.getGraphics();
            if (graphics != null && this.dbImage != null) {
                graphics.drawImage(this.dbImage, 0, 0, null);
                Toolkit.getDefaultToolkit().sync();
                graphics.dispose();
            }
        }
        catch (Exception exception) {
            System.err.println("Graphics context error: " + exception);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.start();
    }

    public void run() {
        long l;
        this.init();
        this.startTime = l = System.nanoTime();
        long l2 = l;
        long l3 = 0L;
        this.animating = true;
        while (this.animating) {
            long l4;
            if (this.nextTest != null) {
                this.currTest = this.nextTest;
                this.currTest.setPanel(this);
                this.currTest.init(this.draw);
                this.nextTest = null;
            }
            if ((l4 = l2 - l) > 0L) {
                float f = (float)l4 * 1.0f / 1.0E9f;
                l = System.nanoTime();
                this.frameRate = this.frameRate * 0.9f + 1.0f / f * 0.1f;
            } else {
                l = System.nanoTime();
            }
            this.render();
            this.update();
            this.paintScreen();
            ++this.frameCount;
            long l5 = System.nanoTime();
            long l6 = l5 - l2;
            l3 = ((long)(1000000000 / this.targetFrameRate) - l6) / 1000000L;
            if (l3 > 0L) {
                try {
                    Thread.sleep(l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            l2 = System.nanoTime();
        }
    }
}

