/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jbox2d.testbed.framework.TestbedMain;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.tests.TestList;

class SidePanel
extends JPanel
implements ActionListener,
ChangeListener {
    final TestbedSettings settings;
    TestbedMain main;
    private JSlider hz;
    private JLabel hzText;
    private JSlider pos;
    private JLabel posText;
    private JSlider vel;
    private JLabel velText;
    public JComboBox tests;
    private JButton pauseButton = new JButton("Pause");
    private JButton stepButton = new JButton("Step");
    private JButton resetButton = new JButton("Reset");
    private JButton quitButton = new JButton("Quit");
    static String[] checkboxLabels = new String[]{"Warm Starting", "Continuous Collision", "Draw Shapes", "Draw Joints", "Draw AABBs", "Draw Pairs", "Draw Contact Points", "Draw Contact Normals", "Draw Contact Forces", "Draw Friction Forces", "Draw Center of Mass", "Draw Stats", "Draw Help", "Draw Dynamic Tree"};

    public SidePanel(TestbedSettings testbedSettings) {
        this.settings = testbedSettings;
        this.initComponents();
        this.addListeners();
    }

    public void setMain(TestbedMain testbedMain) {
        this.main = testbedMain;
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(1), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        String[] stringArray = new String[TestList.tests.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = TestList.tests.get(i).getTestName();
        }
        this.tests = new JComboBox<String>(stringArray);
        this.tests.setMaximumSize(new Dimension(250, 20));
        this.tests.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(new JLabel("Choose a test:"));
        jPanel2.add(this.tests);
        jPanel.add(this.tests);
        this.hz = new JSlider(1, 400, (int)this.settings.hz);
        this.hz.setMaximumSize(new Dimension(200, 20));
        this.hz.addChangeListener(this);
        this.hzText = new JLabel("Hz: " + (int)this.settings.hz);
        jPanel.add(this.hzText);
        jPanel.add(this.hz);
        this.pos = new JSlider(0, 100, this.settings.positionIterations);
        this.pos.setMaximumSize(new Dimension(200, 20));
        this.pos.addChangeListener(this);
        this.posText = new JLabel("Pos iters: " + this.settings.positionIterations);
        jPanel.add(this.posText);
        jPanel.add(this.pos);
        this.vel = new JSlider(1, 100, this.settings.velocityIterations);
        this.vel.setMaximumSize(new Dimension(200, 20));
        this.vel.addChangeListener(this);
        this.velText = new JLabel("Vel iters: " + this.settings.velocityIterations);
        jPanel.add(this.velText);
        jPanel.add(this.vel);
        this.add((Component)jPanel, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(1), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        for (int i = 0; i < checkboxLabels.length; ++i) {
            String string = checkboxLabels[i];
            JCheckBox jCheckBox = new JCheckBox(string);
            jCheckBox.putClientProperty("index", i);
            boolean bl = false;
            switch (i) {
                case 0: {
                    bl = this.settings.enableWarmStarting;
                    break;
                }
                case 1: {
                    bl = this.settings.enableContinuous;
                    break;
                }
                case 2: {
                    bl = this.settings.drawShapes;
                    break;
                }
                case 3: {
                    bl = this.settings.drawJoints;
                    break;
                }
                case 4: {
                    bl = this.settings.drawAABBs;
                    break;
                }
                case 5: {
                    bl = this.settings.drawPairs;
                    break;
                }
                case 6: {
                    bl = this.settings.drawContactPoints;
                    break;
                }
                case 7: {
                    bl = this.settings.drawContactNormals;
                    break;
                }
                case 8: {
                    bl = this.settings.drawContactForces;
                    break;
                }
                case 9: {
                    bl = this.settings.drawFrictionForces;
                    break;
                }
                case 10: {
                    bl = this.settings.drawCOMs;
                    break;
                }
                case 11: {
                    bl = this.settings.drawStats;
                    break;
                }
                case 12: {
                    bl = this.settings.drawHelp;
                    break;
                }
                case 13: {
                    bl = this.settings.drawDynamicTree;
                    break;
                }
                default: {
                    System.out.println("oh no: " + i);
                    bl = false;
                }
            }
            jCheckBox.setSelected(bl);
            jCheckBox.addChangeListener(this);
            jPanel3.add(jCheckBox);
        }
        this.add((Component)jPanel3, "Center");
        Box box = Box.createHorizontalBox();
        box.add(this.pauseButton);
        box.add(this.stepButton);
        box.add(this.resetButton);
        box.add(this.quitButton);
        this.add((Component)box, "South");
    }

    public void addListeners() {
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SidePanel.this.settings.pause) {
                    SidePanel.this.settings.pause = false;
                    SidePanel.this.pauseButton.setText("Pause");
                } else {
                    SidePanel.this.settings.pause = true;
                    SidePanel.this.pauseButton.setText("Resume");
                }
            }
        });
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SidePanel.this.settings.singleStep = true;
                if (!SidePanel.this.settings.pause) {
                    SidePanel.this.settings.pause = true;
                    SidePanel.this.pauseButton.setText("Resume");
                }
            }
        });
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SidePanel.this.main.resetTest();
            }
        });
        this.quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)changeEvent.getSource();
            int n = (Integer)jCheckBox.getClientProperty("index");
            boolean bl = jCheckBox.isSelected();
            switch (n) {
                case 0: {
                    this.settings.enableWarmStarting = bl;
                    break;
                }
                case 1: {
                    this.settings.enableContinuous = bl;
                    break;
                }
                case 2: {
                    this.settings.drawShapes = bl;
                    break;
                }
                case 3: {
                    this.settings.drawJoints = bl;
                    break;
                }
                case 4: {
                    this.settings.drawAABBs = bl;
                    break;
                }
                case 5: {
                    this.settings.drawPairs = bl;
                    break;
                }
                case 6: {
                    this.settings.drawContactPoints = bl;
                    break;
                }
                case 7: {
                    this.settings.drawContactNormals = bl;
                    break;
                }
                case 8: {
                    this.settings.drawContactForces = bl;
                    break;
                }
                case 9: {
                    this.settings.drawFrictionForces = bl;
                    break;
                }
                case 10: {
                    this.settings.drawCOMs = bl;
                    break;
                }
                case 11: {
                    this.settings.drawStats = bl;
                    break;
                }
                case 12: {
                    this.settings.drawHelp = bl;
                    break;
                }
                case 13: {
                    this.settings.drawDynamicTree = bl;
                    break;
                }
                default: {
                    System.out.println("oh no: " + n);
                    break;
                }
            }
        } else if (changeEvent.getSource() instanceof JSlider) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider == this.hz) {
                this.settings.hz = jSlider.getValue();
                this.hzText.setText("Hz: " + jSlider.getValue());
            } else if (jSlider == this.pos) {
                this.settings.positionIterations = jSlider.getValue();
                this.posText.setText("Pos iters: " + jSlider.getValue());
            } else if (jSlider == this.vel) {
                this.settings.velocityIterations = jSlider.getValue();
                this.velText.setText("Vel iters: " + jSlider.getValue());
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.main.testChanged(this.tests.getSelectedIndex());
    }
}

