/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Mat33;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.WeldJointDef;
import org.jbox2d.pooling.IWorldPool;

public class WeldJoint
extends Joint {
    private final Vec2 m_localAnchorA;
    private final Vec2 m_localAnchorB;
    private float m_referenceAngle;
    private final Vec3 m_impulse;
    private final Mat33 m_mass;

    protected WeldJoint(IWorldPool iWorldPool, WeldJointDef weldJointDef) {
        super(iWorldPool, weldJointDef);
        this.m_localAnchorA = new Vec2(weldJointDef.localAnchorA);
        this.m_localAnchorB = new Vec2(weldJointDef.localAnchorB);
        this.m_referenceAngle = weldJointDef.referenceAngle;
        this.m_impulse = new Vec3();
        this.m_impulse.setZero();
        this.m_mass = new Mat33();
    }

    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
    }

    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_impulse.x, this.m_impulse.y);
        vec2.mulLocal(f);
    }

    public float getReactionTorque(float f) {
        return f * this.m_impulse.z;
    }

    public void initVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        vec2.set(this.m_localAnchorA).subLocal(body.getLocalCenter());
        vec22.set(this.m_localAnchorB).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec2);
        Mat22.mulToOut(body2.getTransform().R, vec22, vec22);
        float f = body.m_invMass;
        float f2 = body2.m_invMass;
        float f3 = body.m_invI;
        float f4 = body2.m_invI;
        this.m_mass.col1.x = f + f2 + vec2.y * vec2.y * f3 + vec22.y * vec22.y * f4;
        this.m_mass.col2.x = -vec2.y * vec2.x * f3 - vec22.y * vec22.x * f4;
        this.m_mass.col3.x = -vec2.y * f3 - vec22.y * f4;
        this.m_mass.col1.y = this.m_mass.col2.x;
        this.m_mass.col2.y = f + f2 + vec2.x * vec2.x * f3 + vec22.x * vec22.x * f4;
        this.m_mass.col3.y = vec2.x * f3 + vec22.x * f4;
        this.m_mass.col1.z = this.m_mass.col3.x;
        this.m_mass.col2.z = this.m_mass.col3.y;
        this.m_mass.col3.z = f3 + f4;
        if (timeStep.warmStarting) {
            this.m_impulse.mulLocal(timeStep.dtRatio);
            Vec2 vec23 = this.pool.popVec2();
            Vec2 vec24 = this.pool.popVec2();
            vec23.set(this.m_impulse.x, this.m_impulse.y);
            vec24.set(vec23).mulLocal(f);
            body.m_linearVelocity.subLocal(vec24);
            body.m_angularVelocity -= f3 * (Vec2.cross(vec2, vec23) + this.m_impulse.z);
            vec24.set(vec23).mulLocal(f2);
            body2.m_linearVelocity.addLocal(vec24);
            body2.m_angularVelocity += f4 * (Vec2.cross(vec22, vec23) + this.m_impulse.z);
            this.pool.pushVec2(2);
        } else {
            this.m_impulse.setZero();
        }
        this.pool.pushVec2(2);
    }

    public void solveVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = body.m_linearVelocity;
        float f = body.m_angularVelocity;
        Vec2 vec22 = body2.m_linearVelocity;
        float f2 = body2.m_angularVelocity;
        float f3 = body.m_invMass;
        float f4 = body2.m_invMass;
        float f5 = body.m_invI;
        float f6 = body2.m_invI;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        vec23.set(this.m_localAnchorA).subLocal(body.getLocalCenter());
        vec24.set(this.m_localAnchorB).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec23, vec23);
        Mat22.mulToOut(body2.getTransform().R, vec24, vec24);
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        Vec2.crossToOut(f, vec23, vec26);
        Vec2.crossToOut(f2, vec24, vec25);
        vec25.addLocal(vec22).subLocal(vec2).subLocal(vec26);
        float f7 = f2 - f;
        Vec3 vec3 = this.pool.popVec3();
        vec3.set(vec25.x, vec25.y, f7);
        Vec3 vec32 = this.pool.popVec3();
        this.m_mass.solve33ToOut(vec3.negateLocal(), vec32);
        this.m_impulse.addLocal(vec32);
        Vec2 vec27 = this.pool.popVec2();
        vec27.set(vec32.x, vec32.y);
        vec26.set(vec27).mulLocal(f3);
        vec2.subLocal(vec26);
        f -= f5 * (Vec2.cross(vec23, vec27) + vec32.z);
        vec26.set(vec27).mulLocal(f4);
        vec22.addLocal(vec26);
        f2 += f6 * (Vec2.cross(vec24, vec27) + vec32.z);
        body.m_linearVelocity.set(vec2);
        body.m_angularVelocity = f;
        body2.m_linearVelocity.set(vec22);
        body2.m_angularVelocity = f2;
        this.pool.pushVec2(5);
        this.pool.pushVec3(2);
    }

    public boolean solvePositionConstraints(float f) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        float f2 = body.m_invMass;
        float f3 = body2.m_invMass;
        float f4 = body.m_invI;
        float f5 = body2.m_invI;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        vec2.set(this.m_localAnchorA).subLocal(body.getLocalCenter());
        vec22.set(this.m_localAnchorB).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec2);
        Mat22.mulToOut(body2.getTransform().R, vec22, vec22);
        Vec2 vec23 = this.pool.popVec2();
        vec23.set(body2.m_sweep.c).addLocal(vec22).subLocal(body.m_sweep.c).subLocal(vec2);
        float f6 = body2.m_sweep.a - body.m_sweep.a - this.m_referenceAngle;
        float f7 = 10.0f * Settings.linearSlop;
        float f8 = vec23.length();
        float f9 = MathUtils.abs(f6);
        if (f8 > f7) {
            f4 *= 1.0f;
            f5 *= 1.0f;
        }
        this.m_mass.col1.x = f2 + f3 + vec2.y * vec2.y * f4 + vec22.y * vec22.y * f5;
        this.m_mass.col2.x = -vec2.y * vec2.x * f4 - vec22.y * vec22.x * f5;
        this.m_mass.col3.x = -vec2.y * f4 - vec22.y * f5;
        this.m_mass.col1.y = this.m_mass.col2.x;
        this.m_mass.col2.y = f2 + f3 + vec2.x * vec2.x * f4 + vec22.x * vec22.x * f5;
        this.m_mass.col3.y = vec2.x * f4 + vec22.x * f5;
        this.m_mass.col1.z = this.m_mass.col3.x;
        this.m_mass.col2.z = this.m_mass.col3.y;
        this.m_mass.col3.z = f4 + f5;
        Vec3 vec3 = this.pool.popVec3();
        Vec3 vec32 = this.pool.popVec3();
        vec3.set(vec23.x, vec23.y, f6);
        this.m_mass.solve33ToOut(vec3.negateLocal(), vec32);
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        vec24.set(vec32.x, vec32.y);
        vec25.set(vec24).mulLocal(f2);
        body.m_sweep.c.subLocal(vec25);
        body.m_sweep.a -= f4 * (Vec2.cross(vec2, vec24) + vec32.z);
        vec25.set(vec24).mulLocal(f3);
        body2.m_sweep.c.addLocal(vec25);
        body2.m_sweep.a += f5 * (Vec2.cross(vec22, vec24) + vec32.z);
        body.synchronizeTransform();
        body2.synchronizeTransform();
        this.pool.pushVec2(5);
        this.pool.pushVec3(2);
        return f8 <= Settings.linearSlop && f9 <= Settings.angularSlop;
    }
}

