/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import java.io.Serializable;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Mat33;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.pooling.IWorldPool;

public class PrismaticJoint
extends Joint {
    public final Vec2 m_localAnchor1;
    public final Vec2 m_localAnchor2;
    public final Vec2 m_localXAxis1;
    public final Vec2 m_localYAxis1;
    public float m_refAngle;
    public final Vec2 m_axis;
    public final Vec2 m_perp;
    public float m_s1;
    public float m_s2;
    public float m_a1;
    public float m_a2;
    public final Mat33 m_K;
    public final Vec3 m_impulse;
    public float m_motorMass;
    public float m_motorImpulse;
    public float m_lowerTranslation;
    public float m_upperTranslation;
    public float m_maxMotorForce;
    public float m_motorSpeed;
    public boolean m_enableLimit;
    public boolean m_enableMotor;
    public LimitState m_limitState;

    public PrismaticJoint(IWorldPool iWorldPool, PrismaticJointDef prismaticJointDef) {
        super(iWorldPool, prismaticJointDef);
        this.m_localAnchor1 = new Vec2(prismaticJointDef.localAnchorA);
        this.m_localAnchor2 = new Vec2(prismaticJointDef.localAnchorB);
        this.m_localXAxis1 = new Vec2(prismaticJointDef.localAxis1);
        this.m_localYAxis1 = new Vec2();
        Vec2.crossToOut(1.0f, this.m_localXAxis1, this.m_localYAxis1);
        this.m_refAngle = prismaticJointDef.referenceAngle;
        this.m_impulse = new Vec3();
        this.m_motorMass = 0.0f;
        this.m_motorImpulse = 0.0f;
        this.m_lowerTranslation = prismaticJointDef.lowerTranslation;
        this.m_upperTranslation = prismaticJointDef.upperTranslation;
        this.m_maxMotorForce = prismaticJointDef.maxMotorForce;
        this.m_motorSpeed = prismaticJointDef.motorSpeed;
        this.m_enableLimit = prismaticJointDef.enableLimit;
        this.m_enableMotor = prismaticJointDef.enableMotor;
        this.m_limitState = LimitState.INACTIVE;
        this.m_K = new Mat33();
        this.m_axis = new Vec2();
        this.m_perp = new Vec2();
    }

    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, vec2);
    }

    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, vec2);
    }

    public void getReactionForce(float f, Vec2 vec2) {
        Vec2 vec22 = this.pool.popVec2();
        vec22.set(this.m_axis).mulLocal(this.m_motorImpulse + this.m_impulse.z);
        vec2.set(this.m_perp).mulLocal(this.m_impulse.x).addLocal(vec22).mulLocal(f);
        this.pool.pushVec2(1);
    }

    public float getReactionTorque(float f) {
        return f * this.m_impulse.y;
    }

    public float getJointTranslation() {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        body.getWorldPointToOut(this.m_localAnchor1, vec2);
        body2.getWorldPointToOut(this.m_localAnchor2, vec22);
        vec22.subLocal(vec2);
        body.getWorldVectorToOut(this.m_localXAxis1, vec23);
        float f = Vec2.dot(vec22, vec23);
        this.pool.pushVec2(3);
        return f;
    }

    public float getJointSpeed() {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2[] vec2Array = this.pool.popVec2(9);
        Vec2 vec2 = vec2Array[0];
        Vec2 vec22 = vec2Array[1];
        Vec2 vec23 = vec2Array[2];
        Vec2 vec24 = vec2Array[3];
        Vec2 vec25 = vec2Array[4];
        Vec2 vec26 = vec2Array[5];
        Vec2 vec27 = vec2Array[6];
        Vec2 vec28 = vec2Array[7];
        Vec2 vec29 = vec2Array[8];
        vec2.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec22);
        vec2.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body2.getTransform().R, vec2, vec23);
        vec24.set(body.m_sweep.c).addLocal(vec22);
        vec25.set(body2.m_sweep.c).addLocal(vec23);
        vec26.set(vec25).subLocal(vec24);
        body.getWorldVectorToOut(this.m_localXAxis1, vec27);
        Vec2 vec210 = body.m_linearVelocity;
        Vec2 vec211 = body2.m_linearVelocity;
        float f = body.m_angularVelocity;
        float f2 = body2.m_angularVelocity;
        Vec2.crossToOut(f, vec27, vec2);
        Vec2.crossToOut(f2, vec23, vec28);
        Vec2.crossToOut(f, vec22, vec29);
        vec28.addLocal(vec211).subLocal(vec210).subLocal(vec29);
        float f3 = Vec2.dot(vec26, vec2) + Vec2.dot(vec27, vec28);
        this.pool.pushVec2(9);
        return f3;
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void enableLimit(boolean bl) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableLimit = bl;
    }

    public float getLowerLimit() {
        return this.m_lowerTranslation;
    }

    public float getUpperLimit() {
        return this.m_upperTranslation;
    }

    public void setLimits(float f, float f2) {
        assert (f <= f2);
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_lowerTranslation = f;
        this.m_upperTranslation = f2;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean bl) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableMotor = bl;
    }

    public void setMotorSpeed(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_motorSpeed = f;
    }

    public float getMotorSpeed() {
        return this.m_motorSpeed;
    }

    public void setMaxMotorForce(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_maxMotorForce = f;
    }

    public float getMotorForce() {
        return this.m_motorImpulse;
    }

    public void initVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        this.m_localCenterA.set(body.getLocalCenter());
        this.m_localCenterB.set(body2.getLocalCenter());
        Transform transform = body.getTransform();
        Transform transform2 = body2.getTransform();
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        vec22.set(this.m_localAnchor1).subLocal(this.m_localCenterA);
        vec23.set(this.m_localAnchor2).subLocal(this.m_localCenterB);
        Mat22.mulToOut(transform.R, vec22, vec22);
        Mat22.mulToOut(transform2.R, vec23, vec23);
        vec24.set(body2.m_sweep.c).addLocal(vec23).subLocal(body.m_sweep.c).subLocal(vec22);
        this.m_invMassA = body.m_invMass;
        this.m_invIA = body.m_invI;
        this.m_invMassB = body2.m_invMass;
        this.m_invIB = body2.m_invI;
        Mat22.mulToOut(transform.R, this.m_localXAxis1, this.m_axis);
        vec2.set(vec24).addLocal(vec22);
        this.m_a1 = Vec2.cross(vec2, this.m_axis);
        this.m_a2 = Vec2.cross(vec23, this.m_axis);
        this.m_motorMass = this.m_invMassA + this.m_invMassB + this.m_invIA * this.m_a1 * this.m_a1 + this.m_invIB * this.m_a2 * this.m_a2;
        if (this.m_motorMass > 1.1920929E-7f) {
            this.m_motorMass = 1.0f / this.m_motorMass;
        }
        Mat22.mulToOut(transform.R, this.m_localYAxis1, this.m_perp);
        vec2.set(vec24).addLocal(vec22);
        this.m_s1 = Vec2.cross(vec2, this.m_perp);
        this.m_s2 = Vec2.cross(vec23, this.m_perp);
        float f = this.m_invMassA;
        float f2 = this.m_invMassB;
        float f3 = this.m_invIA;
        float f4 = this.m_invIB;
        float f5 = f + f2 + f3 * this.m_s1 * this.m_s1 + f4 * this.m_s2 * this.m_s2;
        float f6 = f3 * this.m_s1 + f4 * this.m_s2;
        float f7 = f3 * this.m_s1 * this.m_a1 + f4 * this.m_s2 * this.m_a2;
        float f8 = f3 + f4;
        float f9 = f3 * this.m_a1 + f4 * this.m_a2;
        float f10 = f + f2 + f3 * this.m_a1 * this.m_a1 + f4 * this.m_a2 * this.m_a2;
        this.m_K.col1.set(f5, f6, f7);
        this.m_K.col2.set(f6, f8, f9);
        this.m_K.col3.set(f7, f9, f10);
        if (this.m_enableLimit) {
            f = Vec2.dot(this.m_axis, vec24);
            if (MathUtils.abs(this.m_upperTranslation - this.m_lowerTranslation) < 2.0f * Settings.linearSlop) {
                this.m_limitState = LimitState.EQUAL;
            } else if (f <= this.m_lowerTranslation) {
                if (this.m_limitState != LimitState.AT_LOWER) {
                    this.m_limitState = LimitState.AT_LOWER;
                    this.m_impulse.z = 0.0f;
                }
            } else if (f >= this.m_upperTranslation) {
                if (this.m_limitState != LimitState.AT_UPPER) {
                    this.m_limitState = LimitState.AT_UPPER;
                    this.m_impulse.z = 0.0f;
                }
            } else {
                this.m_limitState = LimitState.INACTIVE;
                this.m_impulse.z = 0.0f;
            }
        } else {
            this.m_limitState = LimitState.INACTIVE;
            this.m_impulse.z = 0.0f;
        }
        if (!this.m_enableMotor) {
            this.m_motorImpulse = 0.0f;
        }
        if (timeStep.warmStarting) {
            this.m_impulse.mulLocal(timeStep.dtRatio);
            this.m_motorImpulse *= timeStep.dtRatio;
            Vec2 vec25 = this.pool.popVec2();
            vec2.set(this.m_axis).mulLocal(this.m_motorImpulse + this.m_impulse.z);
            vec25.set(this.m_perp).mulLocal(this.m_impulse.x).addLocal(vec2);
            f2 = this.m_impulse.x * this.m_s1 + this.m_impulse.y + (this.m_motorImpulse + this.m_impulse.z) * this.m_a1;
            f3 = this.m_impulse.x * this.m_s2 + this.m_impulse.y + (this.m_motorImpulse + this.m_impulse.z) * this.m_a2;
            vec2.set(vec25).mulLocal(this.m_invMassA);
            body.m_linearVelocity.subLocal(vec2);
            body.m_angularVelocity -= this.m_invIA * f2;
            vec2.set(vec25).mulLocal(this.m_invMassB);
            body2.m_linearVelocity.addLocal(vec2);
            body2.m_angularVelocity += this.m_invIB * f3;
            this.pool.pushVec2(1);
        } else {
            this.m_impulse.setZero();
            this.m_motorImpulse = 0.0f;
        }
        this.pool.pushVec2(4);
    }

    public boolean solvePositionConstraints(float f) {
        float f2;
        float f3;
        float f4;
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = body.m_sweep.c;
        float f5 = body.m_sweep.a;
        Vec2 vec22 = body2.m_sweep.c;
        float f6 = body2.m_sweep.a;
        float f7 = 0.0f;
        float f8 = 0.0f;
        boolean bl = false;
        float f9 = 0.0f;
        Mat22 mat22 = this.pool.popMat22();
        Mat22 mat222 = this.pool.popMat22();
        mat22.set(f5);
        mat222.set(f6);
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        vec24.set(this.m_localAnchor1).subLocal(this.m_localCenterA);
        vec25.set(this.m_localAnchor2).subLocal(this.m_localCenterB);
        Mat22.mulToOut(mat22, vec24, vec24);
        Mat22.mulToOut(mat222, vec25, vec25);
        vec26.set(vec22).addLocal(vec25).subLocal(vec2).subLocal(vec24);
        if (this.m_enableLimit) {
            Mat22.mulToOut(mat22, this.m_localXAxis1, this.m_axis);
            vec23.set(vec26).addLocal(vec24);
            this.m_a1 = Vec2.cross(vec23, this.m_axis);
            this.m_a2 = Vec2.cross(vec25, this.m_axis);
            float f10 = Vec2.dot(this.m_axis, vec26);
            if (MathUtils.abs(this.m_upperTranslation - this.m_lowerTranslation) < 2.0f * Settings.linearSlop) {
                f9 = MathUtils.clamp(f10, -Settings.maxLinearCorrection, Settings.maxLinearCorrection);
                f7 = MathUtils.abs(f10);
                bl = true;
            } else if (f10 <= this.m_lowerTranslation) {
                f9 = MathUtils.clamp(f10 - this.m_lowerTranslation + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
                f7 = this.m_lowerTranslation - f10;
                bl = true;
            } else if (f10 >= this.m_upperTranslation) {
                f9 = MathUtils.clamp(f10 - this.m_upperTranslation - Settings.linearSlop, 0.0f, Settings.maxLinearCorrection);
                f7 = f10 - this.m_upperTranslation;
                bl = true;
            }
        }
        Mat22.mulToOut(mat22, this.m_localYAxis1, this.m_perp);
        vec23.set(vec26).addLocal(vec24);
        this.m_s1 = Vec2.cross(vec23, this.m_perp);
        this.m_s2 = Vec2.cross(vec25, this.m_perp);
        Vec3 vec3 = this.pool.popVec3();
        Vec2 vec27 = this.pool.popVec2();
        vec27.x = Vec2.dot(this.m_perp, vec26);
        vec27.y = f6 - f5 - this.m_refAngle;
        f7 = MathUtils.max(f7, MathUtils.abs(vec27.x));
        f8 = MathUtils.abs(vec27.y);
        if (bl) {
            f4 = this.m_invMassA;
            f3 = this.m_invMassB;
            f2 = this.m_invIA;
            float f11 = this.m_invIB;
            float f12 = f4 + f3 + f2 * this.m_s1 * this.m_s1 + f11 * this.m_s2 * this.m_s2;
            float f13 = f2 * this.m_s1 + f11 * this.m_s2;
            float f14 = f2 * this.m_s1 * this.m_a1 + f11 * this.m_s2 * this.m_a2;
            float f15 = f2 + f11;
            float f16 = f2 * this.m_a1 + f11 * this.m_a2;
            float f17 = f4 + f3 + f2 * this.m_a1 * this.m_a1 + f11 * this.m_a2 * this.m_a2;
            this.m_K.col1.set(f12, f13, f14);
            this.m_K.col2.set(f13, f15, f16);
            this.m_K.col3.set(f14, f16, f17);
            Vec3 vec32 = this.pool.popVec3();
            vec32.x = vec27.x;
            vec32.y = vec27.y;
            vec32.z = f9;
            this.m_K.solve33ToOut(vec32.negateLocal(), vec3);
            this.pool.pushVec3(1);
        } else {
            f4 = this.m_invMassA;
            f3 = this.m_invMassB;
            f2 = this.m_invIA;
            float f18 = this.m_invIB;
            float f19 = f4 + f3 + f2 * this.m_s1 * this.m_s1 + f18 * this.m_s2 * this.m_s2;
            float f20 = f2 * this.m_s1 + f18 * this.m_s2;
            float f21 = f2 + f18;
            this.m_K.col1.set(f19, f20, 0.0f);
            this.m_K.col2.set(f20, f21, 0.0f);
            this.m_K.solve22ToOut(vec27.negateLocal(), vec23);
            vec27.negateLocal();
            vec3.x = vec23.x;
            vec3.y = vec23.y;
            vec3.z = 0.0f;
        }
        Vec2 vec28 = this.pool.popVec2();
        vec23.set(this.m_perp).mulLocal(vec3.x);
        vec28.set(this.m_axis).mulLocal(vec3.z).addLocal(vec23);
        f3 = vec3.x * this.m_s1 + vec3.y + vec3.z * this.m_a1;
        f2 = vec3.x * this.m_s2 + vec3.y + vec3.z * this.m_a2;
        vec23.set(vec28).mulLocal(this.m_invMassA);
        vec2.subLocal(vec23);
        f5 -= this.m_invIA * f3;
        vec23.set(vec28).mulLocal(this.m_invMassB);
        vec22.addLocal(vec23);
        f6 += this.m_invIB * f2;
        body.m_sweep.c.set(vec2);
        body.m_sweep.a = f5;
        body2.m_sweep.c.set(vec22);
        body2.m_sweep.a = f6;
        body.synchronizeTransform();
        body2.synchronizeTransform();
        this.pool.pushVec2(6);
        this.pool.pushVec3(1);
        this.pool.pushMat22(2);
        return f7 <= Settings.linearSlop && f8 <= Settings.angularSlop;
    }

    public void solveVelocityConstraints(TimeStep timeStep) {
        Serializable serializable;
        float f;
        float f2;
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = body.m_linearVelocity;
        float f3 = body.m_angularVelocity;
        Vec2 vec22 = body2.m_linearVelocity;
        float f4 = body2.m_angularVelocity;
        Vec2 vec23 = this.pool.popVec2();
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL) {
            vec23.set(vec22).subLocal(vec2);
            float f5 = Vec2.dot(this.m_axis, vec23) + this.m_a2 * f4 - this.m_a1 * f3;
            f2 = this.m_motorMass * (this.m_motorSpeed - f5);
            float f6 = this.m_motorImpulse;
            f = timeStep.dt * this.m_maxMotorForce;
            this.m_motorImpulse = MathUtils.clamp(this.m_motorImpulse + f2, -f, f);
            f2 = this.m_motorImpulse - f6;
            serializable = this.pool.popVec2();
            ((Vec2)serializable).set(this.m_axis).mulLocal(f2);
            float f7 = f2 * this.m_a1;
            float f8 = f2 * this.m_a2;
            vec23.set((Vec2)serializable).mulLocal(this.m_invMassA);
            vec2.subLocal(vec23);
            f3 -= this.m_invIA * f7;
            vec23.set((Vec2)serializable).mulLocal(this.m_invMassB);
            vec22.addLocal(vec23);
            f4 += this.m_invIB * f8;
            this.pool.pushVec2(1);
        }
        Vec2 vec24 = this.pool.popVec2();
        vec23.set(vec22).subLocal(vec2);
        vec24.x = Vec2.dot(this.m_perp, vec23) + this.m_s2 * f4 - this.m_s1 * f3;
        vec24.y = f4 - f3;
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE) {
            vec23.set(vec22).subLocal(vec2);
            f2 = Vec2.dot(this.m_axis, vec23) + this.m_a2 * f4 - this.m_a1 * f3;
            Vec3 vec3 = this.pool.popVec3();
            vec3.set(vec24.x, vec24.y, f2);
            vec3.negateLocal();
            Vec3 vec32 = this.pool.popVec3();
            vec32.set(this.m_impulse);
            serializable = this.pool.popVec3();
            this.m_K.solve33ToOut(vec3, (Vec3)serializable);
            this.m_impulse.addLocal((Vec3)serializable);
            if (this.m_limitState == LimitState.AT_LOWER) {
                this.m_impulse.z = MathUtils.max(this.m_impulse.z, 0.0f);
            } else if (this.m_limitState == LimitState.AT_UPPER) {
                this.m_impulse.z = MathUtils.min(this.m_impulse.z, 0.0f);
            }
            Vec2 vec25 = this.pool.popVec2();
            Vec2 vec26 = this.pool.popVec2();
            vec23.set(this.m_K.col3.x, this.m_K.col3.y).mulLocal(this.m_impulse.z - vec32.z);
            vec25.set(vec24).negateLocal().subLocal(vec23);
            vec23.set(vec32.x, vec32.y);
            this.m_K.solve22ToOut(vec25, vec26);
            vec26.addLocal(vec23);
            this.m_impulse.x = vec26.x;
            this.m_impulse.y = vec26.y;
            ((Vec3)serializable).set(this.m_impulse).subLocal(vec32);
            Vec2 vec27 = this.pool.popVec2();
            vec23.set(this.m_axis).mulLocal(((Vec3)serializable).z);
            vec27.set(this.m_perp).mulLocal(((Vec3)serializable).x).addLocal(vec23);
            float f9 = ((Vec3)serializable).x * this.m_s1 + ((Vec3)serializable).y + ((Vec3)serializable).z * this.m_a1;
            float f10 = ((Vec3)serializable).x * this.m_s2 + ((Vec3)serializable).y + ((Vec3)serializable).z * this.m_a2;
            vec23.set(vec27).mulLocal(this.m_invMassA);
            vec2.subLocal(vec23);
            f3 -= this.m_invIA * f9;
            vec23.set(vec27).mulLocal(this.m_invMassB);
            vec22.addLocal(vec23);
            f4 += this.m_invIB * f10;
            this.pool.pushVec2(3);
            this.pool.pushVec3(3);
        } else {
            Vec2 vec28 = this.pool.popVec2();
            this.m_K.solve22ToOut(vec24.negateLocal(), vec28);
            vec24.negateLocal();
            this.m_impulse.x += vec28.x;
            this.m_impulse.y += vec28.y;
            Vec2 vec29 = this.pool.popVec2();
            vec29.set(this.m_perp).mulLocal(vec28.x);
            f = vec28.x * this.m_s1 + vec28.y;
            float f11 = vec28.x * this.m_s2 + vec28.y;
            vec23.set(vec29).mulLocal(this.m_invMassA);
            vec2.subLocal(vec23);
            f3 -= this.m_invIA * f;
            vec23.set(vec29).mulLocal(this.m_invMassB);
            vec22.addLocal(vec23);
            f4 += this.m_invIB * f11;
            this.pool.pushVec2(2);
        }
        body.m_linearVelocity.set(vec2);
        body.m_angularVelocity = f3;
        body2.m_linearVelocity.set(vec22);
        body2.m_angularVelocity = f4;
        this.pool.pushVec2(2);
    }
}

