/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.ConstantVolumeJoint;
import org.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.FrictionJoint;
import org.jbox2d.dynamics.joints.FrictionJointDef;
import org.jbox2d.dynamics.joints.GearJoint;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointEdge;
import org.jbox2d.dynamics.joints.JointType;
import org.jbox2d.dynamics.joints.LineJoint;
import org.jbox2d.dynamics.joints.LineJointDef;
import org.jbox2d.dynamics.joints.MouseJoint;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.dynamics.joints.WeldJoint;
import org.jbox2d.dynamics.joints.WeldJointDef;
import org.jbox2d.pooling.IWorldPool;

public abstract class Joint {
    public JointType m_type;
    public Joint m_prev;
    public Joint m_next;
    public JointEdge m_edgeA;
    public JointEdge m_edgeB;
    public Body m_bodyA;
    public Body m_bodyB;
    public boolean m_islandFlag;
    public boolean m_collideConnected;
    public Object m_userData;
    protected IWorldPool pool;
    public final Vec2 m_localCenterA;
    public final Vec2 m_localCenterB;
    float m_invMassA;
    float m_invIA;
    float m_invMassB;
    float m_invIB;

    public static Joint create(World world, JointDef jointDef) {
        switch (jointDef.type) {
            case MOUSE: {
                return new MouseJoint(world.getPool(), (MouseJointDef)jointDef);
            }
            case DISTANCE: {
                return new DistanceJoint(world.getPool(), (DistanceJointDef)jointDef);
            }
            case PRISMATIC: {
                return new PrismaticJoint(world.getPool(), (PrismaticJointDef)jointDef);
            }
            case REVOLUTE: {
                return new RevoluteJoint(world.getPool(), (RevoluteJointDef)jointDef);
            }
            case WELD: {
                return new WeldJoint(world.getPool(), (WeldJointDef)jointDef);
            }
            case FRICTION: {
                return new FrictionJoint(world.getPool(), (FrictionJointDef)jointDef);
            }
            case LINE: {
                return new LineJoint(world.getPool(), (LineJointDef)jointDef);
            }
            case GEAR: {
                return new GearJoint(world.getPool(), (GearJointDef)jointDef);
            }
            case PULLEY: {
                return new PulleyJoint(world.getPool(), (PulleyJointDef)jointDef);
            }
            case CONSTANT_VOLUME: {
                return new ConstantVolumeJoint(world, (ConstantVolumeJointDef)jointDef);
            }
        }
        return null;
    }

    public static void destroy(Joint joint) {
        joint.destructor();
    }

    protected Joint(IWorldPool iWorldPool, JointDef jointDef) {
        assert (jointDef.bodyA != jointDef.bodyB);
        this.pool = iWorldPool;
        this.m_type = jointDef.type;
        this.m_prev = null;
        this.m_next = null;
        this.m_bodyA = jointDef.bodyA;
        this.m_bodyB = jointDef.bodyB;
        this.m_collideConnected = jointDef.collideConnected;
        this.m_islandFlag = false;
        this.m_userData = jointDef.userData;
        this.m_edgeA = new JointEdge();
        this.m_edgeA.joint = null;
        this.m_edgeA.other = null;
        this.m_edgeA.prev = null;
        this.m_edgeA.next = null;
        this.m_edgeB = new JointEdge();
        this.m_edgeB.joint = null;
        this.m_edgeB.other = null;
        this.m_edgeB.prev = null;
        this.m_edgeB.next = null;
        this.m_localCenterA = new Vec2();
        this.m_localCenterB = new Vec2();
    }

    public JointType getType() {
        return this.m_type;
    }

    public Body getBodyA() {
        return this.m_bodyA;
    }

    public Body getBodyB() {
        return this.m_bodyB;
    }

    public abstract void getAnchorA(Vec2 var1);

    public abstract void getAnchorB(Vec2 var1);

    public abstract void getReactionForce(float var1, Vec2 var2);

    public abstract float getReactionTorque(float var1);

    public Joint getNext() {
        return this.m_next;
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void setUserData(Object object) {
        this.m_userData = object;
    }

    public boolean IsActive() {
        return this.m_bodyA.isActive() && this.m_bodyB.isActive();
    }

    public abstract void initVelocityConstraints(TimeStep var1);

    public abstract void solveVelocityConstraints(TimeStep var1);

    public abstract boolean solvePositionConstraints(float var1);

    public void destructor() {
    }
}

