/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.pooling.IWorldPool;

public class DistanceJoint
extends Joint {
    public final Vec2 m_localAnchor1;
    public final Vec2 m_localAnchor2;
    public final Vec2 m_u;
    public float m_impulse;
    public float m_mass;
    public float m_length;
    public float m_frequencyHz;
    public float m_dampingRatio;
    public float m_gamma;
    public float m_bias;

    public DistanceJoint(IWorldPool iWorldPool, DistanceJointDef distanceJointDef) {
        super(iWorldPool, distanceJointDef);
        this.m_localAnchor1 = distanceJointDef.localAnchorA.clone();
        this.m_localAnchor2 = distanceJointDef.localAnchorB.clone();
        this.m_length = distanceJointDef.length;
        this.m_impulse = 0.0f;
        this.m_u = new Vec2();
        this.m_frequencyHz = distanceJointDef.frequencyHz;
        this.m_dampingRatio = distanceJointDef.dampingRatio;
        this.m_gamma = 0.0f;
        this.m_bias = 0.0f;
    }

    public void setFrequency(float f) {
        this.m_frequencyHz = f;
    }

    public float getFrequency() {
        return this.m_frequencyHz;
    }

    public float getLength() {
        return this.m_length;
    }

    public void setLength(float f) {
        this.m_length = f;
    }

    public void setDampingRatio(float f) {
        this.m_dampingRatio = f;
    }

    public float getDampingRatio() {
        return this.m_dampingRatio;
    }

    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, vec2);
    }

    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, vec2);
    }

    public void getReactionForce(float f, Vec2 vec2) {
        vec2.x = this.m_impulse * this.m_u.x * f;
        vec2.y = this.m_impulse * this.m_u.y * f;
    }

    public float getReactionTorque(float f) {
        return 0.0f;
    }

    public void initVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        vec2.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
        vec22.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec2);
        Mat22.mulToOut(body2.getTransform().R, vec22, vec22);
        this.m_u.x = body2.m_sweep.c.x + vec22.x - body.m_sweep.c.x - vec2.x;
        this.m_u.y = body2.m_sweep.c.y + vec22.y - body.m_sweep.c.y - vec2.y;
        float f = this.m_u.length();
        if (f > Settings.linearSlop) {
            this.m_u.x *= 1.0f / f;
            this.m_u.y *= 1.0f / f;
        } else {
            this.m_u.set(0.0f, 0.0f);
        }
        float f2 = Vec2.cross(vec2, this.m_u);
        float f3 = Vec2.cross(vec22, this.m_u);
        float f4 = body.m_invMass + body.m_invI * f2 * f2 + body2.m_invMass + body2.m_invI * f3 * f3;
        assert (f4 > 1.1920929E-7f);
        this.m_mass = 1.0f / f4;
        if (this.m_frequencyHz > 0.0f) {
            float f5 = f - this.m_length;
            float f6 = (float)Math.PI * 2 * this.m_frequencyHz;
            float f7 = 2.0f * this.m_mass * this.m_dampingRatio * f6;
            float f8 = this.m_mass * f6 * f6;
            this.m_gamma = timeStep.dt * (f7 + timeStep.dt * f8);
            this.m_gamma = this.m_gamma != 0.0f ? 1.0f / this.m_gamma : 0.0f;
            this.m_bias = f5 * timeStep.dt * f8 * this.m_gamma;
            this.m_mass = f4 + this.m_gamma;
            float f9 = this.m_mass = this.m_mass != 0.0f ? 1.0f / this.m_mass : 0.0f;
        }
        if (timeStep.warmStarting) {
            this.m_impulse *= timeStep.dtRatio;
            Vec2 vec23 = this.pool.popVec2();
            vec23.set(this.m_u).mulLocal(this.m_impulse);
            body.m_linearVelocity.x -= body.m_invMass * vec23.x;
            body.m_linearVelocity.y -= body.m_invMass * vec23.y;
            body.m_angularVelocity -= body.m_invI * Vec2.cross(vec2, vec23);
            body2.m_linearVelocity.x += body2.m_invMass * vec23.x;
            body2.m_linearVelocity.y += body2.m_invMass * vec23.y;
            body2.m_angularVelocity += body2.m_invI * Vec2.cross(vec22, vec23);
            this.pool.pushVec2(1);
        } else {
            this.m_impulse = 0.0f;
        }
        this.pool.pushVec2(2);
    }

    public void solveVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        vec2.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
        vec22.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec2);
        Mat22.mulToOut(body2.getTransform().R, vec22, vec22);
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2.crossToOut(body.m_angularVelocity, vec2, vec23);
        Vec2.crossToOut(body2.m_angularVelocity, vec22, vec24);
        vec23.set(body.m_linearVelocity).addLocal(body.m_linearVelocity);
        vec24.set(body2.m_linearVelocity).addLocal(body2.m_linearVelocity);
        float f = Vec2.dot(this.m_u, vec24.subLocal(vec23));
        float f2 = -this.m_mass * (f + this.m_bias + this.m_gamma * this.m_impulse);
        this.m_impulse += f2;
        float f3 = f2 * this.m_u.x;
        float f4 = f2 * this.m_u.y;
        body.m_linearVelocity.x -= body.m_invMass * f3;
        body.m_linearVelocity.y -= body.m_invMass * f4;
        body.m_angularVelocity -= body.m_invI * (vec2.x * f4 - vec2.y * f3);
        body2.m_linearVelocity.x += body2.m_invMass * f3;
        body2.m_linearVelocity.y += body2.m_invMass * f4;
        body2.m_angularVelocity += body2.m_invI * (vec22.x * f4 - vec22.y * f3);
        this.pool.pushVec2(4);
    }

    public boolean solvePositionConstraints(float f) {
        if (this.m_frequencyHz > 0.0f) {
            return true;
        }
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        vec2.set(this.m_localAnchor1).subLocal(body.getLocalCenter());
        vec22.set(this.m_localAnchor2).subLocal(body2.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec2);
        Mat22.mulToOut(body2.getTransform().R, vec22, vec22);
        vec23.x = body2.m_sweep.c.x + vec22.x - body.m_sweep.c.x - vec2.x;
        vec23.y = body2.m_sweep.c.y + vec22.y - body.m_sweep.c.y - vec2.y;
        float f2 = vec23.normalize();
        float f3 = f2 - this.m_length;
        f3 = MathUtils.clamp(f3, -Settings.maxLinearCorrection, Settings.maxLinearCorrection);
        float f4 = -this.m_mass * f3;
        this.m_u.set(vec23);
        float f5 = f4 * this.m_u.x;
        float f6 = f4 * this.m_u.y;
        body.m_sweep.c.x -= body.m_invMass * f5;
        body.m_sweep.c.y -= body.m_invMass * f6;
        body.m_sweep.a -= body.m_invI * (vec2.x * f6 - vec2.y * f5);
        body2.m_sweep.c.x += body2.m_invMass * f5;
        body2.m_sweep.c.y += body2.m_invMass * f6;
        body2.m_sweep.a += body2.m_invI * (vec22.x * f6 - vec22.y * f5);
        body.synchronizeTransform();
        body2.synchronizeTransform();
        this.pool.pushVec2(3);
        return MathUtils.abs(f3) < Settings.linearSlop;
    }
}

