/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.contacts.ContactConstraint;

class PositionSolverManifold {
    public final Vec2 normal = new Vec2();
    public final Vec2 point = new Vec2();
    public float separation;
    private final Vec2 pointA = new Vec2();
    private final Vec2 pointB = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Vec2 planePoint = new Vec2();
    private final Vec2 clipPoint = new Vec2();

    PositionSolverManifold() {
    }

    public void initialize(ContactConstraint contactConstraint, int n) {
        assert (contactConstraint.pointCount > 0);
        switch (contactConstraint.type) {
            case CIRCLES: {
                contactConstraint.bodyA.getWorldPointToOut(contactConstraint.localPoint, this.pointA);
                contactConstraint.bodyB.getWorldPointToOut(contactConstraint.points[0].localPoint, this.pointB);
                if (MathUtils.distanceSquared(this.pointA, this.pointB) > 1.4210855E-14f) {
                    this.normal.set(this.pointB).subLocal(this.pointA);
                    this.normal.normalize();
                } else {
                    this.normal.set(1.0f, 0.0f);
                }
                this.point.set(this.pointA).addLocal(this.pointB).mulLocal(0.5f);
                this.temp.set(this.pointB).subLocal(this.pointA);
                this.separation = Vec2.dot(this.temp, this.normal) - contactConstraint.radius;
                break;
            }
            case FACE_A: {
                contactConstraint.bodyA.getWorldVectorToOut(contactConstraint.localNormal, this.normal);
                contactConstraint.bodyA.getWorldPointToOut(contactConstraint.localPoint, this.planePoint);
                contactConstraint.bodyB.getWorldPointToOut(contactConstraint.points[n].localPoint, this.clipPoint);
                this.temp.set(this.clipPoint).subLocal(this.planePoint);
                this.separation = Vec2.dot(this.temp, this.normal) - contactConstraint.radius;
                this.point.set(this.clipPoint);
                break;
            }
            case FACE_B: {
                contactConstraint.bodyB.getWorldVectorToOut(contactConstraint.localNormal, this.normal);
                contactConstraint.bodyB.getWorldPointToOut(contactConstraint.localPoint, this.planePoint);
                contactConstraint.bodyA.getWorldPointToOut(contactConstraint.points[n].localPoint, this.clipPoint);
                this.temp.set(this.clipPoint).subLocal(this.planePoint);
                this.separation = Vec2.dot(this.temp, this.normal) - contactConstraint.radius;
                this.point.set(this.clipPoint);
                this.normal.negateLocal();
            }
        }
    }
}

