/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.collision.broadphase.BroadPhase;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.dynamics.joints.JointEdge;

public class Body {
    public static final int e_islandFlag = 1;
    public static final int e_awakeFlag = 2;
    public static final int e_autoSleepFlag = 4;
    public static final int e_bulletFlag = 8;
    public static final int e_fixedRotationFlag = 16;
    public static final int e_activeFlag = 32;
    public static final int e_toiFlag = 64;
    public BodyType m_type;
    public int m_flags;
    public int m_islandIndex;
    public final Transform m_xf = new Transform();
    public final Sweep m_sweep = new Sweep();
    public final Vec2 m_linearVelocity = new Vec2();
    public float m_angularVelocity = 0.0f;
    public final Vec2 m_force = new Vec2();
    public float m_torque = 0.0f;
    public World m_world;
    public Body m_prev;
    public Body m_next;
    public Fixture m_fixtureList;
    public int m_fixtureCount;
    public JointEdge m_jointList;
    public ContactEdge m_contactList;
    public float m_mass;
    public float m_invMass;
    public float m_I;
    public float m_invI;
    public float m_linearDamping;
    public float m_angularDamping;
    public float m_sleepTime;
    public Object m_userData;
    private final FixtureDef fixDef = new FixtureDef();
    private final MassData pmd = new MassData();
    private final Transform pxf = new Transform();

    public Body(BodyDef bodyDef, World world) {
        assert (bodyDef.position.isValid());
        assert (bodyDef.linearVelocity.isValid());
        assert (bodyDef.inertiaScale >= 0.0f);
        assert (bodyDef.angularDamping >= 0.0f);
        assert (bodyDef.linearDamping >= 0.0f);
        this.m_flags = 0;
        if (bodyDef.bullet) {
            this.m_flags |= 8;
        }
        if (bodyDef.fixedRotation) {
            this.m_flags |= 0x10;
        }
        if (bodyDef.allowSleep) {
            this.m_flags |= 4;
        }
        if (bodyDef.awake) {
            this.m_flags |= 2;
        }
        if (bodyDef.active) {
            this.m_flags |= 0x20;
        }
        this.m_world = world;
        this.m_xf.position.set(bodyDef.position);
        this.m_xf.R.set(bodyDef.angle);
        this.m_sweep.localCenter.setZero();
        this.m_sweep.a0 = this.m_sweep.a = bodyDef.angle;
        Transform.mulToOut(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c0);
        this.m_sweep.c.set(this.m_sweep.c0);
        this.m_jointList = null;
        this.m_contactList = null;
        this.m_prev = null;
        this.m_next = null;
        this.m_linearVelocity.set(bodyDef.linearVelocity);
        this.m_angularVelocity = bodyDef.angularVelocity;
        this.m_linearDamping = bodyDef.linearDamping;
        this.m_angularDamping = bodyDef.angularDamping;
        this.m_force.setZero();
        this.m_torque = 0.0f;
        this.m_sleepTime = 0.0f;
        this.m_type = bodyDef.type;
        if (this.m_type == BodyType.DYNAMIC) {
            this.m_mass = 1.0f;
            this.m_invMass = 1.0f;
        } else {
            this.m_mass = 0.0f;
            this.m_invMass = 0.0f;
        }
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_userData = bodyDef.userData;
        this.m_fixtureList = null;
        this.m_fixtureCount = 0;
    }

    public final Fixture createFixture(FixtureDef fixtureDef) {
        assert (!this.m_world.isLocked());
        if (this.m_world.isLocked()) {
            return null;
        }
        Fixture fixture = new Fixture();
        fixture.create(this, fixtureDef);
        if ((this.m_flags & 0x20) == 32) {
            BroadPhase broadPhase = this.m_world.m_contactManager.m_broadPhase;
            fixture.createProxy(broadPhase, this.m_xf);
        }
        fixture.m_next = this.m_fixtureList;
        this.m_fixtureList = fixture;
        ++this.m_fixtureCount;
        fixture.m_body = this;
        if (fixture.m_density > 0.0f) {
            this.resetMassData();
        }
        this.m_world.m_flags |= 1;
        return fixture;
    }

    public final Fixture createFixture(Shape shape, float f) {
        this.fixDef.shape = shape;
        this.fixDef.density = f;
        return this.createFixture(this.fixDef);
    }

    public final void destroyFixture(Fixture fixture) {
        Object object;
        assert (!this.m_world.isLocked());
        if (this.m_world.isLocked()) {
            return;
        }
        assert (fixture.m_body == this);
        assert (this.m_fixtureCount > 0);
        Fixture fixture2 = this.m_fixtureList;
        Fixture fixture3 = null;
        boolean bl = false;
        while (fixture2 != null) {
            if (fixture2 == fixture) {
                fixture2 = fixture.m_next;
                bl = true;
                break;
            }
            fixture3 = fixture2;
            fixture2 = fixture2.m_next;
        }
        assert (bl);
        if (fixture3 == null) {
            this.m_fixtureList = fixture.m_next;
        } else {
            fixture3.m_next = fixture.m_next;
        }
        ContactEdge contactEdge = this.m_contactList;
        while (contactEdge != null) {
            object = contactEdge.contact;
            contactEdge = contactEdge.next;
            Fixture fixture4 = ((Contact)object).getFixtureA();
            Fixture fixture5 = ((Contact)object).getFixtureB();
            if (fixture != fixture4 && fixture != fixture5) continue;
            this.m_world.m_contactManager.destroy((Contact)object);
        }
        if ((this.m_flags & 0x20) == 32) {
            assert (fixture.m_proxy != null);
            object = this.m_world.m_contactManager.m_broadPhase;
            fixture.destroyProxy((BroadPhase)object);
        } else assert (fixture.m_proxy == null);
        fixture.destroy();
        fixture.m_body = null;
        fixture.m_next = null;
        fixture = null;
        --this.m_fixtureCount;
        this.resetMassData();
    }

    public final void setTransform(Vec2 vec2, float f) {
        assert (!this.m_world.isLocked());
        if (this.m_world.isLocked()) {
            return;
        }
        this.m_xf.R.set(f);
        this.m_xf.position.set(vec2);
        Transform.mulToOut(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c0);
        this.m_sweep.c.set(this.m_sweep.c0);
        this.m_sweep.a0 = this.m_sweep.a = f;
        BroadPhase broadPhase = this.m_world.m_contactManager.m_broadPhase;
        Fixture fixture = this.m_fixtureList;
        while (fixture != null) {
            fixture.synchronize(broadPhase, this.m_xf, this.m_xf);
            fixture = fixture.m_next;
        }
        this.m_world.m_contactManager.findNewContacts();
    }

    public final Transform getTransform() {
        return this.m_xf;
    }

    public final Vec2 getPosition() {
        return this.m_xf.position;
    }

    public final float getAngle() {
        return this.m_sweep.a;
    }

    public final Vec2 getWorldCenter() {
        return this.m_sweep.c;
    }

    public final Vec2 getLocalCenter() {
        return this.m_sweep.localCenter;
    }

    public final void setLinearVelocity(Vec2 vec2) {
        if (this.m_type == BodyType.STATIC) {
            return;
        }
        if (Vec2.dot(vec2, vec2) > 0.0f) {
            this.setAwake(true);
        }
        this.m_linearVelocity.set(vec2);
    }

    public final Vec2 getLinearVelocity() {
        return this.m_linearVelocity;
    }

    public final void setAngularVelocity(float f) {
        if (this.m_type == BodyType.STATIC) {
            return;
        }
        if (f * f > 0.0f) {
            this.setAwake(true);
        }
        this.m_angularVelocity = f;
    }

    public final float getAngularVelocity() {
        return this.m_angularVelocity;
    }

    public final void applyForce(Vec2 vec2, Vec2 vec22) {
        if (this.m_type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.m_force.x += vec2.x;
        this.m_force.y += vec2.y;
        this.m_torque += (vec22.x - this.m_sweep.c.x) * vec2.y - (vec22.y - this.m_sweep.c.y) * vec2.x;
    }

    public final void applyTorque(float f) {
        if (this.m_type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.m_torque += f;
    }

    public final void applyLinearImpulse(Vec2 vec2, Vec2 vec22) {
        if (this.m_type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.m_linearVelocity.x += vec2.x * this.m_invMass;
        this.m_linearVelocity.y += vec2.y * this.m_invMass;
        this.m_angularVelocity += this.m_invI * ((vec22.x - this.m_sweep.c.x) * vec2.y - (vec22.y - this.m_sweep.c.y) * vec2.x);
    }

    public void applyAngularImpulse(float f) {
        if (this.m_type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.m_angularVelocity += this.m_invI * f;
    }

    public final float getMass() {
        return this.m_mass;
    }

    public final float getInertia() {
        return this.m_I + this.m_mass * (this.m_sweep.localCenter.x * this.m_sweep.localCenter.x + this.m_sweep.localCenter.y * this.m_sweep.localCenter.y);
    }

    public final void getMassData(MassData massData) {
        massData.mass = this.m_mass;
        massData.I = this.m_I + this.m_mass * (this.m_sweep.localCenter.x * this.m_sweep.localCenter.x + this.m_sweep.localCenter.y * this.m_sweep.localCenter.y);
        massData.center.x = this.m_sweep.localCenter.x;
        massData.center.y = this.m_sweep.localCenter.y;
    }

    public final void setMassData(MassData massData) {
        assert (!this.m_world.isLocked());
        if (this.m_world.isLocked()) {
            return;
        }
        if (this.m_type != BodyType.DYNAMIC) {
            return;
        }
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_mass = massData.mass;
        if (this.m_mass <= 0.0f) {
            this.m_mass = 1.0f;
        }
        this.m_invMass = 1.0f / this.m_mass;
        if (massData.I > 0.0f && (this.m_flags & 0x10) == 0) {
            this.m_I = massData.I - this.m_mass * Vec2.dot(massData.center, massData.center);
            assert (this.m_I > 0.0f);
            this.m_invI = 1.0f / this.m_I;
        }
        Vec2 vec2 = this.m_world.getPool().popVec2();
        vec2.set(this.m_sweep.c);
        this.m_sweep.localCenter.set(massData.center);
        Transform.mulToOut(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c0);
        this.m_sweep.c.set(this.m_sweep.c0);
        Vec2 vec22 = this.m_world.getPool().popVec2();
        vec22.set(this.m_sweep.c).subLocal(vec2);
        Vec2.crossToOut(this.m_angularVelocity, vec22, vec22);
        this.m_linearVelocity.addLocal(vec22);
        this.m_world.getPool().pushVec2(2);
    }

    public final void resetMassData() {
        this.m_mass = 0.0f;
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_sweep.localCenter.setZero();
        if (this.m_type == BodyType.STATIC || this.m_type == BodyType.KINEMATIC) {
            this.m_sweep.c.set(this.m_xf.position);
            this.m_sweep.c0.set(this.m_xf.position);
            return;
        }
        assert (this.m_type == BodyType.DYNAMIC);
        Vec2 vec2 = this.m_world.getPool().popVec2();
        vec2.setZero();
        Vec2 vec22 = this.m_world.getPool().popVec2();
        MassData massData = this.pmd;
        Object object = this.m_fixtureList;
        while (object != null) {
            if (((Fixture)object).m_density != 0.0f) {
                ((Fixture)object).getMassData(massData);
                this.m_mass += massData.mass;
                vec22.set(massData.center).mulLocal(massData.mass);
                vec2.addLocal(vec22);
                this.m_I += massData.I;
            }
            object = ((Fixture)object).m_next;
        }
        if (this.m_mass > 0.0f) {
            this.m_invMass = 1.0f / this.m_mass;
            vec2.mulLocal(this.m_invMass);
        } else {
            this.m_mass = 1.0f;
            this.m_invMass = 1.0f;
        }
        if (this.m_I > 0.0f && (this.m_flags & 0x10) == 0) {
            this.m_I -= this.m_mass * Vec2.dot(vec2, vec2);
            assert (this.m_I > 0.0f);
            this.m_invI = 1.0f / this.m_I;
        } else {
            this.m_I = 0.0f;
            this.m_invI = 0.0f;
        }
        object = this.m_world.getPool().popVec2();
        ((Vec2)object).set(this.m_sweep.c);
        this.m_sweep.localCenter.set(vec2);
        Transform.mulToOut(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c0);
        this.m_sweep.c.set(this.m_sweep.c0);
        vec22.set(this.m_sweep.c).subLocal((Vec2)object);
        Vec2.crossToOut(this.m_angularVelocity, vec22, vec22);
        this.m_linearVelocity.addLocal(vec22);
        this.m_world.getPool().pushVec2(3);
    }

    public final Vec2 getWorldPoint(Vec2 vec2) {
        Vec2 vec22 = new Vec2();
        this.getWorldPointToOut(vec2, vec22);
        return vec22;
    }

    public final void getWorldPointToOut(Vec2 vec2, Vec2 vec22) {
        Transform.mulToOut(this.m_xf, vec2, vec22);
    }

    public final Vec2 getWorldVector(Vec2 vec2) {
        Vec2 vec22 = new Vec2();
        this.getWorldVectorToOut(vec2, vec22);
        return vec22;
    }

    public final void getWorldVectorToOut(Vec2 vec2, Vec2 vec22) {
        Mat22.mulToOut(this.m_xf.R, vec2, vec22);
    }

    public final Vec2 getLocalPoint(Vec2 vec2) {
        Vec2 vec22 = new Vec2();
        this.getLocalPointToOut(vec2, vec22);
        return vec22;
    }

    public final void getLocalPointToOut(Vec2 vec2, Vec2 vec22) {
        Transform.mulTransToOut(this.m_xf, vec2, vec22);
    }

    public final Vec2 getLocalVector(Vec2 vec2) {
        Vec2 vec22 = new Vec2();
        this.getLocalVectorToOut(vec2, vec22);
        return vec22;
    }

    public final void getLocalVectorToOut(Vec2 vec2, Vec2 vec22) {
        Mat22.mulTransToOut(this.m_xf.R, vec2, vec22);
    }

    public final Vec2 getLinearVelocityFromWorldPoint(Vec2 vec2) {
        Vec2 vec22 = new Vec2();
        this.getLinearVelocityFromWorldPointToOut(vec2, vec22);
        return vec22;
    }

    public final void getLinearVelocityFromWorldPointToOut(Vec2 vec2, Vec2 vec22) {
        vec22.set(vec2).subLocal(this.m_sweep.c);
        Vec2.crossToOut(this.m_angularVelocity, vec22, vec22);
        vec22.addLocal(this.m_linearVelocity);
    }

    public final Vec2 getLinearVelocityFromLocalPoint(Vec2 vec2) {
        Vec2 vec22 = new Vec2();
        this.getLinearVelocityFromLocalPointToOut(vec2, vec22);
        return vec22;
    }

    public final void getLinearVelocityFromLocalPointToOut(Vec2 vec2, Vec2 vec22) {
        this.getWorldPointToOut(vec2, vec22);
        this.getLinearVelocityFromWorldPointToOut(vec22, vec22);
    }

    public final float getLinearDamping() {
        return this.m_linearDamping;
    }

    public final void setLinearDamping(float f) {
        this.m_linearDamping = f;
    }

    public final float getAngularDamping() {
        return this.m_angularDamping;
    }

    public final void setAngularDamping(float f) {
        this.m_angularDamping = f;
    }

    public BodyType getType() {
        return this.m_type;
    }

    public void setType(BodyType bodyType) {
        if (this.m_type == bodyType) {
            return;
        }
        this.m_type = bodyType;
        this.resetMassData();
        if (this.m_type == BodyType.STATIC) {
            this.m_linearVelocity.setZero();
            this.m_angularVelocity = 0.0f;
        }
        this.setAwake(true);
        this.m_force.setZero();
        this.m_torque = 0.0f;
        ContactEdge contactEdge = this.m_contactList;
        while (contactEdge != null) {
            contactEdge.contact.flagForFiltering();
            contactEdge = contactEdge.next;
        }
    }

    public final boolean isBullet() {
        return (this.m_flags & 8) == 8;
    }

    public final void setBullet(boolean bl) {
        this.m_flags = bl ? (this.m_flags |= 8) : (this.m_flags &= 0xFFFFFFF7);
    }

    public void setSleepingAllowed(boolean bl) {
        if (bl) {
            this.m_flags |= 4;
        } else {
            this.m_flags &= 0xFFFFFFFB;
            this.setAwake(true);
        }
    }

    public boolean isSleepingAllowed() {
        return (this.m_flags & 4) == 4;
    }

    public void setAwake(boolean bl) {
        if (bl) {
            if ((this.m_flags & 2) == 0) {
                this.m_flags |= 2;
                this.m_sleepTime = 0.0f;
            }
        } else {
            this.m_flags &= 0xFFFFFFFD;
            this.m_sleepTime = 0.0f;
            this.m_linearVelocity.setZero();
            this.m_angularVelocity = 0.0f;
            this.m_force.setZero();
            this.m_torque = 0.0f;
        }
    }

    public boolean isAwake() {
        return (this.m_flags & 2) == 2;
    }

    public void setActive(boolean bl) {
        if (bl == this.isActive()) {
            return;
        }
        if (bl) {
            this.m_flags |= 0x20;
            BroadPhase broadPhase = this.m_world.m_contactManager.m_broadPhase;
            Fixture fixture = this.m_fixtureList;
            while (fixture != null) {
                fixture.createProxy(broadPhase, this.m_xf);
                fixture = fixture.m_next;
            }
        } else {
            this.m_flags &= 0xFFFFFFDF;
            BroadPhase broadPhase = this.m_world.m_contactManager.m_broadPhase;
            Object object = this.m_fixtureList;
            while (object != null) {
                ((Fixture)object).destroyProxy(broadPhase);
                object = ((Fixture)object).m_next;
            }
            object = this.m_contactList;
            while (object != null) {
                Object object2 = object;
                object = ((ContactEdge)object).next;
                this.m_world.m_contactManager.destroy(((ContactEdge)object2).contact);
            }
            this.m_contactList = null;
        }
    }

    public boolean isActive() {
        return (this.m_flags & 0x20) == 32;
    }

    public void setFixedRotation(boolean bl) {
        this.m_flags = bl ? (this.m_flags |= 0x10) : (this.m_flags &= 0xFFFFFFEF);
        this.resetMassData();
    }

    public boolean isFixedRotation() {
        return (this.m_flags & 0x10) == 16;
    }

    public final Fixture getFixtureList() {
        return this.m_fixtureList;
    }

    public final JointEdge getJointList() {
        return this.m_jointList;
    }

    public final ContactEdge getContactList() {
        return this.m_contactList;
    }

    public final Body getNext() {
        return this.m_next;
    }

    public final Object getUserData() {
        return this.m_userData;
    }

    public final void setUserData(Object object) {
        this.m_userData = object;
    }

    public final World getWorld() {
        return this.m_world;
    }

    protected final void synchronizeFixtures() {
        Transform transform = this.pxf;
        transform.R.set(this.m_sweep.a0);
        Mat22.mulToOut(transform.R, this.m_sweep.localCenter, transform.position);
        transform.position.mulLocal(-1.0f).addLocal(this.m_sweep.c0);
        BroadPhase broadPhase = this.m_world.m_contactManager.m_broadPhase;
        Fixture fixture = this.m_fixtureList;
        while (fixture != null) {
            fixture.synchronize(broadPhase, transform, this.m_xf);
            fixture = fixture.m_next;
        }
    }

    public final void synchronizeTransform() {
        float f = MathUtils.cos(this.m_sweep.a);
        float f2 = MathUtils.sin(this.m_sweep.a);
        this.m_xf.R.col1.x = f;
        this.m_xf.R.col2.x = -f2;
        this.m_xf.R.col1.y = f2;
        this.m_xf.R.col2.y = f;
        this.m_xf.position.x = this.m_xf.R.col1.x * this.m_sweep.localCenter.x + this.m_xf.R.col2.x * this.m_sweep.localCenter.y;
        this.m_xf.position.y = this.m_xf.R.col1.y * this.m_sweep.localCenter.x + this.m_xf.R.col2.y * this.m_sweep.localCenter.y;
        this.m_xf.position.x *= -1.0f;
        this.m_xf.position.y *= -1.0f;
        this.m_xf.position.x += this.m_sweep.c.x;
        this.m_xf.position.y += this.m_sweep.c.y;
    }

    public boolean shouldCollide(Body body) {
        if (this.m_type != BodyType.DYNAMIC && body.m_type != BodyType.DYNAMIC) {
            return false;
        }
        JointEdge jointEdge = this.m_jointList;
        while (jointEdge != null) {
            if (jointEdge.other == body && !jointEdge.joint.m_collideConnected) {
                return false;
            }
            jointEdge = jointEdge.next;
        }
        return true;
    }

    protected final void advance(float f) {
        this.m_sweep.advance(f);
        this.m_sweep.c.set(this.m_sweep.c0);
        this.m_sweep.a = this.m_sweep.a0;
        this.synchronizeTransform();
    }
}

