/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;

public class Vec3
implements Serializable {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;

    public Vec3() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vec3(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vec3(Vec3 vec3) {
        this.x = vec3.x;
        this.y = vec3.y;
        this.z = vec3.z;
    }

    public Vec3 set(Vec3 vec3) {
        this.x = vec3.x;
        this.y = vec3.y;
        this.z = vec3.z;
        return this;
    }

    public Vec3 set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vec3 addLocal(Vec3 vec3) {
        this.x += vec3.x;
        this.y += vec3.y;
        this.z += vec3.z;
        return this;
    }

    public Vec3 add(Vec3 vec3) {
        return new Vec3(this.x + vec3.x, this.y + vec3.y, this.z + vec3.z);
    }

    public Vec3 subLocal(Vec3 vec3) {
        this.x -= vec3.x;
        this.y -= vec3.y;
        this.z -= vec3.z;
        return this;
    }

    public Vec3 sub(Vec3 vec3) {
        return new Vec3(this.x - vec3.x, this.y - vec3.y, this.z - vec3.z);
    }

    public Vec3 mulLocal(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public Vec3 mul(float f) {
        return new Vec3(this.x * f, this.y * f, this.z * f);
    }

    public Vec3 negate() {
        return new Vec3(-this.x, -this.y, -this.z);
    }

    public Vec3 negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public void setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vec3 clone() {
        return new Vec3(this);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.x);
        n = 31 * n + Float.floatToIntBits(this.y);
        n = 31 * n + Float.floatToIntBits(this.z);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vec3 vec3 = (Vec3)object;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(vec3.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(vec3.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(vec3.z);
    }

    public static final float dot(Vec3 vec3, Vec3 vec32) {
        return vec3.x * vec32.x + vec3.y * vec32.y + vec3.z * vec32.z;
    }

    public static final Vec3 cross(Vec3 vec3, Vec3 vec32) {
        return new Vec3(vec3.y * vec32.z - vec3.z * vec32.y, vec3.z * vec32.x - vec3.x * vec32.z, vec3.x * vec32.y - vec3.y * vec32.x);
    }

    public static final void crossToOut(Vec3 vec3, Vec3 vec32, Vec3 vec33) {
        float f = vec3.z * vec32.x - vec3.x * vec32.z;
        float f2 = vec3.x * vec32.y - vec3.y * vec32.x;
        vec33.x = vec3.y * vec32.z - vec3.z * vec32.y;
        vec33.y = f;
        vec33.z = f2;
    }
}

