/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

public class ContactID {
    public final Features features;

    public boolean isEqual(ContactID contactID) {
        return contactID.features.isEqual(this.features);
    }

    public ContactID() {
        this.features = new Features();
    }

    public ContactID(ContactID contactID) {
        this.features = new Features(contactID.features);
    }

    public void set(ContactID contactID) {
        this.features.set(contactID.features);
    }

    public void zero() {
        this.features.flip = 0;
        this.features.incidentEdge = 0;
        this.features.incidentVertex = 0;
        this.features.referenceEdge = 0;
    }

    public static class Features {
        public int referenceEdge;
        public int incidentEdge;
        public int incidentVertex;
        public int flip;

        public Features() {
            this.flip = 0;
            this.incidentVertex = 0;
            this.incidentEdge = 0;
            this.referenceEdge = 0;
        }

        private Features(Features features) {
            this.referenceEdge = features.referenceEdge;
            this.incidentEdge = features.incidentEdge;
            this.incidentVertex = features.incidentVertex;
            this.flip = features.flip;
        }

        private void set(Features features) {
            this.referenceEdge = features.referenceEdge;
            this.incidentEdge = features.incidentEdge;
            this.incidentVertex = features.incidentVertex;
            this.flip = features.flip;
        }

        private boolean isEqual(Features features) {
            return this.referenceEdge == features.referenceEdge && this.incidentEdge == features.incidentEdge && this.incidentVertex == features.incidentVertex && this.flip == features.flip;
        }

        public String toString() {
            String string = "Features: (" + this.flip + " ," + this.incidentEdge + " ," + this.incidentVertex + " ," + this.referenceEdge + ")";
            return string;
        }
    }
}

