/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Distance;
import org.jbox2d.collision.DistanceInput;
import org.jbox2d.collision.DistanceOutput;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.IWorldPool;

public class Collision {
    public static final int NULL_FEATURE = Integer.MAX_VALUE;
    private final IWorldPool pool;
    private final DistanceInput input = new DistanceInput();
    private final Distance.SimplexCache cache = new Distance.SimplexCache();
    private final DistanceOutput output = new DistanceOutput();
    private final Vec2 d = new Vec2();
    private final Vec2 pA = new Vec2();
    private final Vec2 pB = new Vec2();
    private final Vec2 c = new Vec2();
    private final Vec2 cLocal = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Vec2 temp2 = new Vec2();
    private final Vec2 normal1World = new Vec2();
    private final Vec2 normal1 = new Vec2();
    private final Vec2 v1 = new Vec2();
    private final Vec2 v2 = new Vec2();
    private final Vec2 dLocal1 = new Vec2();
    private final EdgeResults results1 = new EdgeResults();
    private final EdgeResults results2 = new EdgeResults();
    private final ClipVertex[] incidentEdge = new ClipVertex[2];
    private final Vec2 localTangent = new Vec2();
    private final Vec2 localNormal = new Vec2();
    private final Vec2 planePoint = new Vec2();
    private final Vec2 tangent = new Vec2();
    private final Vec2 normal = new Vec2();
    private final Vec2 v11 = new Vec2();
    private final Vec2 v12 = new Vec2();
    private final ClipVertex[] clipPoints1 = new ClipVertex[2];
    private final ClipVertex[] clipPoints2 = new ClipVertex[2];

    public Collision(IWorldPool iWorldPool) {
        this.incidentEdge[0] = new ClipVertex();
        this.incidentEdge[1] = new ClipVertex();
        this.clipPoints1[0] = new ClipVertex();
        this.clipPoints1[1] = new ClipVertex();
        this.clipPoints2[0] = new ClipVertex();
        this.clipPoints2[1] = new ClipVertex();
        this.pool = iWorldPool;
    }

    public final boolean testOverlap(Shape shape, Shape shape2, Transform transform, Transform transform2) {
        this.input.proxyA.set(shape);
        this.input.proxyB.set(shape2);
        this.input.transformA.set(transform);
        this.input.transformB.set(transform2);
        this.input.useRadii = true;
        this.cache.count = 0;
        this.pool.getDistance().distance(this.output, this.cache, this.input);
        return this.output.distance < 1.1920929E-6f;
    }

    public static final void getPointStates(PointState[] pointStateArray, PointState[] pointStateArray2, Manifold manifold, Manifold manifold2) {
        int n;
        ContactID contactID;
        int n2;
        for (n2 = 0; n2 < Settings.maxManifoldPoints; ++n2) {
            pointStateArray[n2] = PointState.NULL_STATE;
            pointStateArray2[n2] = PointState.NULL_STATE;
        }
        block1: for (n2 = 0; n2 < manifold.pointCount; ++n2) {
            contactID = manifold.points[n2].id;
            pointStateArray[n2] = PointState.REMOVE_STATE;
            for (n = 0; n < manifold2.pointCount; ++n) {
                if (!manifold2.points[n].id.isEqual(contactID)) continue;
                pointStateArray[n2] = PointState.PERSIST_STATE;
                continue block1;
            }
        }
        block3: for (n2 = 0; n2 < manifold2.pointCount; ++n2) {
            contactID = manifold2.points[n2].id;
            pointStateArray2[n2] = PointState.ADD_STATE;
            for (n = 0; n < manifold.pointCount; ++n) {
                if (!manifold.points[n].id.isEqual(contactID)) continue;
                pointStateArray2[n2] = PointState.PERSIST_STATE;
                continue block3;
            }
        }
    }

    public static final int clipSegmentToLine(ClipVertex[] clipVertexArray, ClipVertex[] clipVertexArray2, Vec2 vec2, float f) {
        int n = 0;
        float f2 = Vec2.dot(vec2, clipVertexArray2[0].v) - f;
        float f3 = Vec2.dot(vec2, clipVertexArray2[1].v) - f;
        if (f2 <= 0.0f) {
            clipVertexArray[n++].set(clipVertexArray2[0]);
        }
        if (f3 <= 0.0f) {
            clipVertexArray[n++].set(clipVertexArray2[1]);
        }
        if (f2 * f3 < 0.0f) {
            float f4 = f2 / (f2 - f3);
            clipVertexArray[n].v.set(clipVertexArray2[1].v).subLocal(clipVertexArray2[0].v).mulLocal(f4).addLocal(clipVertexArray2[0].v);
            if (f2 > 0.0f) {
                clipVertexArray[n].id.set(clipVertexArray2[0].id);
            } else {
                clipVertexArray[n].id.set(clipVertexArray2[1].id);
            }
            ++n;
        }
        return n;
    }

    public final void collideCircles(Manifold manifold, CircleShape circleShape, Transform transform, CircleShape circleShape2, Transform transform2) {
        manifold.pointCount = 0;
        Transform.mulToOut(transform, circleShape.m_p, this.pA);
        Transform.mulToOut(transform2, circleShape2.m_p, this.pB);
        this.d.set(this.pB).subLocal(this.pA);
        float f = Vec2.dot(this.d, this.d);
        float f2 = circleShape.m_radius + circleShape2.m_radius;
        if (f > f2 * f2) {
            return;
        }
        manifold.type = Manifold.ManifoldType.CIRCLES;
        manifold.localPoint.set(circleShape.m_p);
        manifold.localNormal.setZero();
        manifold.pointCount = 1;
        manifold.points[0].localPoint.set(circleShape2.m_p);
        manifold.points[0].id.zero();
    }

    public final void collidePolygonAndCircle(Manifold manifold, PolygonShape polygonShape, Transform transform, CircleShape circleShape, Transform transform2) {
        int n;
        manifold.pointCount = 0;
        Transform.mulToOut(transform2, circleShape.m_p, this.c);
        Transform.mulTransToOut(transform, this.c, this.cLocal);
        int n2 = 0;
        float f = Float.MIN_VALUE;
        float f2 = polygonShape.m_radius + circleShape.m_radius;
        int n3 = polygonShape.m_vertexCount;
        Vec2[] vec2Array = polygonShape.m_vertices;
        Vec2[] vec2Array2 = polygonShape.m_normals;
        for (n = 0; n < n3; ++n) {
            this.temp.set(this.cLocal).subLocal(vec2Array[n]);
            float f3 = Vec2.dot(vec2Array2[n], this.temp);
            if (f3 > f2) {
                return;
            }
            if (!(f3 > f)) continue;
            f = f3;
            n2 = n;
        }
        n = n2;
        int n4 = n + 1 < n3 ? n + 1 : 0;
        Vec2 vec2 = vec2Array[n];
        Vec2 vec22 = vec2Array[n4];
        if (f < 1.1920929E-7f) {
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.set(vec2Array2[n2]);
            manifold.localPoint.set(vec2).addLocal(vec22).mulLocal(0.5f);
            manifold.points[0].localPoint.set(circleShape.m_p);
            manifold.points[0].id.zero();
            return;
        }
        this.temp.set(this.cLocal).subLocal(vec2);
        this.temp2.set(vec22).subLocal(vec2);
        float f4 = Vec2.dot(this.temp, this.temp2);
        this.temp.set(this.cLocal).subLocal(vec22);
        this.temp2.set(vec2).subLocal(vec22);
        float f5 = Vec2.dot(this.temp, this.temp2);
        if (f4 <= 0.0f) {
            if (MathUtils.distanceSquared(this.cLocal, vec2) > f2 * f2) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.set(this.cLocal).subLocal(vec2);
            manifold.localNormal.normalize();
            manifold.localPoint.set(vec2);
            manifold.points[0].localPoint.set(circleShape.m_p);
            manifold.points[0].id.zero();
        } else if (f5 <= 0.0f) {
            if (MathUtils.distanceSquared(this.cLocal, vec22) > f2 * f2) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.set(this.cLocal).subLocal(vec22);
            manifold.localNormal.normalize();
            manifold.localPoint.set(vec22);
            manifold.points[0].localPoint.set(circleShape.m_p);
            manifold.points[0].id.zero();
        } else {
            this.temp.set(vec2).addLocal(vec22).mulLocal(0.5f);
            this.temp2.set(this.cLocal).subLocal(this.temp);
            f = Vec2.dot(this.temp2, vec2Array2[n]);
            if (f > f2) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.set(vec2Array2[n]);
            manifold.localPoint.set(this.temp);
            manifold.points[0].localPoint.set(circleShape.m_p);
            manifold.points[0].id.zero();
        }
    }

    public final float edgeSeparation(PolygonShape polygonShape, Transform transform, int n, PolygonShape polygonShape2, Transform transform2) {
        int n2 = polygonShape.m_vertexCount;
        Vec2[] vec2Array = polygonShape.m_vertices;
        Vec2[] vec2Array2 = polygonShape.m_normals;
        int n3 = polygonShape2.m_vertexCount;
        Vec2[] vec2Array3 = polygonShape2.m_vertices;
        assert (0 <= n && n < n2);
        Mat22.mulToOut(transform.R, vec2Array2[n], this.normal1World);
        Mat22.mulTransToOut(transform2.R, this.normal1World, this.normal1);
        int n4 = 0;
        float f = Float.MAX_VALUE;
        for (int i = 0; i < n3; ++i) {
            float f2 = Vec2.dot(vec2Array3[i], this.normal1);
            if (!(f2 < f)) continue;
            f = f2;
            n4 = i;
        }
        Transform.mulToOut(transform, vec2Array[n], this.v1);
        Transform.mulToOut(transform2, vec2Array3[n4], this.v2);
        float f3 = Vec2.dot(this.v2.subLocal(this.v1), this.normal1World);
        return f3;
    }

    public final void findMaxSeparation(EdgeResults edgeResults, PolygonShape polygonShape, Transform transform, PolygonShape polygonShape2, Transform transform2) {
        float f;
        int n;
        int n2;
        int n3 = polygonShape.m_vertexCount;
        Vec2[] vec2Array = polygonShape.m_normals;
        Transform.mulToOut(transform2, polygonShape2.m_centroid, this.d);
        Transform.mulToOut(transform, polygonShape.m_centroid, this.temp);
        this.d.subLocal(this.temp);
        Mat22.mulTransToOut(transform.R, this.d, this.dLocal1);
        int n4 = 0;
        float f2 = Float.MIN_VALUE;
        for (int i = 0; i < n3; ++i) {
            float f3 = Vec2.dot(vec2Array[i], this.dLocal1);
            if (!(f3 > f2)) continue;
            f2 = f3;
            n4 = i;
        }
        float f4 = this.edgeSeparation(polygonShape, transform, n4, polygonShape2, transform2);
        int n5 = n4 - 1 >= 0 ? n4 - 1 : n3 - 1;
        float f5 = this.edgeSeparation(polygonShape, transform, n5, polygonShape2, transform2);
        int n6 = n4 + 1 < n3 ? n4 + 1 : 0;
        float f6 = this.edgeSeparation(polygonShape, transform, n6, polygonShape2, transform2);
        if (f5 > f4 && f5 > f6) {
            n2 = -1;
            n = n5;
            f = f5;
        } else if (f6 > f4) {
            n2 = 1;
            n = n6;
            f = f6;
        } else {
            edgeResults.edgeIndex = n4;
            edgeResults.separation = f4;
            return;
        }
        while ((f4 = this.edgeSeparation(polygonShape, transform, n4 = n2 == -1 ? (n - 1 >= 0 ? n - 1 : n3 - 1) : (n + 1 < n3 ? n + 1 : 0), polygonShape2, transform2)) > f) {
            n = n4;
            f = f4;
        }
        edgeResults.edgeIndex = n;
        edgeResults.separation = f;
    }

    public final void findIncidentEdge(ClipVertex[] clipVertexArray, PolygonShape polygonShape, Transform transform, int n, PolygonShape polygonShape2, Transform transform2) {
        int n2;
        int n3 = polygonShape.m_vertexCount;
        Vec2[] vec2Array = polygonShape.m_normals;
        int n4 = polygonShape2.m_vertexCount;
        Vec2[] vec2Array2 = polygonShape2.m_vertices;
        Vec2[] vec2Array3 = polygonShape2.m_normals;
        assert (0 <= n && n < n3);
        Mat22.mulToOut(transform.R, vec2Array[n], this.normal1);
        Mat22.mulTransToOut(transform2.R, this.normal1, this.normal1);
        int n5 = 0;
        float f = Float.MAX_VALUE;
        for (n2 = 0; n2 < n4; ++n2) {
            float f2 = Vec2.dot(this.normal1, vec2Array3[n2]);
            if (!(f2 < f)) continue;
            f = f2;
            n5 = n2;
        }
        n2 = n5;
        int n6 = n2 + 1 < n4 ? n2 + 1 : 0;
        Transform.mulToOut(transform2, vec2Array2[n2], clipVertexArray[0].v);
        clipVertexArray[0].id.features.referenceEdge = n;
        clipVertexArray[0].id.features.incidentEdge = n2;
        clipVertexArray[0].id.features.incidentVertex = 0;
        Transform.mulToOut(transform2, vec2Array2[n6], clipVertexArray[1].v);
        clipVertexArray[1].id.features.referenceEdge = n;
        clipVertexArray[1].id.features.incidentEdge = n6;
        clipVertexArray[1].id.features.incidentVertex = 1;
    }

    public final void collidePolygons(Manifold manifold, PolygonShape polygonShape, Transform transform, PolygonShape polygonShape2, Transform transform2) {
        int n;
        int n2;
        Transform transform3;
        Transform transform4;
        PolygonShape polygonShape3;
        PolygonShape polygonShape4;
        manifold.pointCount = 0;
        float f = polygonShape.m_radius + polygonShape2.m_radius;
        this.findMaxSeparation(this.results1, polygonShape, transform, polygonShape2, transform2);
        if (this.results1.separation > f) {
            return;
        }
        this.findMaxSeparation(this.results2, polygonShape2, transform2, polygonShape, transform);
        if (this.results2.separation > f) {
            return;
        }
        if (this.results2.separation > 0.98f * this.results1.separation + 0.001f) {
            polygonShape4 = polygonShape2;
            polygonShape3 = polygonShape;
            transform4 = transform2;
            transform3 = transform;
            n2 = this.results2.edgeIndex;
            manifold.type = Manifold.ManifoldType.FACE_B;
            n = 1;
        } else {
            polygonShape4 = polygonShape;
            polygonShape3 = polygonShape2;
            transform4 = transform;
            transform3 = transform2;
            n2 = this.results1.edgeIndex;
            manifold.type = Manifold.ManifoldType.FACE_A;
            n = 0;
        }
        this.findIncidentEdge(this.incidentEdge, polygonShape4, transform4, n2, polygonShape3, transform3);
        int n3 = polygonShape4.m_vertexCount;
        Vec2[] vec2Array = polygonShape4.m_vertices;
        this.v11.set(vec2Array[n2]);
        this.v12.set(n2 + 1 < n3 ? vec2Array[n2 + 1] : vec2Array[0]);
        this.localTangent.set(this.v12).subLocal(this.v11);
        this.localTangent.normalize();
        Vec2.crossToOut(this.localTangent, 1.0f, this.localNormal);
        this.planePoint.set(this.v11).addLocal(this.v12).mulLocal(0.5f);
        Mat22.mulToOut(transform4.R, this.localTangent, this.tangent);
        Vec2.crossToOut(this.tangent, 1.0f, this.normal);
        Transform.mulToOut(transform4, this.v11, this.v11);
        Transform.mulToOut(transform4, this.v12, this.v12);
        float f2 = Vec2.dot(this.normal, this.v11);
        float f3 = -Vec2.dot(this.tangent, this.v11) + f;
        float f4 = Vec2.dot(this.tangent, this.v12) + f;
        this.tangent.negateLocal();
        int n4 = Collision.clipSegmentToLine(this.clipPoints1, this.incidentEdge, this.tangent, f3);
        this.tangent.negateLocal();
        if (n4 < 2) {
            return;
        }
        n4 = Collision.clipSegmentToLine(this.clipPoints2, this.clipPoints1, this.tangent, f4);
        if (n4 < 2) {
            return;
        }
        manifold.localNormal.set(this.localNormal);
        manifold.localPoint.set(this.planePoint);
        int n5 = 0;
        for (int i = 0; i < Settings.maxManifoldPoints; ++i) {
            float f5 = Vec2.dot(this.normal, this.clipPoints2[i].v) - f2;
            if (!(f5 <= f)) continue;
            ManifoldPoint manifoldPoint = manifold.points[n5];
            Transform.mulTransToOut(transform3, this.clipPoints2[i].v, manifoldPoint.localPoint);
            manifoldPoint.id.set(this.clipPoints2[i].id);
            manifoldPoint.id.features.flip = n;
            ++n5;
        }
        manifold.pointCount = n5;
    }

    public static class ClipVertex {
        public final Vec2 v = new Vec2();
        public final ContactID id = new ContactID();

        public void set(ClipVertex clipVertex) {
            this.v.set(clipVertex.v);
            this.id.set(clipVertex.id);
        }
    }

    private static class EdgeResults {
        public float separation;
        public int edgeIndex;

        private EdgeResults() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PointState {
        NULL_STATE,
        ADD_STATE,
        PERSIST_STATE,
        REMOVE_STATE;

    }
}

