/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.IWorldPool;
import org.jbox2d.pooling.WorldPool;

public class AABB {
    public final Vec2 lowerBound;
    public final Vec2 upperBound;

    public AABB() {
        this.lowerBound = new Vec2();
        this.upperBound = new Vec2();
    }

    public AABB(AABB aABB) {
        this(aABB.lowerBound, aABB.upperBound);
    }

    public AABB(Vec2 vec2, Vec2 vec22) {
        this.lowerBound = vec2.clone();
        this.upperBound = vec22.clone();
    }

    public final void set(AABB aABB) {
        this.lowerBound.set(aABB.lowerBound);
        this.upperBound.set(aABB.upperBound);
    }

    public final boolean isValid() {
        float f = this.upperBound.x - this.lowerBound.x;
        if (f < 0.0f) {
            return false;
        }
        float f2 = this.upperBound.y - this.lowerBound.y;
        if (f2 < 0.0f) {
            return false;
        }
        return this.lowerBound.isValid() && this.upperBound.isValid();
    }

    public final Vec2 getCenter() {
        Vec2 vec2 = new Vec2(this.lowerBound);
        vec2.addLocal(this.upperBound);
        vec2.mulLocal(0.5f);
        return vec2;
    }

    public final void getCenterToOut(Vec2 vec2) {
        vec2.x = (this.lowerBound.x + this.upperBound.x) * 0.5f;
        vec2.y = (this.lowerBound.y + this.upperBound.y) * 0.5f;
    }

    public final Vec2 getExtents() {
        Vec2 vec2 = new Vec2(this.upperBound);
        vec2.subLocal(this.lowerBound);
        vec2.mulLocal(0.5f);
        return vec2;
    }

    public final void getExtentsToOut(Vec2 vec2) {
        vec2.x = (this.upperBound.x - this.lowerBound.x) * 0.5f;
        vec2.y = (this.upperBound.y - this.lowerBound.y) * 0.5f;
    }

    public final void getVertices(Vec2[] vec2Array) {
        vec2Array[0].set(this.lowerBound);
        vec2Array[1].set(this.lowerBound);
        vec2Array[1].x += this.upperBound.x - this.lowerBound.x;
        vec2Array[2].set(this.upperBound);
        vec2Array[3].set(this.upperBound);
        vec2Array[3].x -= this.upperBound.x - this.lowerBound.x;
    }

    public final void combine(AABB aABB, AABB aABB2) {
        this.lowerBound.x = aABB.lowerBound.x < aABB2.lowerBound.x ? aABB.lowerBound.x : aABB2.lowerBound.x;
        this.lowerBound.y = aABB.lowerBound.y < aABB2.lowerBound.y ? aABB.lowerBound.y : aABB2.lowerBound.y;
        this.upperBound.x = aABB.upperBound.x > aABB2.upperBound.x ? aABB.upperBound.x : aABB2.upperBound.x;
        this.upperBound.y = aABB.upperBound.y > aABB2.upperBound.y ? aABB.upperBound.y : aABB2.upperBound.y;
    }

    public final boolean contains(AABB aABB) {
        return this.lowerBound.x > aABB.lowerBound.x && this.lowerBound.y > aABB.lowerBound.y && aABB.upperBound.x > this.upperBound.x && aABB.upperBound.y > this.upperBound.y;
    }

    public final boolean raycast(RayCastOutput rayCastOutput, RayCastInput rayCastInput) {
        return this.raycast(rayCastOutput, rayCastInput, new WorldPool(4, 4));
    }

    public final boolean raycast(RayCastOutput rayCastOutput, RayCastInput rayCastInput, IWorldPool iWorldPool) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6 = Float.MIN_VALUE;
        float f7 = Float.MAX_VALUE;
        Vec2 vec2 = iWorldPool.popVec2();
        Vec2 vec22 = iWorldPool.popVec2();
        Vec2 vec23 = iWorldPool.popVec2();
        Vec2 vec24 = iWorldPool.popVec2();
        vec2.set(rayCastInput.p1);
        vec22.set(rayCastInput.p2).subLocal(rayCastInput.p1);
        Vec2.absToOut(vec22, vec23);
        if (vec23.x < 1.1920929E-7f) {
            if (vec2.x < this.lowerBound.x || this.upperBound.x < vec2.x) {
                iWorldPool.pushVec2(4);
                return false;
            }
        } else {
            f5 = 1.0f / vec22.x;
            f4 = (this.lowerBound.x - vec2.x) * f5;
            f3 = (this.upperBound.x - vec2.x) * f5;
            f2 = -1.0f;
            if (f4 > f3) {
                f = f4;
                f4 = f3;
                f3 = f;
                f2 = 1.0f;
            }
            if (f4 > f6) {
                vec24.setZero();
                vec24.x = f2;
                f6 = f4;
            }
            if (f6 > (f7 = MathUtils.min(f7, f3))) {
                iWorldPool.pushVec2(4);
                return false;
            }
        }
        if (vec23.y < 1.1920929E-7f) {
            if (vec2.y < this.lowerBound.y || this.upperBound.y < vec2.y) {
                iWorldPool.pushVec2(4);
                return false;
            }
        } else {
            f5 = 1.0f / vec22.y;
            f4 = (this.lowerBound.y - vec2.y) * f5;
            f3 = (this.upperBound.y - vec2.y) * f5;
            f2 = -1.0f;
            if (f4 > f3) {
                f = f4;
                f4 = f3;
                f3 = f;
                f2 = 1.0f;
            }
            if (f4 > f6) {
                vec24.setZero();
                vec24.y = f2;
                f6 = f4;
            }
            if (f6 > (f7 = MathUtils.min(f7, f3))) {
                iWorldPool.pushVec2(4);
                return false;
            }
        }
        if (f6 < 0.0f || rayCastInput.maxFraction < f6) {
            iWorldPool.pushVec2(4);
            return false;
        }
        rayCastOutput.fraction = f6;
        rayCastOutput.normal.x = vec24.x;
        rayCastOutput.normal.y = vec24.y;
        iWorldPool.pushVec2(4);
        return true;
    }

    public static final boolean testOverlap(AABB aABB, AABB aABB2) {
        if (aABB2.lowerBound.x - aABB.upperBound.x > 0.0f || aABB2.lowerBound.y - aABB.upperBound.y > 0.0f) {
            return false;
        }
        return !(aABB.lowerBound.x - aABB2.upperBound.x > 0.0f) && !(aABB.lowerBound.y - aABB2.upperBound.y > 0.0f);
    }

    public final String toString() {
        String string = "AABB[" + this.lowerBound + " . " + this.upperBound + "]";
        return string;
    }
}

