/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.callbacks;

import org.jbox2d.common.Color3f;
import org.jbox2d.common.IViewportTransform;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public abstract class DebugDraw {
    public static final int e_shapeBit = 1;
    public static final int e_jointBit = 2;
    public static final int e_aabbBit = 4;
    public static final int e_pairBit = 8;
    public static final int e_centerOfMassBit = 16;
    public static final int e_dynamicTreeBit = 32;
    protected int m_drawFlags = 0;
    protected final IViewportTransform viewportTransform;

    public DebugDraw(IViewportTransform iViewportTransform) {
        this.viewportTransform = iViewportTransform;
    }

    public void setFlags(int n) {
        this.m_drawFlags = n;
    }

    public int getFlags() {
        return this.m_drawFlags;
    }

    public void appendFlags(int n) {
        this.m_drawFlags |= n;
    }

    public void clearFlags(int n) {
        this.m_drawFlags &= ~n;
    }

    public void drawPolygon(Vec2[] vec2Array, int n, Color3f color3f) {
        if (n == 1) {
            this.drawSegment(vec2Array[0], vec2Array[0], color3f);
            return;
        }
        for (int i = 0; i < n - 1; ++i) {
            this.drawSegment(vec2Array[i], vec2Array[i + 1], color3f);
        }
        if (n > 2) {
            this.drawSegment(vec2Array[n - 1], vec2Array[0], color3f);
        }
    }

    public abstract void drawPoint(Vec2 var1, float var2, Color3f var3);

    public abstract void drawSolidPolygon(Vec2[] var1, int var2, Color3f var3);

    public abstract void drawCircle(Vec2 var1, float var2, Color3f var3);

    public abstract void drawSolidCircle(Vec2 var1, float var2, Vec2 var3, Color3f var4);

    public abstract void drawSegment(Vec2 var1, Vec2 var2, Color3f var3);

    public abstract void drawTransform(Transform var1);

    public abstract void drawString(float var1, float var2, String var3, Color3f var4);

    public IViewportTransform getViewportTranform() {
        return this.viewportTransform;
    }

    public void setCamera(float f, float f2, float f3) {
        this.viewportTransform.setCamera(f, f2, f3);
    }

    public void getScreenToWorldToOut(Vec2 vec2, Vec2 vec22) {
        this.viewportTransform.getScreenToWorld(vec2, vec22);
    }

    public void getWorldToScreenToOut(Vec2 vec2, Vec2 vec22) {
        this.viewportTransform.getWorldToScreen(vec2, vec22);
    }

    public void getWorldToScreenToOut(float f, float f2, Vec2 vec2) {
        vec2.set(f, f2);
        this.viewportTransform.getWorldToScreen(vec2, vec2);
    }

    public Vec2 getWorldToScreen(Vec2 vec2) {
        Vec2 vec22 = new Vec2();
        this.viewportTransform.getWorldToScreen(vec2, vec22);
        return vec22;
    }

    public Vec2 getWorldToScreen(float f, float f2) {
        Vec2 vec2 = new Vec2(f, f2);
        this.viewportTransform.getWorldToScreen(vec2, vec2);
        return vec2;
    }

    public void getScreenToWorldToOut(float f, float f2, Vec2 vec2) {
        vec2.set(f, f2);
        this.viewportTransform.getScreenToWorld(vec2, vec2);
    }

    public Vec2 getScreenToWorld(Vec2 vec2) {
        Vec2 vec22 = new Vec2();
        this.viewportTransform.getScreenToWorld(vec2, vec22);
        return vec22;
    }

    public Vec2 getScreenToWorld(float f, float f2) {
        Vec2 vec2 = new Vec2(f, f2);
        this.viewportTransform.getScreenToWorld(vec2, vec2);
        return vec2;
    }
}

