/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.util.Enumeration;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;

public class TestResult {
    protected Vector fFailures = new Vector();
    protected Vector fErrors = new Vector();
    protected Vector fListeners = new Vector();
    protected int fRunTests = 0;
    private boolean fStop = false;

    public synchronized void addError(Test test, Throwable t) {
        this.fErrors.addElement(new TestFailure(test, t));
        Enumeration e = this.cloneListeners().elements();
        while (e.hasMoreElements()) {
            ((TestListener)e.nextElement()).addError(test, t);
        }
    }

    public synchronized void addFailure(Test test, AssertionFailedError t) {
        this.fFailures.addElement(new TestFailure(test, t));
        Enumeration e = this.cloneListeners().elements();
        while (e.hasMoreElements()) {
            ((TestListener)e.nextElement()).addFailure(test, t);
        }
    }

    private synchronized Vector cloneListeners() {
        return (Vector)this.fListeners.clone();
    }

    public void endTest(Test test) {
        Enumeration e = this.cloneListeners().elements();
        while (e.hasMoreElements()) {
            ((TestListener)e.nextElement()).endTest(test);
        }
    }

    protected void run(final TestCase test) {
        this.startTest(test);
        Protectable p = new Protectable(){

            public void protect() throws Throwable {
                test.runBare();
            }
        };
        this.runProtected(test, p);
        this.endTest(test);
    }

    public void runProtected(Test test, Protectable p) {
        try {
            p.protect();
        }
        catch (AssertionFailedError e) {
            this.addFailure(test, e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.addError(test, e);
        }
    }

    public void startTest(Test test) {
        int count = test.countTestCases();
        TestResult testResult = this;
        synchronized (testResult) {
            this.fRunTests += count;
        }
        Enumeration e = this.cloneListeners().elements();
        while (e.hasMoreElements()) {
            ((TestListener)e.nextElement()).startTest(test);
        }
    }
}

