/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.water.view;

import edu.colorado.phet.common.jmolphet.JmolDialog;
import edu.colorado.phet.common.jmolphet.JmolUtil;
import edu.colorado.phet.common.jmolphet.Molecule;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.water.model.WaterMolecule;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import javax.swing.JFrame;
import org.jmol.api.JmolViewer;

public class Sucrose3DDialog {
    private JmolDialog jmolDialog = null;
    private boolean showJMolDialogOnActivate;
    private final JFrame parent;
    private final Color backgroundColor;

    public Sucrose3DDialog(JFrame jFrame, Color color) {
        this.parent = jFrame;
        this.backgroundColor = color;
    }

    public void showDialog() {
        if (this.jmolDialog == null) {
            this.jmolDialog = JmolDialog.displayMolecule3D(this.parent, new Molecule(){

                public String getDisplayName() {
                    return SugarAndSaltSolutionsResources.Strings.SUGAR;
                }

                public String getData() {
                    return Sucrose3DDialog.loadSucroseStructure();
                }

                public void fixJmolColors(JmolViewer jmolViewer) {
                    jmolViewer.script("color background " + Sucrose3DDialog.toJmolColor(Sucrose3DDialog.this.backgroundColor));
                    jmolViewer.script("select oxygen; color " + Sucrose3DDialog.toJmolColor(new WaterMolecule.Oxygen().color));
                    jmolViewer.script("select all");
                    JmolUtil.unbindMouse(jmolViewer);
                    JmolUtil.bindRotateLeft(jmolViewer);
                }
            }, SugarAndSaltSolutionsResources.Strings.SPACE_FILL, SugarAndSaltSolutionsResources.Strings.BALL_AND_STICK, SugarAndSaltSolutionsResources.Strings.LOADING);
            this.jmolDialog.getJmolPanel().setBackground(this.backgroundColor);
            this.jmolDialog.getJmolPanel().getLoadingText().setForeground(Color.black);
        } else {
            this.jmolDialog.setVisible(true);
        }
    }

    public void activate() {
        if (this.jmolDialog != null) {
            this.jmolDialog.setVisible(this.showJMolDialogOnActivate);
        }
    }

    public void deactivate() {
        boolean bl = this.showJMolDialogOnActivate = this.jmolDialog != null && this.jmolDialog.isVisible();
        if (this.jmolDialog != null) {
            this.jmolDialog.setVisible(false);
        }
    }

    private static String loadSucroseStructure() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(SugarAndSaltSolutionsResources.RESOURCES.getResourceAsStream("sucrose.pdb")));
            String string = "";
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                string = string + string2 + "\n";
                string2 = bufferedReader.readLine();
            }
            return string;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void reset() {
        if (this.jmolDialog != null) {
            this.jmolDialog.setVisible(false);
            this.jmolDialog = null;
        }
    }

    public static String toJmolColor(Color color) {
        return MessageFormat.format("[{0},{1},{2}]", color.getRed(), color.getGreen(), color.getBlue());
    }
}

