/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.water.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.BucketView;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Compound;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import edu.colorado.phet.sugarandsaltsolutions.water.model.WaterModel;
import edu.colorado.phet.sugarandsaltsolutions.water.view.SphericalParticleNodeWithText;
import edu.colorado.phet.sugarandsaltsolutions.water.view.WaterCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundListNode<T extends Compound<SphericalParticle>>
extends PNode {
    protected final PNode atomLayer;
    private final ModelViewTransform transform;
    private final BucketView bucketView;
    private final WaterCanvas canvas;
    private final T[] compounds;
    public final Property<Boolean> inBucket = new Property<Boolean>(true);

    public CompoundListNode(ModelViewTransform modelViewTransform, WaterModel waterModel, BucketView bucketView, PNode pNode, WaterCanvas waterCanvas, VoidFunction1<T> voidFunction1, VoidFunction1<T> voidFunction12, ObservableProperty<Boolean> observableProperty, Option<Function1<T, PNode>> option, boolean bl, ObservableProperty<Boolean> observableProperty2, ObservableProperty<Boolean> observableProperty3, T ... TArray) {
        this.transform = modelViewTransform;
        this.bucketView = bucketView;
        this.canvas = waterCanvas;
        this.compounds = TArray;
        this.atomLayer = new PNode();
        Property<Boolean> property = new Property<Boolean>(false);
        for (T t : TArray) {
            final PNode pNode2 = new PNode();
            for (Object object : t) {
                pNode2.addChild(new SphericalParticleNodeWithText(modelViewTransform, (SphericalParticle)object, observableProperty, observableProperty2));
            }
            if (option.isSome()) {
                Object object;
                final PNode pNode3 = option.get().apply(t);
                pNode2.addChild(pNode3);
                object = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        pNode2.removeChild(pNode3);
                        Point2D point2D = pNode2.getFullBounds().getCenter2D();
                        pNode2.addChild(pNode3);
                        pNode3.centerFullBoundsOnPoint(point2D.getX(), point2D.getY());
                    }
                };
                pNode2.addPropertyChangeListener("fullBounds", (PropertyChangeListener)object);
                object.propertyChange(null);
            }
            this.atomLayer.addChild(pNode2);
        }
        final CursorHandler cursorHandler = new CursorHandler();
        final PBasicInputEventHandler pBasicInputEventHandler = new PBasicInputEventHandler((Compound[])TArray, voidFunction12, property, pNode, waterCanvas, modelViewTransform, waterModel, voidFunction1, bl){
            final /* synthetic */ Compound[] val$compounds;
            final /* synthetic */ VoidFunction1 val$removeFromModel;
            final /* synthetic */ Property val$startedDragging;
            final /* synthetic */ PNode val$sugarBucketParticleLayer;
            final /* synthetic */ WaterCanvas val$canvas;
            final /* synthetic */ ModelViewTransform val$transform;
            final /* synthetic */ WaterModel val$model;
            final /* synthetic */ VoidFunction1 val$addToModel;
            final /* synthetic */ boolean val$canReturnToBucket;
            {
                this.val$compounds = compoundArray;
                this.val$removeFromModel = voidFunction1;
                this.val$startedDragging = property;
                this.val$sugarBucketParticleLayer = pNode;
                this.val$canvas = waterCanvas;
                this.val$transform = modelViewTransform;
                this.val$model = waterModel;
                this.val$addToModel = voidFunction12;
                this.val$canReturnToBucket = bl;
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                for (Compound compound : this.val$compounds) {
                    this.val$removeFromModel.apply(compound);
                }
                if (!((Boolean)this.val$startedDragging.get()).booleanValue()) {
                    this.val$startedDragging.set(true);
                    CompoundListNode.this.setIcon(false);
                    this.val$sugarBucketParticleLayer.removeChild(CompoundListNode.this);
                    this.val$canvas.addChild(CompoundListNode.this);
                    if (CompoundListNode.this.inBucket.get().booleanValue()) {
                        CompoundListNode.this.moveToBucket();
                        CompoundListNode.this.inBucket.set(false);
                    }
                }
                Dimension2D dimension2D = this.val$transform.viewToModelDelta(pInputEvent.getDeltaRelativeTo(CompoundListNode.this.getParent()));
                for (Compound compound : this.val$compounds) {
                    compound.translate(dimension2D.getWidth(), dimension2D.getHeight());
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                Rectangle2D rectangle2D = this.val$transform.viewToModel(CompoundListNode.this.atomLayer.getFullBounds()).getBounds2D();
                if (this.val$model.particleWindow.contains(rectangle2D)) {
                    CompoundListNode.this.moveToModel(this.val$addToModel);
                } else if (this.val$canReturnToBucket) {
                    CompoundListNode.this.setIcon(true);
                    CompoundListNode.this.moveToBucket();
                    CompoundListNode.this.inBucket.set(true);
                    this.val$canvas.removeChild(CompoundListNode.this);
                    this.val$sugarBucketParticleLayer.addChild(CompoundListNode.this);
                    this.val$startedDragging.set(false);
                } else {
                    for (Compound compound : this.val$compounds) {
                        compound.setPosition(this.val$model.particleWindow.getCenter());
                    }
                    CompoundListNode.this.moveToModel(this.val$addToModel);
                }
            }
        };
        observableProperty3.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue() && !CompoundListNode.this.containsListener(cursorHandler)) {
                    CompoundListNode.this.addInputEventListener(cursorHandler);
                    CompoundListNode.this.addInputEventListener(pBasicInputEventHandler);
                } else if (!bl.booleanValue() && CompoundListNode.this.containsListener(cursorHandler)) {
                    CompoundListNode.this.removeInputEventListener(cursorHandler);
                    CompoundListNode.this.removeInputEventListener(pBasicInputEventHandler);
                }
            }
        });
        this.addChild(this.atomLayer);
        this.setIcon(true);
    }

    private boolean containsListener(PInputEventListener pInputEventListener) {
        return Arrays.asList(this.getInputEventListeners()).contains(pInputEventListener);
    }

    private void moveToModel(VoidFunction1<T> voidFunction1) {
        for (T t : this.compounds) {
            voidFunction1.apply(t);
        }
        this.canvas.removeChild(this);
    }

    public void setIcon(boolean bl) {
        this.atomLayer.setScale(bl ? 0.45 : 1.0);
    }

    public void moveToBucket() {
        Point2D point2D = this.atomLayer.getGlobalFullBounds().getCenter2D();
        Point2D.Double double_ = new Point2D.Double(this.bucketView.getHoleNode().getGlobalFullBounds().getCenterX(), this.bucketView.getHoleNode().getGlobalFullBounds().getMinY());
        ImmutableVector2D immutableVector2D = new ImmutableVector2D(point2D, double_);
        Dimension2D dimension2D = this.canvas.getRootNode().globalToLocal(new PDimension(immutableVector2D.getX(), immutableVector2D.getY()));
        ImmutableVector2D immutableVector2D2 = this.transform.viewToModelDelta(new ImmutableVector2D(dimension2D.getWidth(), dimension2D.getHeight()).times(1.0 / this.atomLayer.getScale()));
        for (T t : this.compounds) {
            ((Particle)t).translate(immutableVector2D2);
        }
    }

    public void setInBucket(boolean bl) {
        this.inBucket.set(bl);
    }
}

