/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.water.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Compound;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Constituent;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaterMolecule
extends Compound<SphericalParticle> {
    static final Random random = new Random();

    public WaterMolecule() {
        this(ImmutableVector2D.ZERO, 0.0);
    }

    public WaterMolecule(ImmutableVector2D immutableVector2D, double d) {
        super(immutableVector2D, d);
        double d2 = (new SphericalParticle.FreeOxygen().radius + new SphericalParticle.Hydrogen().radius) * 0.5;
        double d3 = Math.toRadians(104.45);
        Constituent<SphericalParticle> constituent = new Constituent<SphericalParticle>(new Hydrogen(), ImmutableVector2D.createPolar(d2, d3 / 2.0));
        Constituent<SphericalParticle> constituent2 = new Constituent<SphericalParticle>(new Oxygen(), ImmutableVector2D.ZERO);
        Constituent<SphericalParticle> constituent3 = new Constituent<SphericalParticle>(new Hydrogen(), ImmutableVector2D.createPolar(d2, -d3 / 2.0));
        int n = random.nextInt(3);
        if (n == 0) {
            this.add(constituent, constituent2, constituent3);
        } else if (n == 1) {
            this.add(constituent, constituent3, constituent2);
        } else if (n == 2) {
            this.add(constituent3, constituent2, constituent);
        }
    }

    private void add(Constituent<SphericalParticle> constituent, Constituent<SphericalParticle> constituent2, Constituent<SphericalParticle> constituent3) {
        this.addConstituent(constituent);
        this.addConstituent(constituent2);
        this.addConstituent(constituent3);
    }

    public static class Hydrogen
    extends SphericalParticle.Hydrogen {
        public Hydrogen() {
            super(POSITIVE_COLOR, 0.417);
        }
    }

    public static class Oxygen
    extends SphericalParticle.Oxygen {
        public Oxygen() {
            super(NEUTRAL_COLOR, -0.834);
        }
    }
}

