/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.water.dev;

import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.sugarandsaltsolutions.common.view.PropertySlider;
import edu.colorado.phet.sugarandsaltsolutions.water.dev.DoublePropertySlider;
import edu.colorado.phet.sugarandsaltsolutions.water.model.WaterModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.LineBorder;

public class DeveloperControl
extends JPanel {
    public DeveloperControl(final WaterModel waterModel) {
        this.add(new VerticalLayoutPanel(){
            {
                this.add(new JPanel(){
                    {
                        this.add(new JButton("Add Water"){
                            {
                                this.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        waterModel.addWaterMolecule(waterModel.getRandomX(), waterModel.getRandomY(), 0.0);
                                    }
                                });
                            }
                        });
                        this.add(new JLabel("num waters:"));
                        this.add(new DoubleLabel(waterModel.waterList.size));
                    }
                });
                this.add(new JPanel(){
                    {
                        this.add(new DoublePropertySlider("coulomb strength  multiplier", 0.0, 200.0, waterModel.coulombStrengthMultiplier));
                    }
                });
                this.add(new JPanel(){
                    {
                        this.add(new DoublePropertySlider("coulomb power", 0.0, 4.0, waterModel.pow));
                    }
                });
                this.add(new JLabel("model randomness"));
                this.add(new JPanel(){
                    {
                        this.add(new PropertySlider(0, 100, waterModel.randomness));
                        this.add(new IntLabel(waterModel.randomness));
                    }
                });
                this.add(new JPanel(){
                    {
                        this.add(new DoublePropertySlider("prob. of interaction", 0.0, 1.0, waterModel.probabilityOfInteraction));
                    }
                });
                this.add(new JPanel(){
                    {
                        this.add(new DoublePropertySlider("time scale", 0.0, 1.0, waterModel.timeScale));
                    }
                });
                this.setBorder(new LineBorder(Color.black));
            }
        });
        this.add(new JSeparator(1));
        this.add(new VerticalLayoutPanel(){
            {
                this.add(new JLabel("iterations per time step"));
                this.add(new JPanel(){
                    {
                        this.add(new PropertySlider(0, 500, waterModel.iterations));
                        this.add(new IntLabel(waterModel.iterations));
                    }
                });
                this.add(new JLabel("Overlaps"));
                this.add(new JPanel(){
                    {
                        this.add(new PropertySlider(0, 20, waterModel.overlaps));
                        this.add(new IntLabel(waterModel.overlaps));
                    }
                });
                this.setBorder(new LineBorder(Color.black));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoubleLabel
    extends JLabel {
        public DoubleLabel(ObservableProperty<Double> observableProperty) {
            super(observableProperty.get() + "");
            observableProperty.addObserver(new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    DoubleLabel.this.setText(d + "");
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntLabel
    extends JLabel {
        public IntLabel(Property<Integer> property) {
            super(property.get() + "");
            property.addObserver(new VoidFunction1<Integer>(){

                @Override
                public void apply(Integer n) {
                    IntLabel.this.setText(n + "");
                }
            });
        }
    }
}

