/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.sucrose.Sucrose;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SphericalParticleNode;
import edu.colorado.phet.sugarandsaltsolutions.common.view.barchart.BarItem;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.glucose.Glucose;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumnitrate.Nitrate;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.CompositeParticleNode;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.MicroSoluteKit;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;

public class MicroSoluteKitList {
    private final ArrayList<MicroSoluteKit> kits = new ArrayList();

    public MicroSoluteKitList(final MicroModel microModel, final ModelViewTransform modelViewTransform) {
        Function0<Option<PNode>> function0 = new Function0<Option<PNode>>(){

            @Override
            public Option<PNode> apply() {
                return new Option.Some<PNode>(new SphericalParticleNode(modelViewTransform, new SphericalParticle.Sodium(), microModel.showChargeColor));
            }
        };
        Function0<Option<PNode>> function02 = new Function0<Option<PNode>>(){

            @Override
            public Option<PNode> apply() {
                return new Option.Some<PNode>(new SphericalParticleNode(modelViewTransform, new SphericalParticle.Chloride(), microModel.showChargeColor));
            }
        };
        Function0<Option<PNode>> function03 = new Function0<Option<PNode>>(){

            @Override
            public Option<PNode> apply() {
                return new Option.Some<PNode>(new CompositeParticleNode<SphericalParticle>(modelViewTransform, new Sucrose(), microModel.showChargeColor));
            }
        };
        Function0<Option<PNode>> function04 = new Function0<Option<PNode>>(){

            @Override
            public Option<PNode> apply() {
                return new Option.Some<PNode>(new CompositeParticleNode<SphericalParticle>(modelViewTransform, new Glucose(), microModel.showChargeColor));
            }
        };
        Function0<Option<PNode>> function05 = new Function0<Option<PNode>>(){

            @Override
            public Option<PNode> apply() {
                return new Option.Some<PNode>(new SphericalParticleNode(modelViewTransform, new SphericalParticle.Calcium(), microModel.showChargeColor));
            }
        };
        Function0<Option<PNode>> function06 = new Function0<Option<PNode>>(){

            @Override
            public Option<PNode> apply() {
                return new Option.Some<PNode>(new CompositeParticleNode<Particle>(modelViewTransform, new Nitrate(0.0, ImmutableVector2D.ZERO), microModel.showChargeColor));
            }
        };
        this.kits.add(new MicroSoluteKit(new BarItem(microModel.sodium, SugarAndSaltSolutionsResources.Strings.SODIUM, function0), new BarItem(microModel.chloride, SugarAndSaltSolutionsResources.Strings.CHLORIDE, function02), new BarItem(microModel.sucrose, SugarAndSaltSolutionsResources.Strings.SUCROSE, function03)));
        this.kits.add(new MicroSoluteKit(new BarItem(microModel.sodium, SugarAndSaltSolutionsResources.Strings.SODIUM, function0), new BarItem(microModel.calcium, SugarAndSaltSolutionsResources.Strings.CALCIUM, function05), new BarItem(microModel.chloride, SugarAndSaltSolutionsResources.Strings.CHLORIDE, function02)));
        this.kits.add(new MicroSoluteKit(new BarItem(microModel.sodium, SugarAndSaltSolutionsResources.Strings.SODIUM, function0), new BarItem(microModel.chloride, SugarAndSaltSolutionsResources.Strings.CHLORIDE, function02), new BarItem(microModel.nitrate, SugarAndSaltSolutionsResources.Strings.NITRATE, function06)));
        this.kits.add(new MicroSoluteKit(new BarItem(microModel.sucrose, SugarAndSaltSolutionsResources.Strings.SUCROSE, function03), new BarItem(microModel.glucose, SugarAndSaltSolutionsResources.Strings.GLUCOSE, function04)));
    }

    public MicroSoluteKit getKit(int n) {
        return this.kits.get(n);
    }
}

