/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumnitrate;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Crystal;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Formula;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumnitrate.Nitrate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SodiumNitrateCrystal
extends Crystal<Particle> {
    public static final double NITROGEN_OXYGEN_SPACING = (new SphericalParticle.Nitrogen().radius + new SphericalParticle.FreeOxygen().radius) * 0.85;

    public SodiumNitrateCrystal(ImmutableVector2D immutableVector2D, double d) {
        super(Formula.SODIUM_NITRATE, immutableVector2D, new SphericalParticle.Sodium().radius * 2.0 + NITROGEN_OXYGEN_SPACING, d);
    }

    @Override
    public Particle createPartner(Particle particle) {
        return particle instanceof SphericalParticle.Sodium ? new Nitrate() : new SphericalParticle.Sodium();
    }

    @Override
    protected Particle createConstituentParticle(Class<? extends Particle> clazz) {
        return clazz == SphericalParticle.Sodium.class ? new SphericalParticle.Sodium() : new Nitrate();
    }
}

