/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.RandomUtil;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.FlowToDrainStrategy;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.UpdateStrategy;
import java.util.Random;

public class FreeParticleStrategy
extends UpdateStrategy {
    private final Random random = new Random();

    public FreeParticleStrategy(MicroModel microModel) {
        super(microModel);
    }

    public void stepInTime(Particle particle, double d) {
        if ((Double)this.model.outputFlowRate.get() > 0.0) {
            particle.setUpdateStrategy(new FlowToDrainStrategy(this.model, new ImmutableVector2D(), false));
            particle.stepInTime(d);
        } else {
            this.randomWalk(particle, d);
        }
    }

    public void randomWalk(Particle particle, double d) {
        boolean bl;
        boolean bl2 = this.solution.shape.get().contains(particle.getShape().getBounds2D());
        if (this.solution.shape.get().contains(particle.getShape().getBounds2D())) {
            particle.setSubmerged();
        }
        ImmutableVector2D immutableVector2D = particle.getPosition();
        ImmutableVector2D immutableVector2D2 = particle.velocity.get();
        if (particle.hasSubmerged() && (Double)this.waterVolume.get() > 0.0) {
            if (particle.velocity.get().getMagnitude() == 0.0) {
                particle.velocity.set(ImmutableVector2D.createPolar(1.0, RandomUtil.randomAngle()));
            }
            particle.velocity.set(particle.velocity.get().getInstanceOfMagnitude(6.0E-10));
        }
        if (particle.velocity.get().getMagnitude() == 0.0) {
            this.model.collideWithWater(particle);
        }
        particle.stepInTime(this.model.getExternalForce(this.model.isAnyPartUnderwater(particle)).times(1.0E-10), d);
        boolean bl3 = this.solution.shape.get().contains(particle.getShape().getBounds2D());
        if (!bl2 && bl3 && particle.getPosition().getY() > this.model.beaker.getHeightForVolume((Double)this.waterVolume.get()) / 2.0) {
            this.model.collideWithWater(particle);
        }
        if (bl3) {
            double d2 = this.random.nextDouble() * Math.toRadians(30.0) * (double)MathUtil.nextRandomSign();
            particle.velocity.set(particle.velocity.get().getRotatedInstance(d2));
        }
        if (bl2 && !bl3) {
            particle.setPosition(immutableVector2D);
            particle.velocity.set(ImmutableVector2D.createPolar(immutableVector2D2.getMagnitude(), RandomUtil.randomAngle()));
        }
        this.model.preventFromLeavingBeaker(particle);
        boolean bl4 = particle.getShape().getBounds2D().intersects(this.model.solution.shape.get().getBounds2D());
        boolean bl5 = particle.getShape().getBounds2D().getMinY() < this.model.solution.shape.get().getBounds2D().getMaxY();
        boolean bl6 = bl = particle.getShape().getBounds2D().getMinY() <= this.model.solution.shape.get().getBounds().getMinY() + 1.0E-12;
        if (!bl2 && !bl3 && bl4 && bl5 && bl) {
            particle.velocity.set(ImmutableVector2D.createPolar(immutableVector2D2.getMagnitude(), RandomUtil.randomAngle()));
        }
        if ((Double)this.waterVolume.get() <= 0.0) {
            particle.velocity.set(new ImmutableVector2D(0.0, 0.0));
        }
    }
}

