/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model;

import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.CompositeDoubleProperty;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.IonConcentration;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoluteConstituent {
    public final CompositeDoubleProperty concentration;
    public final Property<Double> concentrationToDisplay;
    public final ObservableProperty<Color> color;

    public SoluteConstituent(MicroModel microModel, ObservableProperty<Color> observableProperty, Class<? extends Particle> clazz, final ObservableProperty<Boolean> observableProperty2) {
        this.concentration = new IonConcentration(microModel, clazz);
        this.concentrationToDisplay = new Property(this.concentration.get());
        this.concentration.addObserver(new ChangeObserver<Double>(){

            @Override
            public void update(Double d, Double d2) {
                if (!((Boolean)observableProperty2.get()).booleanValue()) {
                    double d3 = d - d2;
                    double d4 = SoluteConstituent.this.concentrationToDisplay.get() + d3;
                    double d5 = (Double)SoluteConstituent.this.concentration.get();
                    double d6 = 0.5;
                    double d7 = d6 * d5 + (1.0 - d6) * d4;
                    SoluteConstituent.this.concentrationToDisplay.set(d7);
                } else if ((Double)SoluteConstituent.this.concentration.get() == 0.0) {
                    SoluteConstituent.this.concentrationToDisplay.set(0.0);
                }
            }
        });
        this.color = observableProperty;
    }
}

