/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Or;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.DoubleProperty;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.LessThan;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.model.BeakerDimension;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Compound;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Crystal;
import edu.colorado.phet.sugarandsaltsolutions.common.model.DispenserType;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Formula;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SugarAndSaltSolutionModel;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Units;
import edu.colorado.phet.sugarandsaltsolutions.common.model.sucrose.Sucrose;
import edu.colorado.phet.sugarandsaltsolutions.common.model.sucrose.SucroseCrystal;
import edu.colorado.phet.sugarandsaltsolutions.common.model.sucrose.SucroseCrystalGrowth;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.CrystalMoleculeCount;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.IonColor;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModelKit;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.SoluteConstituent;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.calciumchloride.CalciumChlorideCrystal;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.calciumchloride.CalciumChlorideCrystalGrowth;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.calciumchloride.CalciumChlorideShaker;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.CrystalStrategy;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.DissolveDisconnectedCrystals;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.DrainData;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.Draining;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.RandomMotionWhileDraining;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.glucose.Glucose;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.glucose.GlucoseCrystal;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.glucose.GlucoseCrystalGrowth;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumchloride.SodiumChlorideCrystal;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumchloride.SodiumChlorideCrystalGrowth;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumchloride.SodiumChlorideShaker;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumnitrate.Nitrate;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumnitrate.SodiumNitrateCrystal;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumnitrate.SodiumNitrateCrystalGrowth;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.sodiumnitrate.SodiumNitrateShaker;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.GlucoseDispenser;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.SucroseDispenser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroModel
extends SugarAndSaltSolutionModel {
    public final ItemList<SphericalParticle> sphericalParticles = new ItemList();
    public final ItemList<Particle> freeParticles = new ItemList();
    public final ItemList<Particle> drainedParticles = new ItemList();
    public final BooleanProperty showChargeColor = new BooleanProperty(false);
    private final ObservableProperty<Boolean> anySolutes;
    public final DoubleProperty numberSoluteTypes;
    public final ArrayList<VoidFunction0> stepFinishedListeners;
    private final ObservableProperty<Color> sucroseColor;
    private final ObservableProperty<Color> glucoseColor;
    private final ObservableProperty<Color> nitrateColor;
    private final ObservableProperty<Boolean> isDraining;
    public final SoluteConstituent sodium;
    public final SoluteConstituent chloride;
    public final SoluteConstituent calcium;
    public final SoluteConstituent sucrose;
    public final SoluteConstituent glucose;
    public final SoluteConstituent nitrate;
    public final DrainData sodiumChlorideDrainData;
    public final DrainData sucroseDrainData;
    public final DrainData calciumChlorideDrainData;
    public final DrainData sodiumNitrateDrainData;
    public final DrainData glucoseDrainData;
    public final ItemList<SodiumChlorideCrystal> sodiumChlorideCrystals;
    public final ItemList<SodiumNitrateCrystal> sodiumNitrateCrystals;
    public final ItemList<CalciumChlorideCrystal> calciumChlorideCrystals;
    public final ItemList<SucroseCrystal> sucroseCrystals;
    public final ItemList<GlucoseCrystal> glucoseCrystals;
    final double sodiumChlorideSaturationPoint;
    final double calciumChlorideSaturationPoint;
    final double sodiumNitrateSaturationPoint;
    final double sucroseSaturationPoint;
    final double glucoseSaturationPoint;
    public final ObservableProperty<Boolean> sodiumChlorideSaturated;
    public final ObservableProperty<Boolean> calciumChlorideSaturated;
    public final ObservableProperty<Boolean> sucroseSaturated;
    public final ObservableProperty<Boolean> glucoseSaturated;
    public final ObservableProperty<Boolean> sodiumNitrateSaturated;
    private MicroModelKit kit;
    private static final Logger LOGGER = LoggingUtils.getLogger(MicroModel.class.getCanonicalName());
    public final Property<Integer> selectedKit;
    protected final SodiumChlorideCrystalGrowth sodiumChlorideCrystalGrowth;
    protected final SodiumNitrateCrystalGrowth sodiumNitrateCrystalGrowth;
    protected final CalciumChlorideCrystalGrowth calciumChlorideCrystalGrowth;
    protected final SucroseCrystalGrowth sucroseCrystalGrowth;
    protected final GlucoseCrystalGrowth glucoseCrystalGrowth;
    public final Draining draining;
    public final DissolveDisconnectedCrystals dissolveDisconnectedCrystals;
    public final double modelInset = 1.0E-12;

    public MicroModel() {
        super(new ConstantDtClock(30.0), new BeakerDimension(Math.pow(8.0E-26, 0.3333333333333333)), 5.0E-27, 2.8440282964793075E-10, 5.75234062238494E-10, 1.1603972084031932E9);
        this.anySolutes = new CompositeProperty<Boolean>(new Function0<Boolean>(){

            @Override
            public Boolean apply() {
                return MicroModel.this.freeParticles.size.get() > 0.0;
            }
        }, this.freeParticles.size);
        this.numberSoluteTypes = new DoubleProperty(0.0);
        this.stepFinishedListeners = new ArrayList();
        this.sucroseColor = new CompositeProperty<Color>(new Function0<Color>(){

            @Override
            public Color apply() {
                return (Boolean)MicroModel.this.showChargeColor.get() != false ? SphericalParticle.NEUTRAL_COLOR : PhetColorScheme.RED_COLORBLIND;
            }
        }, this.showChargeColor);
        this.glucoseColor = new CompositeProperty<Color>(new Function0<Color>(){

            @Override
            public Color apply() {
                return (Boolean)MicroModel.this.showChargeColor.get() != false ? SphericalParticle.NEUTRAL_COLOR : PhetColorScheme.RED_COLORBLIND;
            }
        }, this.showChargeColor);
        this.nitrateColor = new CompositeProperty<Color>(new Function0<Color>(){

            @Override
            public Color apply() {
                return (Boolean)MicroModel.this.showChargeColor.get() != false ? Color.blue : Color.blue;
            }
        }, this.showChargeColor);
        this.isDraining = this.outputFlowRate.greaterThan(0.0);
        this.sodium = new SoluteConstituent(this, new IonColor(this, new SphericalParticle.Sodium()), SphericalParticle.Sodium.class, this.isDraining);
        this.chloride = new SoluteConstituent(this, new IonColor(this, new SphericalParticle.Chloride()), SphericalParticle.Chloride.class, this.isDraining);
        this.calcium = new SoluteConstituent(this, new IonColor(this, new SphericalParticle.Calcium()), SphericalParticle.Calcium.class, this.isDraining);
        this.sucrose = new SoluteConstituent(this, this.sucroseColor, Sucrose.class, this.isDraining);
        this.glucose = new SoluteConstituent(this, this.glucoseColor, Glucose.class, this.isDraining);
        this.nitrate = new SoluteConstituent(this, this.nitrateColor, Nitrate.class, this.isDraining);
        this.sodiumChlorideDrainData = new DrainData(Formula.SODIUM_CHLORIDE);
        this.sucroseDrainData = new DrainData(Formula.SUCROSE);
        this.calciumChlorideDrainData = new DrainData(Formula.CALCIUM_CHLORIDE);
        this.sodiumNitrateDrainData = new DrainData(Formula.SODIUM_NITRATE);
        this.glucoseDrainData = new DrainData(Formula.GLUCOSE);
        this.sodiumChlorideCrystals = new ItemList();
        this.sodiumNitrateCrystals = new ItemList();
        this.calciumChlorideCrystals = new ItemList();
        this.sucroseCrystals = new ItemList();
        this.glucoseCrystals = new ItemList();
        this.sodiumChlorideSaturationPoint = Units.molesPerLiterToMolesPerMeterCubed(6.14);
        this.calciumChlorideSaturationPoint = Units.molesPerLiterToMolesPerMeterCubed(6.71);
        this.sodiumNitrateSaturationPoint = Units.molesPerLiterToMolesPerMeterCubed(10.8);
        this.sucroseSaturationPoint = Units.molesPerLiterToMolesPerMeterCubed(5.84);
        this.glucoseSaturationPoint = Units.molesPerLiterToMolesPerMeterCubed(5.05);
        this.sodiumChlorideSaturated = this.sodium.concentration.greaterThan(this.sodiumChlorideSaturationPoint).and(this.chloride.concentration.greaterThan(this.sodiumChlorideSaturationPoint));
        this.calciumChlorideSaturated = this.calcium.concentration.greaterThan(this.calciumChlorideSaturationPoint).and(this.chloride.concentration.greaterThan(this.calciumChlorideSaturationPoint * 2.0));
        this.sucroseSaturated = this.sucrose.concentration.greaterThan(this.sucroseSaturationPoint);
        this.glucoseSaturated = this.glucose.concentration.greaterThan(this.glucoseSaturationPoint);
        this.sodiumNitrateSaturated = this.sodium.concentration.greaterThan(this.sodiumNitrateSaturationPoint).and(this.nitrate.concentration.greaterThan(this.sodiumNitrateSaturationPoint));
        this.selectedKit = new Property<Integer>(Integer.valueOf(0)){
            {
                this.addObserver(new SimpleObserver(){

                    public void update() {
                        MicroModel.this.clearSolutes();
                        MicroModel.this.resetWater();
                        if ((Integer)this.get() == 0) {
                            MicroModel.this.kit = new MicroModelKit(Formula.SODIUM_CHLORIDE, Formula.SUCROSE);
                        } else if ((Integer)this.get() == 1) {
                            MicroModel.this.kit = new MicroModelKit(Formula.SODIUM_CHLORIDE, Formula.CALCIUM_CHLORIDE);
                        } else if ((Integer)this.get() == 2) {
                            MicroModel.this.kit = new MicroModelKit(Formula.SODIUM_CHLORIDE, Formula.SODIUM_NITRATE);
                        } else if ((Integer)this.get() == 3) {
                            MicroModel.this.kit = new MicroModelKit(Formula.SUCROSE, Formula.GLUCOSE);
                        } else {
                            throw new RuntimeException("Unknown kit");
                        }
                    }
                });
            }
        };
        this.sodiumChlorideCrystalGrowth = new SodiumChlorideCrystalGrowth(this, this.sodiumChlorideCrystals);
        this.sodiumNitrateCrystalGrowth = new SodiumNitrateCrystalGrowth(this, this.sodiumNitrateCrystals);
        this.calciumChlorideCrystalGrowth = new CalciumChlorideCrystalGrowth(this, this.calciumChlorideCrystals);
        this.sucroseCrystalGrowth = new SucroseCrystalGrowth(this, this.sucroseCrystals);
        this.glucoseCrystalGrowth = new GlucoseCrystalGrowth(this, this.glucoseCrystals);
        this.draining = new Draining(this);
        this.dissolveDisconnectedCrystals = new DissolveDisconnectedCrystals(this);
        this.modelInset = 1.0E-12;
        CrystalMoleculeCount<SucroseCrystal> crystalMoleculeCount = new CrystalMoleculeCount<SucroseCrystal>(this.sucroseCrystals);
        CrystalMoleculeCount<GlucoseCrystal> crystalMoleculeCount2 = new CrystalMoleculeCount<GlucoseCrystal>(this.glucoseCrystals);
        Or or = this.sphericalParticles.propertyCount(SphericalParticle.Sodium.class).lessThan(10.0).or(this.sphericalParticles.propertyCount(SphericalParticle.Chloride.class).lessThan(10.0));
        Or or2 = this.sphericalParticles.propertyCount(SphericalParticle.Calcium.class).lessThan(10.0).or(this.sphericalParticles.propertyCount(SphericalParticle.Chloride.class).lessThan(10.0));
        Or or3 = this.sphericalParticles.propertyCount(SphericalParticle.Sodium.class).lessThan(10.0).or(this.sphericalParticles.propertyCount(SphericalParticle.Oxygen.class).lessThan(30.0));
        LessThan lessThan = this.freeParticles.propertyCount(Sucrose.class).plus(crystalMoleculeCount).lessThan(10.0);
        LessThan lessThan2 = this.freeParticles.propertyCount(Glucose.class).plus(crystalMoleculeCount2).lessThan(10.0);
        this.dispensers.add(new SodiumChlorideShaker(this.beaker.getCenterX(), this.beaker.getTopY() + this.beaker.getHeight() * 0.5, this.beaker, (ObservableProperty<Boolean>)or, SugarAndSaltSolutionsResources.Strings.SODIUM_CHLORIDE_NEW_LINE, this.distanceScale, (ObservableProperty<DispenserType>)this.dispenserType, DispenserType.SALT, this));
        this.dispensers.add(new SodiumNitrateShaker(this.beaker.getCenterX(), this.beaker.getTopY() + this.beaker.getHeight() * 0.5, this.beaker, (ObservableProperty<Boolean>)or3, SugarAndSaltSolutionsResources.Strings.SODIUM_NITRATE_NEW_LINE, this.distanceScale, (ObservableProperty<DispenserType>)this.dispenserType, DispenserType.SODIUM_NITRATE, this));
        this.dispensers.add(new SucroseDispenser(this.beaker.getCenterX(), this.beaker.getTopY() + this.beaker.getHeight() * 0.5, this.beaker, (ObservableProperty<Boolean>)lessThan, SugarAndSaltSolutionsResources.Strings.SUCROSE, this.distanceScale, (ObservableProperty<DispenserType>)this.dispenserType, DispenserType.SUGAR, this));
        this.dispensers.add(new CalciumChlorideShaker(this.beaker.getCenterX(), this.beaker.getTopY() + this.beaker.getHeight() * 0.5, this.beaker, (ObservableProperty<Boolean>)or2, SugarAndSaltSolutionsResources.Strings.CALCIUM_CHLORIDE_NEW_LINE, this.distanceScale, (ObservableProperty<DispenserType>)this.dispenserType, DispenserType.CALCIUM_CHLORIDE, this));
        this.dispensers.add(new GlucoseDispenser(this.beaker.getCenterX(), this.beaker.getTopY() + this.beaker.getHeight() * 0.5, this.beaker, (ObservableProperty<Boolean>)lessThan2, SugarAndSaltSolutionsResources.Strings.GLUCOSE, this.distanceScale, (ObservableProperty<DispenserType>)this.dispenserType, DispenserType.GLUCOSE, this));
        this.outputFlowRate.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                MicroModel.this.checkStartDrain(MicroModel.this.sodiumChlorideDrainData);
                MicroModel.this.checkStartDrain(MicroModel.this.sucroseDrainData);
                MicroModel.this.checkStartDrain(MicroModel.this.calciumChlorideDrainData);
                MicroModel.this.checkStartDrain(MicroModel.this.sodiumNitrateDrainData);
                MicroModel.this.checkStartDrain(MicroModel.this.glucoseDrainData);
            }
        });
    }

    public void checkStartDrain(DrainData drainData) {
        double d = (Double)this.outputFlowRate.get() * this.faucetFlowRate;
        double d2 = (Double)this.solution.volume.get() / d;
        LOGGER.fine("clock.getDt() = " + this.clock.getDt() + ", time to drain fully: " + d2);
        if (d > 0.0 && drainData.previousDrainFlowRate == 0.0) {
            drainData.initialNumberFormulaUnits = this.countFreeFormulaUnits(drainData.formula);
            drainData.initialVolume = (Double)this.solution.volume.get();
        }
        drainData.previousDrainFlowRate = d;
    }

    public int countFreeFormulaUnits(Formula formula) {
        if (this.selectedKit.get() == 0) {
            return this.countFreeFormulaUnitsKit0(formula);
        }
        if (this.selectedKit.get() == 1) {
            return this.countFreeFormulaUnitsKit1(formula);
        }
        if (this.selectedKit.get() == 2) {
            return this.countFreeFormulaUnitsKit2(formula);
        }
        if (this.selectedKit.get() == 3) {
            return this.countFreeFormulaUnitsKit3(formula);
        }
        throw new RuntimeException("Kit not found");
    }

    private int countFreeFormulaUnitsKit0(Formula formula) {
        if (formula.equals(Formula.SODIUM_CHLORIDE)) {
            return this.freeParticles.count(SphericalParticle.Sodium.class);
        }
        if (formula.equals(Formula.SUCROSE)) {
            return this.freeParticles.count(Sucrose.class);
        }
        return 0;
    }

    private int countFreeFormulaUnitsKit1(Formula formula) {
        if (formula.equals(Formula.SODIUM_CHLORIDE)) {
            return this.freeParticles.count(SphericalParticle.Sodium.class);
        }
        if (formula.equals(Formula.CALCIUM_CHLORIDE)) {
            return this.freeParticles.count(SphericalParticle.Calcium.class);
        }
        return 0;
    }

    private int countFreeFormulaUnitsKit2(Formula formula) {
        if (formula.equals(Formula.SODIUM_CHLORIDE)) {
            return this.freeParticles.count(SphericalParticle.Chloride.class);
        }
        if (formula.equals(Formula.SODIUM_NITRATE)) {
            return this.freeParticles.count(Nitrate.class);
        }
        return 0;
    }

    private int countFreeFormulaUnitsKit3(Formula formula) {
        if (formula.equals(Formula.SUCROSE)) {
            return this.freeParticles.count(Sucrose.class);
        }
        if (formula.equals(Formula.GLUCOSE)) {
            return this.freeParticles.count(Glucose.class);
        }
        return 0;
    }

    @Override
    protected double updateModel(final double d) {
        super.updateModel(d);
        this.draining.clearParticleGroupings();
        if ((Double)this.outputFlowRate.get() > 0.0) {
            new RandomMotionWhileDraining(this).apply();
            List<DrainData> list = Arrays.asList(this.sodiumChlorideDrainData, this.sucroseDrainData, this.calciumChlorideDrainData, this.sodiumNitrateDrainData, this.glucoseDrainData);
            Collections.sort(list, new Comparator<DrainData>(){

                @Override
                public int compare(DrainData drainData, DrainData drainData2) {
                    return Double.compare(MicroModel.this.draining.getTimeToError(drainData, d), MicroModel.this.draining.getTimeToError(drainData2, d));
                }
            });
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DrainData drainData = (DrainData)iterator.next();
                this.draining.updateParticlesFlowingToDrain(drainData, d);
            }
        }
        for (Particle particle : this.joinLists(this.freeParticles, this.sodiumChlorideCrystals, this.sodiumNitrateCrystals, this.calciumChlorideCrystals, this.sucroseCrystals, this.glucoseCrystals, this.drainedParticles)) {
            particle.stepInTime(d);
        }
        this.dissolveDisconnectedCrystals.apply(this.sodiumChlorideCrystals);
        this.dissolveDisconnectedCrystals.apply(this.sodiumNitrateCrystals);
        this.dissolveDisconnectedCrystals.apply(this.calciumChlorideCrystals);
        this.dissolveDisconnectedCrystals.apply(this.sucroseCrystals);
        this.dissolveDisconnectedCrystals.apply(this.glucoseCrystals);
        this.sodiumChlorideCrystalGrowth.allowCrystalGrowth(d, this.sodiumChlorideSaturated);
        this.sucroseCrystalGrowth.allowCrystalGrowth(d, this.sucroseSaturated);
        this.glucoseCrystalGrowth.allowCrystalGrowth(d, this.glucoseSaturated);
        this.calciumChlorideCrystalGrowth.allowCrystalGrowth(d, this.calciumChlorideSaturated);
        this.sodiumNitrateCrystalGrowth.allowCrystalGrowth(d, this.sodiumNitrateSaturated);
        int n = this.kit.getFormulae().filter(new Function1<Formula, Boolean>(){

            @Override
            public Boolean apply(Formula formula) {
                return MicroModel.this.countFreeFormulaUnits(formula) > 0;
            }
        }).size();
        this.numberSoluteTypes.set((double)n + 0.0);
        for (VoidFunction0 voidFunction0 : this.stepFinishedListeners) {
            voidFunction0.apply();
        }
        return 0.0;
    }

    private ArrayList<Particle> joinLists(ItemList<? extends Particle> ... itemListArray) {
        ArrayList<Particle> arrayList = new ArrayList<Particle>();
        for (ItemList<? extends Particle> itemList : itemListArray) {
            ArrayList<? extends Particle> arrayList2 = itemList.toList();
            for (Particle particle : arrayList2) {
                arrayList.add(particle);
            }
        }
        return arrayList;
    }

    public void addSodiumChlorideCrystal(SodiumChlorideCrystal sodiumChlorideCrystal) {
        for (SphericalParticle sphericalParticle : sodiumChlorideCrystal) {
            this.sphericalParticles.add(sphericalParticle);
        }
        this.sodiumChlorideCrystals.add(sodiumChlorideCrystal);
        sodiumChlorideCrystal.setUpdateStrategy(new CrystalStrategy(this, this.sodiumChlorideCrystals, this.sodiumChlorideSaturated));
    }

    public void addSodiumNitrateCrystal(SodiumNitrateCrystal sodiumNitrateCrystal) {
        sodiumNitrateCrystal.setUpdateStrategy(new CrystalStrategy(this, this.sodiumNitrateCrystals, this.sodiumNitrateSaturated));
        this.addComponents(sodiumNitrateCrystal);
        this.sodiumNitrateCrystals.add(sodiumNitrateCrystal);
    }

    private void addComponents(Compound<? extends Particle> compound) {
        for (SphericalParticle sphericalParticle : compound.getAllSphericalParticles()) {
            this.sphericalParticles.add(sphericalParticle);
        }
    }

    public void removeComponents(Compound<?> compound) {
        for (SphericalParticle sphericalParticle : compound.getAllSphericalParticles()) {
            this.sphericalParticles.remove(sphericalParticle);
        }
    }

    public void addCalciumChlorideCrystal(CalciumChlorideCrystal calciumChlorideCrystal) {
        calciumChlorideCrystal.setUpdateStrategy(new CrystalStrategy(this, this.calciumChlorideCrystals, this.calciumChlorideSaturated));
        this.addComponents(calciumChlorideCrystal);
        this.calciumChlorideCrystals.add(calciumChlorideCrystal);
    }

    public void addSucroseCrystal(SucroseCrystal sucroseCrystal) {
        sucroseCrystal.setUpdateStrategy(new CrystalStrategy(this, this.sucroseCrystals, this.sucroseSaturated));
        this.addComponents(sucroseCrystal);
        this.sucroseCrystals.add(sucroseCrystal);
    }

    public void addGlucoseCrystal(GlucoseCrystal glucoseCrystal) {
        glucoseCrystal.setUpdateStrategy(new CrystalStrategy(this, this.glucoseCrystals, this.glucoseSaturated));
        this.addComponents(glucoseCrystal);
        this.glucoseCrystals.add(glucoseCrystal);
    }

    public void preventFromLeavingBeaker(Particle particle) {
        if (particle.hasSubmerged()) {
            this.preventFromMovingPastWaterTop(particle);
        }
        this.preventFromFallingThroughBeakerBase(particle);
        this.preventFromFallingThroughBeakerRight(particle);
        this.preventFromFallingThroughBeakerLeft(particle);
    }

    private void preventFromMovingPastWaterTop(Particle particle) {
        double d = this.solution.shape.get().getBounds2D().getMaxY();
        double d2 = particle.getShape().getBounds2D().getMaxY();
        if (d2 > d) {
            particle.translate(0.0, d - d2 - 1.0E-12);
        }
    }

    public boolean isCrystalTotallyAboveTheWater(Crystal crystal) {
        return crystal.getShape().getBounds2D().getY() > this.solution.shape.get().getBounds2D().getMaxY();
    }

    public void boundToBeakerBottom(Particle particle) {
        if (particle.getShape().getBounds2D().getMinY() < 0.0) {
            particle.translate(0.0, -particle.getShape().getBounds2D().getMinY());
        }
    }

    public ImmutableVector2D getExternalForce(boolean bl) {
        return new ImmutableVector2D(0.0, bl ? 0.0 : -9.8);
    }

    public boolean isAnyPartUnderwater(Particle particle) {
        return particle.getShape().intersects(this.solution.shape.get().getBounds2D());
    }

    public void collideWithWater(Particle particle) {
        particle.velocity.set(new ImmutableVector2D(0.0, -1.0).times(2.5E-10));
    }

    @Override
    public void reset() {
        super.reset();
        this.clearSolutes();
        this.showConcentrationValues.reset();
        this.dispenserType.reset();
        this.showChargeColor.reset();
        this.selectedKit.reset();
        this.clockRunning.reset();
    }

    public void clearSolutes() {
        this.sphericalParticles.clear();
        this.freeParticles.clear();
        this.sodiumChlorideCrystals.clear();
        this.sodiumNitrateCrystals.clear();
        this.calciumChlorideCrystals.clear();
        this.sucroseCrystals.clear();
    }

    private void updateParticlesDueToWaterLevelDropped(double d) {
        this.waterLevelDropped(this.freeParticles, d);
        this.waterLevelDropped(this.sucroseCrystals, d);
        this.waterLevelDropped(this.sodiumChlorideCrystals, d);
        this.waterLevelDropped(this.calciumChlorideCrystals, d);
        this.waterLevelDropped(this.sodiumNitrateCrystals, d);
    }

    private void waterLevelDropped(ItemList<? extends Particle> itemList, double d) {
        double d2 = this.beaker.getHeightForVolume(d) - this.beaker.getHeightForVolume(0.0);
        for (Particle particle : itemList) {
            double d3;
            double d4;
            if ((Double)this.waterVolume.get() > 0.0 && (d4 = particle.getPosition().getY()) < (d3 = this.beaker.getHeightForVolume((Double)this.waterVolume.get()))) {
                double d5 = d4 / d3;
                particle.translate(0.0, -d2 * d5);
                this.preventFromLeavingBeaker(particle);
            }
            this.preventFromFallingThroughBeakerBase(particle);
        }
    }

    private void preventFromFallingThroughBeakerBase(Particle particle) {
        double d = particle.getShape().getBounds2D().getMinY();
        if (d < 0.0) {
            particle.translate(0.0, -d + 1.0E-12);
        }
    }

    private void preventFromFallingThroughBeakerLeft(Particle particle) {
        double d = particle.getShape().getBounds2D().getMinX();
        if (d < this.beaker.getLeftWall().getX1()) {
            particle.translate(this.beaker.getLeftWall().getX1() - d, 0.0);
        }
    }

    private void preventFromFallingThroughBeakerRight(Particle particle) {
        double d = particle.getShape().getBounds2D().getMaxX();
        if (d > this.beaker.getRightWall().getX1()) {
            particle.translate(this.beaker.getRightWall().getX1() - d, 0.0);
        }
    }

    @Override
    protected void waterEvaporated(double d) {
        super.waterEvaporated(d);
        this.updateParticlesDueToWaterLevelDropped(d);
    }

    public boolean isWaterBelowCrystalThreshold() {
        return (Double)this.waterVolume.get() <= Units.litersToMetersCubed(3.0E-25);
    }
}

