/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.macro.view;

import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.sugarandsaltsolutions.GlobalState;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.model.DispenserType;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SugarAndSaltSolutionModel;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Units;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerAndShakerCanvas;
import edu.colorado.phet.sugarandsaltsolutions.common.view.CrystalMaker;
import edu.colorado.phet.sugarandsaltsolutions.common.view.DispenserRadioButtonSet;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SaltNode;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SelectableSoluteItem;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SoluteControlPanelNode;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SugarNode;
import edu.colorado.phet.sugarandsaltsolutions.common.view.VolumeIndicatorNode;
import edu.colorado.phet.sugarandsaltsolutions.macro.model.MacroModel;
import edu.colorado.phet.sugarandsaltsolutions.macro.model.MacroSalt;
import edu.colorado.phet.sugarandsaltsolutions.macro.model.MacroSugar;
import edu.colorado.phet.sugarandsaltsolutions.macro.view.ConductivityTesterToolboxNode;
import edu.colorado.phet.sugarandsaltsolutions.macro.view.ExpandableConcentrationBarChartNode;
import edu.colorado.phet.sugarandsaltsolutions.macro.view.PrecipitateNode;
import edu.colorado.phet.sugarandsaltsolutions.macro.view.RemoveSoluteControlNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class MacroCanvas
extends BeakerAndShakerCanvas {
    protected final PNode conductivityToolboxLayer = new PNode();
    public final ExpandableConcentrationBarChartNode concentrationBarChart;
    private final PNode soluteControlPanelNode;

    public MacroCanvas(final MacroModel macroModel, final GlobalState globalState) {
        super(macroModel, globalState, MacroCanvas.createMacroTransform(macroModel), false, true);
        PNode pNode = new PNode();
        this.submergedInWaterNode.addChild(pNode);
        macroModel.saltAdded.addListener(new CrystalMaker<MacroSalt>(pNode, new Function1<MacroSalt, PNode>(){

            @Override
            public PNode apply(MacroSalt macroSalt) {
                return new SaltNode(MacroCanvas.this.transform, macroSalt, globalState.colorScheme.saltColor.color);
            }
        }));
        macroModel.sugarAdded.addListener(new CrystalMaker<MacroSugar>(pNode, new Function1<MacroSugar, PNode>(){

            @Override
            public PNode apply(MacroSugar macroSugar) {
                return new SugarNode(MacroCanvas.this.transform, macroSugar, globalState.colorScheme.saltColor.color);
            }
        }));
        this.submergedInWaterNode.addChild(new PrecipitateNode(this.transform, macroModel.salt.solidVolume.plus(macroModel.sugar.solidVolume), macroModel.beaker));
        Function1<Double, String> function1 = new Function1<Double, String>(){
            final DecimalFormat decimalFormat = new DecimalFormat("0.00");

            @Override
            public String apply(Double d) {
                return this.decimalFormat.format(Units.metersCubedToLiters(d));
            }
        };
        this.addChild(new VolumeIndicatorNode(this.transform, macroModel.solution, macroModel.showConcentrationValues, macroModel.getAnySolutes(), function1));
        this.submergedInWaterNode.addChild(this.conductivityToolboxLayer);
        this.concentrationBarChart = new ExpandableConcentrationBarChartNode(macroModel.showConcentrationBarChart, macroModel.saltConcentration, macroModel.sugarConcentration, macroModel.showConcentrationValues, 1.0){
            {
                this.setOffset(MacroCanvas.this.stageSize.getWidth() - this.getFullBoundsReference().width - 5.0, 5.0);
            }
        };
        this.behindShakerNode.addChild(this.concentrationBarChart);
        this.soluteControlPanelNode = new SoluteControlPanelNode(new DispenserRadioButtonSet(macroModel.dispenserType, new SelectableSoluteItem(SugarAndSaltSolutionsResources.Strings.SALT, DispenserType.SALT), new SelectableSoluteItem(SugarAndSaltSolutionsResources.Strings.SUGAR, DispenserType.SUGAR)));
        this.soluteControlPanelNode.setOffset(this.stageSize.getWidth() - this.soluteControlPanelNode.getFullBounds().getWidth() - 5.0, 150.0);
        this.behindShakerNode.addChild(this.soluteControlPanelNode);
        this.soluteControlPanelNode.setOffset(this.concentrationBarChart.getFullBounds().getX() - this.soluteControlPanelNode.getFullBounds().getWidth() - 5.0, this.concentrationBarChart.getFullBounds().getY());
        this.conductivityToolboxLayer.addChild(new ConductivityTesterToolboxNode(macroModel, this, globalState.colorScheme.whiteBackground){
            {
                this.setOffset(MacroCanvas.this.stageSize.getWidth() - this.getFullBounds().getWidth() - 5.0, MacroCanvas.this.concentrationBarChart.getFullBounds().getMaxY() + 5.0);
            }
        });
        this.addChild(new RemoveSoluteControlNode(macroModel){
            {
                super(macroModel3);
                this.setOffset(MacroCanvas.this.transform.modelToViewX(macroModel.beaker.getMaxX()) - this.getFullBounds().getWidth() - 5.0, MacroCanvas.this.transform.modelToViewY(macroModel.beaker.getY()) - this.getFullBounds().getHeight() - 5.0);
            }
        });
    }

    public static ModelViewTransform createMacroTransform(SugarAndSaltSolutionModel sugarAndSaltSolutionModel) {
        double d = 0.75;
        return ModelViewTransform.createRectangleInvertedYMapping(sugarAndSaltSolutionModel.visibleRegion.toRectangle2D(), new Rectangle2D.Double(20.0, 135.0, (double)MacroCanvas.canvasSize.width * d, (double)MacroCanvas.canvasSize.height * d));
    }
}

