/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.view.barchart;

import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBox;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerAndShakerCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcentrationBarChart
extends PNode {
    protected final double abscissaY;
    protected final PNode background;

    public ConcentrationBarChart(final SettableProperty<Boolean> settableProperty, final SettableProperty<Boolean> settableProperty2, int n, boolean bl) {
        this.background = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, 220.0, 234 + n), BeakerAndShakerCanvas.WATER_COLOR, new BasicStroke(1.0f), Color.BLACK);
        this.addChild(this.background);
        this.abscissaY = this.background.getFullBounds().getHeight() - 60.0 - (double)n;
        this.addChild(new PhetPPath(new Line2D.Double(5.0, this.abscissaY, this.background.getFullBounds().getWidth() - 5.0, this.abscissaY), (Stroke)new BasicStroke(2.0f), (Paint)Color.black));
        this.addChild(new PText(SugarAndSaltSolutionsResources.Strings.CONCENTRATION){
            {
                this.setFont(BeakerAndShakerCanvas.TITLE_FONT);
                this.setOffset(ConcentrationBarChart.this.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, 5.0);
            }
        });
        this.addChild(new PImage(PhetCommonResources.getMinimizeButtonImage()){
            {
                super(image);
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new PBasicInputEventHandler(){

                    public void mousePressed(PInputEvent pInputEvent) {
                        settableProperty2.set(false);
                    }
                });
                this.setOffset(ConcentrationBarChart.this.background.getFullBounds().getWidth() - this.getFullBounds().getWidth() - 5.0, 5.0);
            }
        });
        settableProperty2.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                ConcentrationBarChart.this.setVisible(bl);
            }
        });
        if (bl) {
            this.addChild(new VBox(new PNode[0]){
                {
                    super(pNodeArray);
                    this.addChild(new PSwing(new PropertyCheckBox(SugarAndSaltSolutionsResources.Strings.SHOW_VALUES, settableProperty){
                        {
                            this.setFont(BeakerAndShakerCanvas.CONTROL_FONT);
                            SwingUtils.setBackgroundDeep(this, BeakerAndShakerCanvas.WATER_COLOR);
                        }
                    }));
                    this.setOffset(ConcentrationBarChart.this.background.getFullBounds().getWidth() / 2.0 - this.getFullBoundsReference().width / 2.0, ConcentrationBarChart.this.background.getHeight() - this.getFullBounds().getHeight() - 5.0);
                }
            });
        }
    }
}

